/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.tech.basic;

import com.codetaylor.mc.athenaeum.module.ModuleBase;
import com.codetaylor.mc.athenaeum.network.IPacketRegistry;
import com.codetaylor.mc.athenaeum.network.IPacketService;
import com.codetaylor.mc.athenaeum.network.tile.ITileDataService;
import com.codetaylor.mc.athenaeum.registry.Registry;
import com.codetaylor.mc.pyrotech.ModPyrotech;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasicConfig;
import com.codetaylor.mc.pyrotech.modules.tech.basic.block.BlockAnvilGranite;
import com.codetaylor.mc.pyrotech.modules.tech.basic.block.BlockAnvilIronPlated;
import com.codetaylor.mc.pyrotech.modules.tech.basic.block.BlockCampfire;
import com.codetaylor.mc.pyrotech.modules.tech.basic.block.BlockChoppingBlock;
import com.codetaylor.mc.pyrotech.modules.tech.basic.block.BlockCompactingBin;
import com.codetaylor.mc.pyrotech.modules.tech.basic.block.BlockDryingRack;
import com.codetaylor.mc.pyrotech.modules.tech.basic.block.BlockKilnPit;
import com.codetaylor.mc.pyrotech.modules.tech.basic.block.BlockSoakingPot;
import com.codetaylor.mc.pyrotech.modules.tech.basic.block.BlockWorktable;
import com.codetaylor.mc.pyrotech.modules.tech.basic.block.BlockWorktableStone;
import com.codetaylor.mc.pyrotech.modules.tech.basic.event.RecipeRepeat;
import com.codetaylor.mc.pyrotech.modules.tech.basic.init.BlockInitializer;
import com.codetaylor.mc.pyrotech.modules.tech.basic.init.ItemInitializer;
import com.codetaylor.mc.pyrotech.modules.tech.basic.init.PacketInitializer;
import com.codetaylor.mc.pyrotech.modules.tech.basic.init.RegistryInitializer;
import com.codetaylor.mc.pyrotech.modules.tech.basic.init.recipe.AnvilGraniteRecipesAdd;
import com.codetaylor.mc.pyrotech.modules.tech.basic.init.recipe.AnvilIroncladRecipesAdd;
import com.codetaylor.mc.pyrotech.modules.tech.basic.init.recipe.CampfireRecipesAdd;
import com.codetaylor.mc.pyrotech.modules.tech.basic.init.recipe.ChoppingBlockRecipesAdd;
import com.codetaylor.mc.pyrotech.modules.tech.basic.init.recipe.CompactingBinRecipesAdd;
import com.codetaylor.mc.pyrotech.modules.tech.basic.init.recipe.CrudeDryingRackRecipesAdd;
import com.codetaylor.mc.pyrotech.modules.tech.basic.init.recipe.DryingRackRecipesAdd;
import com.codetaylor.mc.pyrotech.modules.tech.basic.init.recipe.PitKilnRecipesAdd;
import com.codetaylor.mc.pyrotech.modules.tech.basic.init.recipe.SoakingPotRecipesAdd;
import com.codetaylor.mc.pyrotech.modules.tech.basic.item.ItemTinder;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.AnvilRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.CampfireRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.ChoppingBlockRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.CompactingBinRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.CrudeDryingRackRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.DryingRackRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.KilnPitRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.SoakingPotRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.WorktableRecipe;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModuleTechBasic
extends ModuleBase {
    public static final String MODULE_ID = "module.tech.basic";
    public static final String MOD_ID = "pyrotech";
    public static final CreativeTabs CREATIVE_TAB = ModPyrotech.CREATIVE_TAB;
    public static final Logger LOGGER = LogManager.getLogger((String)("pyrotech." + ModuleTechBasic.class.getSimpleName()));
    public static IPacketService PACKET_SERVICE;
    public static ITileDataService TILE_DATA_SERVICE;

    public ModuleTechBasic() {
        super(0, MOD_ID);
        String[] craftTweakerPlugins;
        this.setRegistry(new Registry(MOD_ID, CREATIVE_TAB));
        this.enableAutoRegistry();
        PACKET_SERVICE = this.enableNetwork();
        TILE_DATA_SERVICE = this.enableNetworkTileDataService(PACKET_SERVICE);
        MinecraftForge.EVENT_BUS.register((Object)this);
        for (String plugin : craftTweakerPlugins = new String[]{"ZenKilnPit", "ZenCrudeDryingRack", "ZenDryingRack", "ZenChoppingBlock", "ZenAnvilGranite", "ZenAnvilIronclad", "ZenCompactingBin", "ZenCampfire", "ZenWorktable", "ZenSoakingPot"}) {
            this.registerIntegrationPlugin("crafttweaker", "com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.crafttweaker." + plugin);
        }
        this.registerIntegrationPlugin("jei", "com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.jei.PluginJEI");
        this.registerIntegrationPlugin("gamestages", "com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.gamestages.PluginGameStages");
    }

    @SubscribeEvent
    public void onNewRegistryEvent(RegistryEvent.NewRegistry event) {
        RegistryInitializer.createRegistries(event);
    }

    public void onPreInitializationEvent(FMLPreInitializationEvent event) {
        super.onPreInitializationEvent(event);
        FMLInterModComms.sendFunctionMessage((String)"theoneprobe", (String)"getTheOneProbe", (String)"com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.top.PluginTOP$Callback");
        if (ModuleTechBasicConfig.WORKTABLE_COMMON.ALLOW_RECIPE_REPEAT) {
            MinecraftForge.EVENT_BUS.register((Object)new RecipeRepeat.RightClickBlockEventHandler());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onClientPreInitializationEvent(FMLPreInitializationEvent event) {
        super.onClientPreInitializationEvent(event);
        FMLInterModComms.sendMessage((String)"waila", (String)"register", (String)"com.codetaylor.mc.pyrotech.modules.tech.basic.plugin.waila.PluginWaila.wailaCallback");
    }

    public void onNetworkRegister(IPacketRegistry registry) {
        PacketInitializer.register(registry);
    }

    public void onRegisterRecipesEvent(RegistryEvent.Register<IRecipe> event) {
        super.onRegisterRecipesEvent(event);
        PitKilnRecipesAdd.apply(Registries.KILN_PIT_RECIPE);
        CrudeDryingRackRecipesAdd.apply(Registries.CRUDE_DRYING_RACK_RECIPE);
        DryingRackRecipesAdd.apply(Registries.DRYING_RACK_RECIPE);
        AnvilGraniteRecipesAdd.apply(Registries.ANVIL_RECIPE);
        AnvilIroncladRecipesAdd.apply(Registries.ANVIL_RECIPE);
        ChoppingBlockRecipesAdd.applyCompatRecipes(this.getConfigurationDirectory().toPath(), Registries.CHOPPING_BLOCK_RECIPE);
        CompactingBinRecipesAdd.apply(Registries.COMPACTING_BIN_RECIPE);
        SoakingPotRecipesAdd.apply(Registries.SOAKING_POT_RECIPE);
        CampfireRecipesAdd.apply(Registries.CAMPFIRE_RECIPE);
        DryingRackRecipesAdd.registerInheritedRecipes(Registries.CRUDE_DRYING_RACK_RECIPE, Registries.DRYING_RACK_RECIPE);
        AnvilIroncladRecipesAdd.registerInheritedRecipes(Registries.ANVIL_RECIPE);
    }

    public void onRegister(Registry registry) {
        BlockInitializer.onRegister(registry);
        ItemInitializer.onRegister(registry);
    }

    @SideOnly(value=Side.CLIENT)
    public void onClientRegister(Registry registry) {
        BlockInitializer.onClientRegister(registry);
        ItemInitializer.onClientRegister(registry);
    }

    public void onPostInitializationEvent(FMLPostInitializationEvent event) {
        super.onPostInitializationEvent(event);
    }

    public static class Registries {
        public static final IForgeRegistryModifiable<KilnPitRecipe> KILN_PIT_RECIPE = null;
        public static final IForgeRegistryModifiable<CrudeDryingRackRecipe> CRUDE_DRYING_RACK_RECIPE = null;
        public static final IForgeRegistryModifiable<DryingRackRecipe> DRYING_RACK_RECIPE = null;
        public static final IForgeRegistryModifiable<ChoppingBlockRecipe> CHOPPING_BLOCK_RECIPE = null;
        public static final IForgeRegistryModifiable<AnvilRecipe> ANVIL_RECIPE = null;
        public static final IForgeRegistryModifiable<CompactingBinRecipe> COMPACTING_BIN_RECIPE = null;
        public static final IForgeRegistryModifiable<CampfireRecipe> CAMPFIRE_RECIPE = null;
        public static final IForgeRegistryModifiable<WorktableRecipe> WORKTABLE_RECIPE = null;
        public static final IForgeRegistryModifiable<SoakingPotRecipe> SOAKING_POT_RECIPE = null;
    }

    @GameRegistry.ObjectHolder(value="pyrotech")
    public static class Items {
        @GameRegistry.ObjectHolder(value="tinder")
        public static final ItemTinder TINDER = null;
    }

    @GameRegistry.ObjectHolder(value="pyrotech")
    public static class Blocks {
        @GameRegistry.ObjectHolder(value="kiln_pit")
        public static final BlockKilnPit KILN_PIT = null;
        @GameRegistry.ObjectHolder(value="campfire")
        public static final BlockCampfire CAMPFIRE = null;
        @GameRegistry.ObjectHolder(value="drying_rack")
        public static final BlockDryingRack DRYING_RACK = null;
        @GameRegistry.ObjectHolder(value="chopping_block")
        public static final BlockChoppingBlock CHOPPING_BLOCK = null;
        @GameRegistry.ObjectHolder(value="anvil_granite")
        public static final BlockAnvilGranite ANVIL_GRANITE = null;
        @GameRegistry.ObjectHolder(value="anvil_iron_plated")
        public static final BlockAnvilIronPlated ANVIL_IRON_PLATED = null;
        @GameRegistry.ObjectHolder(value="worktable")
        public static final BlockWorktable WORKTABLE = null;
        @GameRegistry.ObjectHolder(value="worktable_stone")
        public static final BlockWorktableStone WORKTABLE_STONE = null;
        @GameRegistry.ObjectHolder(value="compacting_bin")
        public static final BlockCompactingBin COMPACTING_BIN = null;
        @GameRegistry.ObjectHolder(value="soaking_pot")
        public static final BlockSoakingPot SOAKING_POT = null;
    }
}

