/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.storage.tile.spi;

import com.codetaylor.mc.athenaeum.inventory.ObservableFluidTank;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataFluidTank;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileDataFluidTank;
import com.codetaylor.mc.athenaeum.util.SoundHelper;
import com.codetaylor.mc.pyrotech.interaction.api.InteractionBounds;
import com.codetaylor.mc.pyrotech.interaction.spi.IInteraction;
import com.codetaylor.mc.pyrotech.interaction.spi.ITileInteractable;
import com.codetaylor.mc.pyrotech.interaction.spi.InteractionBucketBase;
import com.codetaylor.mc.pyrotech.library.spi.tile.TileNetBase;
import com.codetaylor.mc.pyrotech.modules.core.network.SCPacketParticleCombust;
import com.codetaylor.mc.pyrotech.modules.storage.ModuleStorage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class TileTankBase
extends TileNetBase
implements ITileInteractable,
ITickable {
    private final TileDataFluidTank<Tank> tileDataFluidTank;
    private final Tank tank = new Tank(this, this.getTankCapacity());
    private final IInteraction[] interactions;
    private boolean firstLightCheck = false;

    public TileTankBase() {
        super(ModuleStorage.TILE_DATA_SERVICE);
        this.tank.addObserver((fluidTank, amount) -> this.func_70296_d());
        this.tileDataFluidTank = new TileDataFluidTank((FluidTank)this.tank);
        this.registerTileDataForNetwork(new ITileData[]{this.tileDataFluidTank});
        this.interactions = new IInteraction[]{new InteractionBucket((FluidTank)this.tank)};
    }

    public FluidTank getFluidTank() {
        return this.tank;
    }

    protected abstract int getTankCapacity();

    protected abstract boolean canHoldHotFluids();

    protected abstract int getHotFluidTemperature();

    public void func_73660_a() {
        if (!this.firstLightCheck) {
            this.firstLightCheck = true;
            this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.field_174879_c);
        }
    }

    @Override
    public void onTileDataUpdate() {
        if (this.tileDataFluidTank.isDirty()) {
            this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.field_174879_c);
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)((Object)this.tank);
        }
        return null;
    }

    protected void func_190201_b(World world) {
        this.field_145850_b = world;
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.tank.readFromNBT(compound.func_74775_l("tank"));
    }

    @Override
    public IInteraction[] getInteractions() {
        return this.interactions;
    }

    private class Tank
    extends ObservableFluidTank
    implements ITileDataFluidTank {
        private final TileTankBase tile;

        Tank(TileTankBase tile, int capacity) {
            super(capacity);
            this.tile = tile;
        }

        public int fill(FluidStack resource, boolean doFill) {
            int filled = super.fill(resource, doFill);
            if (!this.tile.canHoldHotFluids()) {
                Fluid fluid;
                World world = this.tile.field_145850_b;
                BlockPos pos = this.tile.field_174879_c;
                if (resource != null && (fluid = resource.getFluid()).getTemperature(resource) >= this.tile.getHotFluidTemperature()) {
                    if (!world.field_72995_K) {
                        world.func_175698_g(pos);
                        SoundHelper.playSoundServer((World)world, (BlockPos)pos, (SoundEvent)SoundEvents.field_187635_cQ, (SoundCategory)SoundCategory.PLAYERS);
                        FluidUtil.tryPlaceFluid(null, (World)world, (BlockPos)pos, (IFluidHandler)this, (FluidStack)resource);
                        ModuleStorage.PACKET_SERVICE.sendToAllAround((IMessage)new SCPacketParticleCombust((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.5, 0.5, 0.5), (TileEntity)this.tile);
                    }
                    world.func_180500_c(EnumSkyBlock.BLOCK, pos);
                }
            }
            return filled;
        }

        public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
            if (this.fluid != null) {
                this.fluid.writeToNBT(nbt);
            } else {
                nbt.func_74778_a("Empty", "");
            }
            return nbt;
        }

        public FluidTank readFromNBT(NBTTagCompound nbt) {
            if (nbt.func_74764_b("Empty") && (!nbt.func_74764_b("Amount") || nbt.func_74762_e("Amount") <= 0)) {
                this.setFluid(null);
                return this;
            }
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
            this.setFluid(fluid);
            return this;
        }
    }

    public class InteractionBucket
    extends InteractionBucketBase<TileTankBase> {
        private final FluidTank tank;

        InteractionBucket(FluidTank tank) {
            super((IFluidHandler)tank, EnumFacing.field_82609_l, InteractionBounds.BLOCK);
            this.tank = tank;
        }

        public FluidTank getFluidTank() {
            return this.tank;
        }
    }
}

