/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.storage.tile.spi;

import com.codetaylor.mc.athenaeum.inventory.ObservableFluidTank;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataBoolean;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataFluidTank;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileDataFluidTank;
import com.codetaylor.mc.athenaeum.util.Properties;
import com.codetaylor.mc.athenaeum.util.SoundHelper;
import com.codetaylor.mc.pyrotech.interaction.api.InteractionBounds;
import com.codetaylor.mc.pyrotech.interaction.spi.IInteraction;
import com.codetaylor.mc.pyrotech.interaction.spi.ITileInteractable;
import com.codetaylor.mc.pyrotech.library.spi.tile.TileNetBase;
import com.codetaylor.mc.pyrotech.modules.core.network.SCPacketParticleCombust;
import com.codetaylor.mc.pyrotech.modules.storage.ModuleStorage;
import com.codetaylor.mc.pyrotech.modules.storage.block.spi.BlockFaucetBase;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class TileFaucetBase
extends TileNetBase
implements ITileInteractable,
ITickable {
    private final Tank tank = new Tank(this, 1000);
    private TileDataBoolean active;
    private int filled;
    private IInteraction[] interactions;

    protected TileFaucetBase() {
        super(ModuleStorage.TILE_DATA_SERVICE);
        this.tank.addObserver((fluidTank, amount) -> this.func_70296_d());
        this.active = new TileDataBoolean(false);
        this.registerTileDataForNetwork(new ITileData[]{new TileDataFluidTank((FluidTank)this.tank), this.active});
        this.interactions = new IInteraction[]{new Interaction()};
    }

    public void toggleActive() {
        this.setActive(!this.active.get());
    }

    public void setActive(boolean active) {
        this.filled = 0;
        this.active.set(active);
    }

    public boolean isActive() {
        return this.active.get();
    }

    public FluidStack getFluid() {
        return this.tank.getFluid();
    }

    protected abstract boolean canTransferHotFluids();

    protected abstract int getHotFluidTemperature();

    protected abstract int getFluidTransferMBPerTick();

    protected abstract int getFluidTransferLimit();

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K || !this.active.get()) {
            return;
        }
        if (this.filled == this.getFluidTransferLimit()) {
            this.setActive(false);
            return;
        }
        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (!(blockState.func_177230_c() instanceof BlockFaucetBase)) {
            this.active.set(false);
            return;
        }
        EnumFacing facing = (EnumFacing)blockState.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
        TileEntity sourceTile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing.func_176734_d()));
        if (sourceTile == null) {
            this.active.set(false);
            return;
        }
        IFluidHandler source = (IFluidHandler)sourceTile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing);
        if (source == null) {
            this.active.set(false);
            return;
        }
        TileEntity targetTile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
        if (targetTile == null) {
            this.active.set(false);
            return;
        }
        IFluidHandler target = (IFluidHandler)targetTile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP);
        if (target == null) {
            this.active.set(false);
            return;
        }
        int fluidTransferMBPerTick = this.getFluidTransferMBPerTick();
        FluidStack drained = source.drain(fluidTransferMBPerTick, false);
        if (drained == null || drained.amount == 0) {
            this.active.set(false);
            return;
        }
        int filled = target.fill(drained, false);
        if (filled == 0) {
            this.active.set(false);
            return;
        }
        this.tank.drain(Integer.MAX_VALUE, true);
        drained.amount = 1000;
        this.tank.fill(drained, true);
        this.filled += filled;
        target.fill(source.drain(filled, true), true);
    }

    @Override
    public IInteraction[] getInteractions() {
        return this.interactions;
    }

    private class Tank
    extends ObservableFluidTank
    implements ITileDataFluidTank {
        private final TileFaucetBase tile;

        Tank(TileFaucetBase tile, int capacity) {
            super(capacity);
            this.tile = tile;
        }

        public int fill(FluidStack resource, boolean doFill) {
            int filled = super.fill(resource, doFill);
            if (!this.tile.canTransferHotFluids()) {
                Fluid fluid;
                World world = this.tile.field_145850_b;
                BlockPos pos = this.tile.field_174879_c;
                if (resource != null && (fluid = resource.getFluid()).getTemperature(resource) >= this.tile.getHotFluidTemperature()) {
                    world.func_175698_g(pos);
                    SoundHelper.playSoundServer((World)world, (BlockPos)pos, (SoundEvent)SoundEvents.field_187635_cQ, (SoundCategory)SoundCategory.PLAYERS);
                    ModuleStorage.PACKET_SERVICE.sendToAllAround((IMessage)new SCPacketParticleCombust((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.2, 0.2, 0.2), (TileEntity)this.tile);
                    world.func_180500_c(EnumSkyBlock.BLOCK, pos);
                }
            }
            return filled;
        }

        public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
            if (this.fluid != null) {
                this.fluid.writeToNBT(nbt);
            } else {
                nbt.func_74778_a("Empty", "");
            }
            return nbt;
        }

        public FluidTank readFromNBT(NBTTagCompound nbt) {
            if (nbt.func_74764_b("Empty") && (!nbt.func_74764_b("Amount") || nbt.func_74762_e("Amount") <= 0)) {
                this.setFluid(null);
                return this;
            }
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
            this.setFluid(fluid);
            return this;
        }
    }

    private class Interaction
    implements IInteraction {
        private Interaction() {
        }

        @Override
        public AxisAlignedBB getInteractionBounds(World world, BlockPos pos, IBlockState blockState) {
            return InteractionBounds.BLOCK;
        }

        @Override
        public boolean allowInteractionWithSide(EnumFacing facing) {
            return true;
        }

        public boolean interact(IInteraction.EnumType type, TileEntity tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
            if (!world.field_72995_K && tile instanceof TileFaucetBase) {
                ((TileFaucetBase)tile).toggleActive();
            }
            return true;
        }
    }
}

