/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.storage.tile;

import com.codetaylor.mc.athenaeum.inventory.LargeObservableStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataLargeItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.util.Properties;
import com.codetaylor.mc.pyrotech.interaction.api.Transform;
import com.codetaylor.mc.pyrotech.interaction.spi.IInteraction;
import com.codetaylor.mc.pyrotech.interaction.spi.ITileInteractable;
import com.codetaylor.mc.pyrotech.interaction.spi.InteractionItemStack;
import com.codetaylor.mc.pyrotech.library.Stages;
import com.codetaylor.mc.pyrotech.library.spi.tile.TileNetBase;
import com.codetaylor.mc.pyrotech.modules.storage.ModuleStorage;
import com.codetaylor.mc.pyrotech.modules.storage.ModuleStorageConfig;
import com.codetaylor.mc.pyrotech.modules.storage.block.BlockStash;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileStash
extends TileNetBase
implements ITileInteractable {
    private StackHandler stackHandler = new StackHandler(this.getMaxStacks());
    private IInteraction[] interactions;
    private AxisAlignedBB renderBounds;

    public TileStash() {
        super(ModuleStorage.TILE_DATA_SERVICE);
        this.stackHandler.addObserver((handler, slot) -> this.func_70296_d());
        this.registerTileDataForNetwork(new ITileData[]{new TileDataLargeItemStackHandler((ItemStackHandler)this.stackHandler)});
        this.interactions = new IInteraction[]{new Interaction(new ItemStackHandler[]{this.stackHandler})};
    }

    public boolean shouldRefresh(World world, BlockPos pos, @Nonnull IBlockState oldState, @Nonnull IBlockState newState) {
        if (oldState.func_177230_c() == newState.func_177230_c()) {
            return false;
        }
        return super.shouldRefresh(world, pos, oldState, newState);
    }

    public ItemStackHandler getStackHandler() {
        return this.stackHandler;
    }

    protected int getMaxStacks() {
        return ModuleStorageConfig.STASH.MAX_STACKS;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return this.allowAutomation() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.allowAutomation() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.stackHandler);
        }
        return null;
    }

    protected boolean allowAutomation() {
        return ModuleStorageConfig.STASH.ALLOW_AUTOMATION;
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("stackHandler", (NBTBase)this.stackHandler.serializeNBT());
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.stackHandler.deserializeNBT(compound.func_74775_l("stackHandler"));
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderBounds == null) {
            this.renderBounds = new AxisAlignedBB(this.func_174877_v()).func_72321_a(0.0, 0.5, 0.0);
        }
        return this.renderBounds;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    @Override
    @Nullable
    public Stages getStages() {
        return ModuleStorageConfig.STAGES_STASH;
    }

    @Override
    public EnumFacing getTileFacing(World world, BlockPos pos, IBlockState blockState) {
        if (blockState.func_177230_c() == ModuleStorage.Blocks.STASH || blockState.func_177230_c() == ModuleStorage.Blocks.STASH_STONE) {
            return (EnumFacing)blockState.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
        }
        return ITileInteractable.super.getTileFacing(world, pos, blockState);
    }

    @Override
    public IInteraction[] getInteractions() {
        return this.interactions;
    }

    private class StackHandler
    extends LargeObservableStackHandler
    implements ITileDataItemStackHandler {
        private final int maxStacks;

        StackHandler(int maxStacks) {
            super(1);
            this.maxStacks = maxStacks;
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return stack.func_77976_d() * this.maxStacks;
        }
    }

    private class Interaction
    extends InteractionItemStack<TileStash> {
        Interaction(ItemStackHandler[] stackHandlers) {
            super(stackHandlers, 0, new EnumFacing[]{EnumFacing.UP}, BlockStash.AABB, new Transform(Transform.translate(0.5, 0.4375, 0.5), Transform.rotate(), Transform.scale(0.75, 0.75, 0.75)));
        }

        @Override
        protected boolean doItemStackValidation(ItemStack itemStack) {
            return true;
        }

        @Override
        public Vec3d getTextOffset(EnumFacing tileFacing, EnumFacing playerHorizontalFacing, EnumFacing sideHit) {
            return new Vec3d(0.0, 0.5, 0.0);
        }
    }
}

