/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.storage.tile;

import com.codetaylor.mc.athenaeum.inventory.LargeObservableStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataLargeItemStackHandler;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileDataItemStackHandler;
import com.codetaylor.mc.athenaeum.util.Properties;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.interaction.api.Transform;
import com.codetaylor.mc.pyrotech.interaction.spi.IInteraction;
import com.codetaylor.mc.pyrotech.interaction.spi.ITileInteractable;
import com.codetaylor.mc.pyrotech.interaction.spi.InteractionItemStack;
import com.codetaylor.mc.pyrotech.library.Stages;
import com.codetaylor.mc.pyrotech.library.spi.tile.TileNetBase;
import com.codetaylor.mc.pyrotech.modules.storage.ModuleStorage;
import com.codetaylor.mc.pyrotech.modules.storage.ModuleStorageConfig;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileCrate
extends TileNetBase
implements ITileInteractable {
    private StackHandler stackHandler = new StackHandler(this.getMaxStacks());
    private IInteraction[] interactions;

    public TileCrate() {
        super(ModuleStorage.TILE_DATA_SERVICE);
        this.stackHandler.addObserver((handler, slot) -> this.func_70296_d());
        this.registerTileDataForNetwork(new ITileData[]{new TileDataLargeItemStackHandler((ItemStackHandler)this.stackHandler)});
        this.interactions = new IInteraction[12];
        ArrayList<Interaction> interactionList = new ArrayList<Interaction>();
        for (int i = 0; i < 9; ++i) {
            int x = i % 3;
            int z = i / 3;
            interactionList.add(new Interaction((ItemStackHandler)this.stackHandler, i, x, z));
        }
        this.interactions = interactionList.toArray(new IInteraction[0]);
    }

    protected int getMaxStacks() {
        return ModuleStorageConfig.CRATE.MAX_STACKS;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return this.allowAutomation() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.allowAutomation() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.stackHandler);
        }
        return null;
    }

    protected boolean allowAutomation() {
        return ModuleStorageConfig.CRATE.ALLOW_AUTOMATION;
    }

    public void dropContents() {
        StackHelper.spawnStackHandlerContentsOnTop((World)this.field_145850_b, (ItemStackHandler)this.stackHandler, (BlockPos)this.field_174879_c);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.stackHandler.deserializeNBT(compound.func_74775_l("stackHandler"));
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("stackHandler", (NBTBase)this.stackHandler.serializeNBT());
        return compound;
    }

    @Override
    @Nullable
    public Stages getStages() {
        return ModuleStorageConfig.STAGES_CRATE;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    @Override
    public EnumFacing getTileFacing(World world, BlockPos pos, IBlockState blockState) {
        if (blockState.func_177230_c() == ModuleStorage.Blocks.CRATE || blockState.func_177230_c() == ModuleStorage.Blocks.CRATE_STONE) {
            return (EnumFacing)blockState.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
        }
        return ITileInteractable.super.getTileFacing(world, pos, blockState);
    }

    @Override
    public IInteraction[] getInteractions() {
        return this.interactions;
    }

    private class StackHandler
    extends LargeObservableStackHandler
    implements ITileDataItemStackHandler {
        private final int maxStackSize;

        StackHandler(int maxStackSize) {
            super(9);
            this.maxStackSize = maxStackSize;
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return stack.func_77976_d() * this.maxStackSize;
        }
    }

    private class Interaction
    extends InteractionItemStack<TileCrate> {
        private static final double ONE_THIRD = 0.3333333333333333;
        private static final double ONE_SIXTH = 0.16666666666666666;

        Interaction(ItemStackHandler stackHandler, int slot, double x, int z) {
            super(new ItemStackHandler[]{stackHandler}, slot, new EnumFacing[]{EnumFacing.UP}, new AxisAlignedBB(x * 0.3333333333333333, 0.8125, (double)z * 0.3333333333333333, x * 0.3333333333333333 + 0.3333333333333333, 0.9375, (double)z * 0.3333333333333333 + 0.3333333333333333), new Transform(Transform.translate(x * 0.3083333333333333 + 0.16666666666666666 + 0.025, 0.9375, (double)z * 0.3083333333333333 + 0.16666666666666666 + 0.025), Transform.rotate(), Transform.scale(0.2, 0.2, 0.2)));
        }

        @Override
        public Vec3d getTextOffset(EnumFacing tileFacing, EnumFacing playerHorizontalFacing, EnumFacing sideHit) {
            return new Vec3d(0.0, 0.25, 0.0);
        }
    }
}

