/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.storage.block.spi;

import com.codetaylor.mc.athenaeum.util.Properties;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.interaction.spi.IBlockInteractable;
import com.codetaylor.mc.pyrotech.interaction.spi.IInteraction;
import com.codetaylor.mc.pyrotech.library.spi.block.BlockPartialBase;
import com.codetaylor.mc.pyrotech.modules.storage.tile.TileStash;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public abstract class BlockStashBase
extends BlockPartialBase
implements IBlockInteractable {
    public static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0);

    public BlockStashBase(float hardness, float resistance) {
        super(Material.field_151575_d);
        this.func_149711_c(hardness);
        this.func_149752_b(resistance);
        this.func_149672_a(SoundType.field_185848_a);
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        return this.interactionRayTrace(super.func_180636_a(blockState, world, pos, start, end), blockState, world, pos, start, end);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return this.interact(IInteraction.EnumType.MouseClick, world, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    @ParametersAreNonnullByDefault
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) instanceof TileStash) {
            StackHelper.spawnStackHandlerContentsOnTop((World)world, (ItemStackHandler)((TileStash)tileEntity).getStackHandler(), (BlockPos)pos);
        }
        super.func_180663_b(world, pos, state);
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        EnumFacing opposite = placer.func_174811_aO().func_176734_d();
        return this.func_176223_P().func_177226_a((IProperty)Properties.FACING_HORIZONTAL, (Comparable)opposite);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return this.createTileEntity();
    }

    protected abstract TileEntity createTileEntity();

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{Properties.FACING_HORIZONTAL});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)Properties.FACING_HORIZONTAL, (Comparable)EnumFacing.field_176754_o[meta]);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)Properties.FACING_HORIZONTAL)).func_176745_a() - 2;
    }

    @Override
    public boolean isSideSolid(IBlockState base_state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }
}

