/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.storage.block.item;

import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.Reference;
import com.codetaylor.mc.pyrotech.modules.storage.block.spi.BlockBagBase;
import com.codetaylor.mc.pyrotech.modules.storage.tile.spi.TileBagBase;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.input.Keyboard;

public class ItemBlockBag
extends ItemBlock {
    private static final int COLOR_BAG_FULL = Color.decode("0xFF0000").getRGB();
    private static final int COLOR_BAG = Color.decode("0x70341e").getRGB();
    private static final String STACK_HANDLER_TAG = "contents";
    private final BlockBagBase blockBag;

    public ItemBlockBag(BlockBagBase blockBag) {
        super((Block)blockBag);
        this.blockBag = blockBag;
        this.func_77625_d(1);
    }

    public boolean isOpen(ItemStack itemStack) {
        return itemStack.func_77960_j() == 1;
    }

    public boolean isItemValidForInsertion(ItemStack itemStack) {
        return this.blockBag.isItemValidForInsertion(itemStack);
    }

    public boolean allowAutoPickupMainhand() {
        return this.blockBag.allowAutoPickupMainhand();
    }

    public boolean allowAutoPickupOffhand() {
        return this.blockBag.allowAutoPickupOffhand();
    }

    public boolean allowAutoPickupHotbar() {
        return this.blockBag.allowAutoPickupHotbar();
    }

    public boolean allowAutoPickupInventory() {
        return this.blockBag.allowAutoPickupInventory();
    }

    private int getItemCapacity() {
        return this.blockBag.getItemCapacity();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getCount(stack) / (double)this.getItemCapacity();
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getCount(stack) > 0;
    }

    public int getRGBDurabilityForDisplay(@Nonnull ItemStack stack) {
        if (this.getCount(stack) == this.getItemCapacity()) {
            return COLOR_BAG_FULL;
        }
        return COLOR_BAG;
    }

    public static ItemStack insertItem(ItemStack bag, ItemStack itemStack, boolean simulate) {
        TileBagBase.StackHandler stackHandler = ItemBlockBag.getStackHandler(bag);
        if (stackHandler == null) {
            return itemStack;
        }
        ItemStack result = stackHandler.insertItem(itemStack, simulate);
        if (!simulate) {
            // empty if block
        }
        return result;
    }

    private static TileBagBase.StackHandler getStackHandler(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        if (item instanceof ItemBlockBag) {
            ItemBlockBag itemBlockBag = (ItemBlockBag)item;
            NBTTagCompound tagCompound = StackHelper.getTagSafe((ItemStack)itemStack);
            TileBagBase.StackHandler stackHandler = new TileBagBase.StackHandler(itemBlockBag.getItemCapacity(), itemBlockBag.blockBag::isItemValidForInsertion);
            stackHandler.addObserver((handler, slot) -> {
                itemBlockBag.setCount(itemStack, stackHandler);
                itemBlockBag.saveStackHandler(itemStack, stackHandler);
            });
            if (!tagCompound.func_74764_b(STACK_HANDLER_TAG)) {
                tagCompound.func_74782_a(STACK_HANDLER_TAG, (NBTBase)stackHandler.serializeNBT());
            } else {
                NBTTagCompound compound = tagCompound.func_74775_l(STACK_HANDLER_TAG);
                stackHandler.deserializeNBT(compound);
            }
            itemBlockBag.setCount(itemStack, stackHandler);
            return stackHandler;
        }
        return null;
    }

    private void saveStackHandler(ItemStack itemStack, TileBagBase.StackHandler handler) {
        NBTTagCompound compound = StackHelper.getTagSafe((ItemStack)itemStack);
        compound.func_74782_a(STACK_HANDLER_TAG, (NBTBase)handler.serializeNBT());
    }

    public int getCount(ItemStack itemStack) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            return -1;
        }
        return tagCompound.func_74762_e("count");
    }

    private void setCount(ItemStack itemStack, TileBagBase.StackHandler handler) {
        NBTTagCompound tag = StackHelper.getTagSafe((ItemStack)itemStack);
        int count = handler.getTotalItemCount();
        tag.func_74768_a("count", count);
    }

    @ParametersAreNonnullByDefault
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        int totalCount = this.getCount(stack);
        if (totalCount == -1) {
            tooltip.add(I18n.func_74837_a((String)"gui.pyrotech.tooltip.item.capacity.empty", (Object[])new Object[]{this.getItemCapacity()}));
            return;
        }
        tooltip.add(I18n.func_74837_a((String)"gui.pyrotech.tooltip.item.capacity", (Object[])new Object[]{totalCount, this.getItemCapacity()}));
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            ItemStack stackInSlot;
            int i;
            TileBagBase.StackHandler stackHandler = ItemBlockBag.getStackHandler(stack);
            if (stackHandler == null) {
                return;
            }
            int maxDigits = 0;
            for (i = 0; i < stackHandler.getSlots(); ++i) {
                int count;
                int digits;
                stackInSlot = stackHandler.getStackInSlot(i);
                if (stackInSlot.func_190926_b() || (digits = String.valueOf(count = stackInSlot.func_190916_E()).length()) <= maxDigits) continue;
                maxDigits = digits;
            }
            for (i = 0; i < stackHandler.getSlots(); ++i) {
                stackInSlot = stackHandler.getStackInSlot(i);
                if (stackInSlot.func_190926_b()) continue;
                String stackCount = String.valueOf(stackInSlot.func_190916_E());
                stackCount = stackCount.length() < maxDigits ? TextFormatting.DARK_GRAY + StringUtils.repeat((String)"0", (int)(maxDigits - stackCount.length())).concat(TextFormatting.YELLOW + stackCount) : TextFormatting.YELLOW + stackCount;
                tooltip.add(" " + stackCount + " " + TextFormatting.GOLD + stackInSlot.func_82833_r());
            }
        } else {
            tooltip.add(I18n.func_74837_a((String)"gui.pyrotech.tooltip.extended.shift", (Object[])new Object[]{Reference.Tooltip.COLOR_EXTENDED_INFO, TextFormatting.GRAY}));
        }
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, @Nonnull BlockPos pos, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity;
        ItemStack heldItem = player.func_184586_b(hand);
        TileBagBase.StackHandler stackHandler = ItemBlockBag.getStackHandler(heldItem);
        if (stackHandler == null) {
            return EnumActionResult.PASS;
        }
        if (player.func_70093_af()) {
            if (this.tryTransferItems(world, pos, facing, heldItem)) {
                return EnumActionResult.SUCCESS;
            }
            if (this.isOpen(heldItem) && this.trySpillContents(world, pos, facing, heldItem)) {
                return EnumActionResult.SUCCESS;
            }
        }
        ItemStack copy = heldItem.func_77946_l();
        EnumActionResult result = super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
        if (result == EnumActionResult.SUCCESS && (tileEntity = world.func_175625_s(pos.func_177972_a(facing))) instanceof TileBagBase) {
            TileBagBase.StackHandler itemHandler = ItemBlockBag.getStackHandler(copy);
            TileBagBase.StackHandler tileHandler = ((TileBagBase)tileEntity).getStackHandler();
            if (itemHandler != null && tileHandler != null) {
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    ItemStack stackInSlot = itemHandler.getStackInSlot(i);
                    tileHandler.setStackInSlot(i, stackInSlot);
                }
            }
        }
        return result;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        RayTraceResult rayTraceResult = this.func_77621_a(world, player, false);
        ItemStack heldItem = player.func_184586_b(hand);
        if (player.func_70093_af() && (rayTraceResult == null || rayTraceResult.field_72313_a == RayTraceResult.Type.MISS)) {
            heldItem.func_77964_b(heldItem.func_77952_i() == 0 ? 1 : 0);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)heldItem);
        }
        return super.func_77659_a(world, player, hand);
    }

    private boolean trySpillContents(World world, BlockPos pos, EnumFacing facing, ItemStack itemStack) {
        TileBagBase.StackHandler handler;
        if (world.func_175623_d(pos.func_177972_a(facing)) && (handler = ItemBlockBag.getStackHandler(itemStack)) != null) {
            if (!world.field_72995_K) {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    StackHelper.spawnStackHandlerContentsOnTop((World)world, (ItemStackHandler)handler, (BlockPos)pos.func_177972_a(facing), (double)0.0);
                }
            }
            return true;
        }
        return false;
    }

    private boolean tryTransferItems(World world, BlockPos pos, EnumFacing facing, ItemStack itemStack) {
        TileBagBase.StackHandler itemHandler = ItemBlockBag.getStackHandler(itemStack);
        if (itemHandler == null) {
            return false;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity == null) {
            return false;
        }
        IItemHandler otherHandler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing);
        if (otherHandler == null) {
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(i);
            if (stackInSlot.func_190926_b()) continue;
            ItemStack remainingItems = stackInSlot.func_77946_l();
            for (int j = 0; j < otherHandler.getSlots() && !(remainingItems = otherHandler.insertItem(j, remainingItems, false)).func_190926_b(); ++j) {
            }
            if (stackInSlot.func_190916_E() == remainingItems.func_190916_E()) continue;
            itemHandler.setStackInSlot(i, remainingItems);
        }
        return true;
    }
}

