/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.storage.block;

import com.codetaylor.mc.athenaeum.spi.IBlockVariant;
import com.codetaylor.mc.athenaeum.spi.IVariant;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.interaction.spi.IBlockInteractable;
import com.codetaylor.mc.pyrotech.interaction.spi.IInteraction;
import com.codetaylor.mc.pyrotech.library.spi.block.BlockPartialBase;
import com.codetaylor.mc.pyrotech.modules.storage.ModuleStorageConfig;
import com.codetaylor.mc.pyrotech.modules.storage.tile.TileTankBrick;
import com.codetaylor.mc.pyrotech.modules.storage.tile.TileTankStone;
import com.codetaylor.mc.pyrotech.modules.storage.tile.spi.TileTankBase;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class BlockTank
extends BlockPartialBase
implements IBlockVariant<EnumType>,
IBlockInteractable {
    public static final String NAME = "tank";
    public static final IProperty<EnumType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumType.class);

    public BlockTank() {
        super(Material.field_151576_e);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149711_c(2.0f);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileTankBase) {
            TileTankBase tile = (TileTankBase)tileEntity;
            FluidTank fluidTank = tile.getFluidTank();
            FluidStack fluid = fluidTank.getFluid();
            int fluidAmount = fluidTank.getFluidAmount();
            if (fluid != null && fluidAmount > 0) {
                int luminosity = fluid.getFluid().getLuminosity(fluid);
                return MathHelper.func_76125_a((int)luminosity, (int)0, (int)15);
            }
        }
        return super.getLightValue(state, world, pos);
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        RayTraceResult result = super.func_180636_a(blockState, world, pos, start, end);
        return this.interactionRayTrace(result, blockState, world, pos, start, end);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return this.interact(IInteraction.EnumType.MouseClick, world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(@Nonnull World world, EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
        if (!world.field_72995_K) {
            world.func_175698_g(pos);
        }
    }

    public void getDrops(@Nonnull NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        if (this.canHoldContentsWhenBroken(state)) {
            drops.add((Object)StackHelper.createItemStackFromTileEntity((Block)this, (int)1, (int)((EnumType)((Object)state.func_177229_b(TYPE))).getMeta(), (TileEntity)world.func_175625_s(pos)));
        } else {
            super.getDrops(drops, world, pos, state, fortune);
        }
    }

    private boolean canHoldContentsWhenBroken(IBlockState blockState) {
        EnumType type = (EnumType)((Object)blockState.func_177229_b(TYPE));
        switch (type) {
            case STONE: {
                return ModuleStorageConfig.STONE_TANK.HOLDS_CONTENTS_WHEN_BROKEN;
            }
            case BRICK: {
                return ModuleStorageConfig.BRICK_TANK.HOLDS_CONTENTS_WHEN_BROKEN;
            }
        }
        throw new RuntimeException("Unknown tank type: " + (Object)((Object)type));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        EnumType type = (EnumType)((Object)state.func_177229_b(TYPE));
        if (type == EnumType.STONE) {
            return new TileTankStone();
        }
        if (type == EnumType.BRICK) {
            return new TileTankBrick();
        }
        return null;
    }

    @Override
    public boolean isSideSolid(IBlockState base_state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, EnumFacing side) {
        return true;
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public void func_190948_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flag) {
        NBTTagCompound tileTag;
        NBTTagCompound stackTag = stack.func_77978_p();
        EnumType type = EnumType.fromMeta(stack.func_77960_j());
        if (stackTag == null) {
            this.addInformationCapacity(tooltip, type);
        } else if (stackTag.func_74764_b("BlockEntityTag") && (tileTag = stackTag.func_74775_l("BlockEntityTag")).func_74764_b(NAME)) {
            NBTTagCompound tankTag = tileTag.func_74775_l(NAME);
            if (tankTag.func_74764_b("Empty") && (!tankTag.func_74764_b("Amount") || tankTag.func_74762_e("Amount") <= 0)) {
                this.addInformationCapacity(tooltip, type);
            } else {
                FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tankTag);
                if (fluidStack != null) {
                    String localizedName = fluidStack.getLocalizedName();
                    int amount = fluidStack.amount;
                    if (type == EnumType.STONE) {
                        int capacity = ModuleStorageConfig.STONE_TANK.CAPACITY;
                        tooltip.add(I18n.func_74837_a((String)"gui.pyrotech.tooltip.fluid", (Object[])new Object[]{localizedName, amount, capacity}));
                    } else if (type == EnumType.BRICK) {
                        int capacity = ModuleStorageConfig.BRICK_TANK.CAPACITY;
                        tooltip.add(I18n.func_74837_a((String)"gui.pyrotech.tooltip.fluid", (Object[])new Object[]{localizedName, amount, capacity}));
                    }
                }
            }
        }
        if (type == EnumType.STONE) {
            boolean hotFluids = ModuleStorageConfig.STONE_TANK.HOLDS_HOT_FLUIDS;
            tooltip.add((hotFluids ? TextFormatting.GREEN : TextFormatting.RED) + I18n.func_74837_a((String)("gui.pyrotech.tooltip.hot.fluids." + hotFluids), (Object[])new Object[0]));
            boolean holdsContents = ModuleStorageConfig.STONE_TANK.HOLDS_CONTENTS_WHEN_BROKEN;
            tooltip.add((holdsContents ? TextFormatting.GREEN : TextFormatting.RED) + I18n.func_74837_a((String)("gui.pyrotech.tooltip.contents.retain." + holdsContents), (Object[])new Object[0]));
        } else if (type == EnumType.BRICK) {
            boolean hotFluids = ModuleStorageConfig.BRICK_TANK.HOLDS_HOT_FLUIDS;
            tooltip.add((hotFluids ? TextFormatting.GREEN : TextFormatting.RED) + I18n.func_74837_a((String)("gui.pyrotech.tooltip.hot.fluids." + hotFluids), (Object[])new Object[0]));
            boolean holdsContents = ModuleStorageConfig.BRICK_TANK.HOLDS_CONTENTS_WHEN_BROKEN;
            tooltip.add((holdsContents ? TextFormatting.GREEN : TextFormatting.RED) + I18n.func_74837_a((String)("gui.pyrotech.tooltip.contents.retain." + holdsContents), (Object[])new Object[0]));
        }
    }

    private void addInformationCapacity(@Nonnull List<String> tooltip, EnumType type) {
        if (type == EnumType.STONE) {
            int capacity = ModuleStorageConfig.STONE_TANK.CAPACITY;
            tooltip.add(I18n.func_74837_a((String)"gui.pyrotech.tooltip.fluid.capacity", (Object[])new Object[]{capacity}));
        } else if (type == EnumType.BRICK) {
            int capacity = ModuleStorageConfig.BRICK_TANK.CAPACITY;
            tooltip.add(I18n.func_74837_a((String)"gui.pyrotech.tooltip.fluid.capacity", (Object[])new Object[]{capacity}));
        }
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(TYPE))).getMeta();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumType.fromMeta(meta)));
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(TYPE))).getMeta();
    }

    @Nonnull
    public String getModelName(ItemStack itemStack) {
        return EnumType.fromMeta(itemStack.func_77960_j()).func_176610_l();
    }

    @Nonnull
    public IProperty<EnumType> getVariant() {
        return TYPE;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EnumType type : EnumType.values()) {
            list.add((Object)new ItemStack((Block)this, 1, type.getMeta()));
        }
    }

    public static enum EnumType implements IVariant
    {
        STONE(0, "stone"),
        BRICK(1, "brick");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        public static EnumType fromMeta(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = (EnumType[])Stream.of(EnumType.values()).sorted(Comparator.comparing(EnumType::getMeta)).toArray(EnumType[]::new);
        }
    }
}

