/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.storage;

import com.codetaylor.mc.athenaeum.module.ModuleBase;
import com.codetaylor.mc.athenaeum.network.IPacketService;
import com.codetaylor.mc.athenaeum.network.tile.ITileDataService;
import com.codetaylor.mc.athenaeum.registry.Registry;
import com.codetaylor.mc.pyrotech.ModPyrotech;
import com.codetaylor.mc.pyrotech.modules.storage.block.BlockBagDurable;
import com.codetaylor.mc.pyrotech.modules.storage.block.BlockBagSimple;
import com.codetaylor.mc.pyrotech.modules.storage.block.BlockCrate;
import com.codetaylor.mc.pyrotech.modules.storage.block.BlockCrateStone;
import com.codetaylor.mc.pyrotech.modules.storage.block.BlockFaucetBrick;
import com.codetaylor.mc.pyrotech.modules.storage.block.BlockFaucetStone;
import com.codetaylor.mc.pyrotech.modules.storage.block.BlockShelf;
import com.codetaylor.mc.pyrotech.modules.storage.block.BlockShelfStone;
import com.codetaylor.mc.pyrotech.modules.storage.block.BlockStash;
import com.codetaylor.mc.pyrotech.modules.storage.block.BlockStashStone;
import com.codetaylor.mc.pyrotech.modules.storage.block.BlockTank;
import com.codetaylor.mc.pyrotech.modules.storage.block.BlockWoodRack;
import com.codetaylor.mc.pyrotech.modules.storage.client.render.TESRFaucet;
import com.codetaylor.mc.pyrotech.modules.storage.event.ConfigChangedEventHandler;
import com.codetaylor.mc.pyrotech.modules.storage.event.EntityItemPickupEventHandler;
import com.codetaylor.mc.pyrotech.modules.storage.init.BlockInitializer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModuleStorage
extends ModuleBase {
    public static final String MODULE_ID = "module.storage";
    public static final String MOD_ID = "pyrotech";
    public static final CreativeTabs CREATIVE_TAB = ModPyrotech.CREATIVE_TAB;
    public static final Logger LOGGER = LogManager.getLogger((String)("pyrotech." + ModuleStorage.class.getSimpleName()));
    public static IPacketService PACKET_SERVICE;
    public static ITileDataService TILE_DATA_SERVICE;

    public ModuleStorage() {
        super(0, MOD_ID);
        String[] craftTweakerPlugins;
        this.setRegistry(new Registry(MOD_ID, CREATIVE_TAB));
        this.enableAutoRegistry();
        PACKET_SERVICE = this.enableNetwork();
        TILE_DATA_SERVICE = this.enableNetworkTileDataService(PACKET_SERVICE);
        MinecraftForge.EVENT_BUS.register((Object)this);
        for (String plugin : craftTweakerPlugins = new String[]{"ZenDurableRockBag", "ZenSimpleRockBag", "ZenStoneTank", "ZenBrickTank", "ZenWoodRack", "ZenCrate", "ZenDurableCrate", "ZenShelf", "ZenDurableShelf", "ZenStash", "ZenDurableStash", "ZenFaucetStone", "ZenFaucetBrick"}) {
            this.registerIntegrationPlugin("crafttweaker", "com.codetaylor.mc.pyrotech.modules.storage.plugin.crafttweaker." + plugin);
        }
    }

    public void onPreInitializationEvent(FMLPreInitializationEvent event) {
        super.onPreInitializationEvent(event);
        FMLInterModComms.sendFunctionMessage((String)"theoneprobe", (String)"getTheOneProbe", (String)"com.codetaylor.mc.pyrotech.modules.storage.plugin.top.PluginTOP$Callback");
        MinecraftForge.EVENT_BUS.register((Object)new EntityItemPickupEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ConfigChangedEventHandler());
    }

    @SideOnly(value=Side.CLIENT)
    public void onClientPreInitializationEvent(FMLPreInitializationEvent event) {
        super.onClientPreInitializationEvent(event);
        FMLInterModComms.sendMessage((String)"waila", (String)"register", (String)"com.codetaylor.mc.pyrotech.modules.storage.plugin.waila.PluginWaila.wailaCallback");
    }

    @SideOnly(value=Side.CLIENT)
    public void onClientPostInitializationEvent(FMLPostInitializationEvent event) {
        super.onClientPostInitializationEvent(event);
        TESRFaucet.updateBlockMatchersFromConfig();
    }

    public void onRegister(Registry registry) {
        BlockInitializer.onRegister(registry);
    }

    @SideOnly(value=Side.CLIENT)
    public void onClientRegister(Registry registry) {
        BlockInitializer.onClientRegister(registry);
    }

    @GameRegistry.ObjectHolder(value="pyrotech")
    public static class Blocks {
        @GameRegistry.ObjectHolder(value="shelf")
        public static final BlockShelf SHELF = null;
        @GameRegistry.ObjectHolder(value="shelf_stone")
        public static final BlockShelfStone SHELF_STONE;
        @GameRegistry.ObjectHolder(value="stash")
        public static final BlockStash STASH;
        @GameRegistry.ObjectHolder(value="stash_stone")
        public static final BlockStashStone STASH_STONE;
        @GameRegistry.ObjectHolder(value="crate")
        public static final BlockCrate CRATE;
        @GameRegistry.ObjectHolder(value="crate_stone")
        public static final BlockCrateStone CRATE_STONE;
        @GameRegistry.ObjectHolder(value="wood_rack")
        public static final BlockWoodRack WOOD_RACK;
        @GameRegistry.ObjectHolder(value="tank")
        public static final BlockTank TANK;
        @GameRegistry.ObjectHolder(value="bag_simple")
        public static final BlockBagSimple BAG_SIMPLE;
        @GameRegistry.ObjectHolder(value="bag_durable")
        public static final BlockBagDurable BAG_DURABLE;
        @GameRegistry.ObjectHolder(value="faucet_stone")
        public static final BlockFaucetStone FAUCET_STONE;
        @GameRegistry.ObjectHolder(value="faucet_brick")
        public static final BlockFaucetBrick FAUCET_BRICK;

        static {
            STASH = null;
            CRATE = null;
            SHELF_STONE = null;
            STASH_STONE = null;
            CRATE_STONE = null;
            WOOD_RACK = null;
            TANK = null;
            BAG_SIMPLE = null;
            BAG_DURABLE = null;
            FAUCET_STONE = null;
            FAUCET_BRICK = null;
        }
    }
}

