/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.plugin.patchouli.processors;

import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.WorktableRecipe;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariableProvider;
import vazkii.patchouli.common.util.ItemStackUtil;

public class WorktableRecipeProcessor
implements IComponentProcessor {
    @Nullable
    private WorktableRecipe recipe;

    public void setup(IVariableProvider<String> variables) {
        String recipe = (String)variables.get("recipe");
        ResourceLocation key = new ResourceLocation(recipe);
        this.recipe = (WorktableRecipe)ModuleTechBasic.Registries.WORKTABLE_RECIPE.getValue(key);
    }

    public String process(String key) {
        if (this.recipe != null) {
            IRecipe iRecipe = this.recipe.getRecipe();
            if (key.startsWith("item")) {
                int index = Integer.parseInt(key.substring(4)) - 1;
                Ingredient ingredient = (Ingredient)iRecipe.func_192400_c().get(index);
                ItemStack[] stacks = ingredient.func_193365_a();
                ItemStack stack = stacks.length == 0 ? ItemStack.field_190927_a : stacks[0];
                return ItemStackUtil.serializeStack((ItemStack)stack);
            }
            if (key.equals("output")) {
                return ItemStackUtil.serializeStack((ItemStack)iRecipe.func_77571_b());
            }
            if (key.equals("tool")) {
                List<Item> toolList = this.recipe.getToolList();
                if (!toolList.isEmpty()) {
                    Ingredient ingredient = Ingredient.func_193368_a((Item[])toolList.toArray(new Item[0]));
                    return ItemStackUtil.serializeIngredient((Ingredient)ingredient);
                }
                return "";
            }
            if (key.equals("tool_damage")) {
                List<Item> toolList = this.recipe.getToolList();
                if (!toolList.isEmpty()) {
                    return String.valueOf(this.recipe.getToolDamage());
                }
                return "";
            }
        }
        return null;
    }
}

