/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.plugin.patchouli.processors;

import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.AnvilRecipe;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariableProvider;
import vazkii.patchouli.common.util.ItemStackUtil;

public class AnvilRecipeProcessor
implements IComponentProcessor {
    @Nullable
    private AnvilRecipe recipe;

    public void setup(IVariableProvider<String> variables) {
        String recipe = (String)variables.get("recipe");
        ResourceLocation key = new ResourceLocation(recipe);
        this.recipe = (AnvilRecipe)ModuleTechBasic.Registries.ANVIL_RECIPE.getValue(key);
    }

    public String process(String key) {
        if (this.recipe != null) {
            if ("input".equals(key)) {
                return ItemStackUtil.serializeIngredient((Ingredient)this.recipe.getInput());
            }
            if ("output".equals(key)) {
                return ItemStackUtil.serializeStack((ItemStack)this.recipe.getOutput());
            }
            if ("pickaxe".equals(key)) {
                return this.recipe.getType() == AnvilRecipe.EnumType.PICKAXE ? "t" : "";
            }
            if ("hammer".equals(key)) {
                return this.recipe.getType() == AnvilRecipe.EnumType.HAMMER ? "t" : "";
            }
            if ("granite".equals(key)) {
                return this.recipe.isTier(AnvilRecipe.EnumTier.GRANITE) ? "t" : "";
            }
            if ("ironclad".equals(key)) {
                return this.recipe.isTier(AnvilRecipe.EnumTier.IRONCLAD) && !this.recipe.isTier(AnvilRecipe.EnumTier.GRANITE) ? "t" : "";
            }
        }
        return null;
    }
}

