/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.patreon;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="pyrotech")
public class PlayerEntityTracker {
    private static final ThreadLocal<List<EntityPlayer>> PLAYER_LIST = ThreadLocal.withInitial(ArrayList::new);
    private static final ThreadLocal<Map<UUID, EntityPlayer>> PLAYER_MAP = ThreadLocal.withInitial(HashMap::new);

    @Nullable
    public static EntityPlayer getEntityForPlayer(UUID uuid) {
        Map<UUID, EntityPlayer> playerMap = PLAYER_MAP.get();
        return playerMap.get(uuid);
    }

    @SubscribeEvent
    public static void on(EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof EntityPlayer) {
            List<EntityPlayer> playerList = PLAYER_LIST.get();
            Map<UUID, EntityPlayer> playerMap = PLAYER_MAP.get();
            EntityPlayer entityPlayer = (EntityPlayer)entity;
            playerList.removeIf(p -> p.func_110124_au().equals(entity.func_110124_au()));
            playerMap.remove(entity.func_110124_au());
            playerList.add(entityPlayer);
            playerMap.put(entityPlayer.func_110124_au(), entityPlayer);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void on(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            PlayerEntityTracker.expireEntries();
        }
    }

    @SideOnly(value=Side.SERVER)
    @SubscribeEvent
    public static void on(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            PlayerEntityTracker.expireEntries();
        }
    }

    private static void expireEntries() {
        Map<UUID, EntityPlayer> playerMap = PLAYER_MAP.get();
        Iterator<EntityPlayer> it = PLAYER_LIST.get().iterator();
        while (it.hasNext()) {
            EntityPlayer entityPlayer = it.next();
            if (!entityPlayer.field_70128_L) continue;
            it.remove();
            playerMap.remove(entityPlayer.func_110124_au());
        }
    }
}

