/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.core.init;

import com.codetaylor.mc.pyrotech.library.JsonInitializer;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;

public final class CompatInitializerOre {
    public static final Map<String, String> OREDICT_COLOR_MAP = new TreeMap<String, String>(){
        {
            this.put("oreAluminum", "e2e2e3");
            this.put("oreArdite", "e85e17");
            this.put("oreCobalt", "1c5bc1");
            this.put("oreCopper", "ffaa1c");
            this.put("oreGold", "fcee4b");
            this.put("oreIridium", "d5d4e7");
            this.put("oreIron", "d8af93");
            this.put("oreLead", "95afee");
            this.put("oreMithril", "9cf9ff");
            this.put("oreNickel", "e4e5d8");
            this.put("oreOctine", "ffaa22");
            this.put("oreOsmium", "9babc4");
            this.put("orePlatinum", "55f3ff");
            this.put("oreSilver", "e8f6fd");
            this.put("oreSyrmorite", "4455bb");
            this.put("oreTin", "c3e9ff");
            this.put("oreUranium", "5c734b");
        }
    };

    public static void create(Path configurationPath) {
        JsonInitializer.create(configurationPath.resolve("pyrotech"), "core.compat.Ore-Generated.json", "core.compat.Ore-Custom.json", () -> CompatInitializerOre.createGeneratedData(new OreCompatData()), ModuleCore.LOGGER);
    }

    @Nullable
    public static OreCompatData read(Path configurationPath) {
        return JsonInitializer.read(configurationPath.resolve("pyrotech"), "core.compat.Ore-Custom.json", OreCompatData.class, null);
    }

    private static OreCompatData createGeneratedData(OreCompatData data) {
        for (Map.Entry<String, String> entry : OREDICT_COLOR_MAP.entrySet()) {
            Object itemStack2;
            String nuggetKey;
            NonNullList nuggetItemStacks;
            String oreKey = entry.getKey();
            NonNullList oreItemStacks = OreDictionary.getOres((String)oreKey);
            if (oreItemStacks.isEmpty() || (nuggetItemStacks = OreDictionary.getOres((String)(nuggetKey = oreKey.replaceAll("ore", "nugget")))).isEmpty()) continue;
            ArrayList<String> langKeys = new ArrayList<String>();
            for (Object itemStack2 : oreItemStacks) {
                Item item = itemStack2.func_77973_b();
                ResourceLocation registryName = item.getRegistryName();
                if (registryName == null) continue;
                String unlocalizedName = registryName.func_110624_b() + ":" + item.func_77667_c((ItemStack)itemStack2);
                if (unlocalizedName.endsWith(".name")) {
                    unlocalizedName = unlocalizedName.substring(0, unlocalizedName.length() - 5);
                }
                langKeys.add(unlocalizedName);
            }
            Collections.sort(langKeys);
            ArrayList<String> nuggetItemStrings = new ArrayList<String>();
            itemStack2 = nuggetItemStacks.iterator();
            while (itemStack2.hasNext()) {
                ItemStack itemStack3 = (ItemStack)itemStack2.next();
                Item item = itemStack3.func_77973_b();
                ResourceLocation registryName = item.getRegistryName();
                if (registryName == null) continue;
                String itemString = registryName.func_110624_b() + ":" + registryName.func_110623_a() + ":" + itemStack3.func_77960_j();
                nuggetItemStrings.add(itemString);
            }
            Collections.sort(nuggetItemStrings);
            OreCompatOreDictEntry oreCompatOreDictEntry = data.oredict.computeIfAbsent(oreKey, s -> new OreCompatOreDictEntry());
            oreCompatOreDictEntry.slagColor = entry.getValue();
            oreCompatOreDictEntry.langKey = langKeys.toArray(new String[0]);
            oreCompatOreDictEntry.output = nuggetItemStrings.toArray(new String[0]);
        }
        return data;
    }

    private CompatInitializerOre() {
    }

    public static class OreCompatOreDictEntry {
        public String slagColor = "ffffff";
        public String[] langKey = new String[0];
        public String[] output = new String[0];
    }

    public static class OreCompatData {
        private String[] __comments = new String[]{"WARNING: All changes should be made to the file with the name Custom", "in the title. Changes made to the Generated file will be overwritten.", "", "This file defines ore compatibility.", "", "Slag content will be generated for each oredict entry.", "", "The first valid key in each langKey list will be chosen; reorder keys", "to change which key is selected.", "", "The first valid nugget in each output list will be chosen; reorder nuggets", "to change which nugget is selected.", "", "Slag color is a hex color code without the #", "", "Lang keys are in the format: (domain):(key)", "", "Output item strings are in the format: (domain):(path):(meta)"};
        public Map<String, OreCompatOreDictEntry> oredict = new TreeMap<String, OreCompatOreDictEntry>();
    }
}

