/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.core.event;

import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCoreConfig;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class LootTableLoadEventHandler {
    private static MethodHandle lootTable$poolsGetter;
    private static MethodHandle lootPool$entriesGetter;
    private static MethodHandle lootEntryItem$itemGetter;
    private static MethodHandle lootEntryItem$itemSetter;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void on(LootTableLoadEvent event) {
        if (!ModuleCoreConfig.TWEAKS.REPLACE_IRON_INGOTS_WITH_IRON_ORE) {
            return;
        }
        ResourceLocation lootTableName = event.getName();
        if (lootTableName == null) {
            return;
        }
        if (lootTable$poolsGetter == null) {
            return;
        }
        LootTable table = event.getTable();
        if (table == null) {
            return;
        }
        HashMap<Item, Item> replacementMap = new HashMap<Item, Item>(){
            {
                this.put(Items.field_151042_j, Item.func_150898_a((Block)Blocks.field_150366_p));
            }
        };
        try {
            List lootPoolList = lootTable$poolsGetter.invokeExact(table);
            for (LootPool lootPool : lootPoolList) {
                List entryList = lootPool$entriesGetter.invokeExact(lootPool);
                for (LootEntry lootEntry : entryList) {
                    if (!(lootEntry instanceof LootEntryItem)) continue;
                    Item item = lootEntryItem$itemGetter.invokeExact((LootEntryItem)lootEntry);
                    for (Map.Entry entry : replacementMap.entrySet()) {
                        Item toReplace = (Item)entry.getKey();
                        Item replaceWith = (Item)entry.getValue();
                        if (item != toReplace) continue;
                        lootEntryItem$itemSetter.invokeExact((LootEntryItem)lootEntry, replaceWith);
                        ModuleCore.LOGGER.info("Replaced " + toReplace.getRegistryName() + " with " + replaceWith.getRegistryName() + " in " + lootTableName);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            ModuleCore.LOGGER.error("", throwable);
        }
    }

    static {
        try {
            lootTable$poolsGetter = MethodHandles.lookup().unreflectGetter(ObfuscationReflectionHelper.findField(LootTable.class, (String)"field_186466_c"));
            lootPool$entriesGetter = MethodHandles.lookup().unreflectGetter(ObfuscationReflectionHelper.findField(LootPool.class, (String)"field_186453_a"));
            lootEntryItem$itemGetter = MethodHandles.lookup().unreflectGetter(ObfuscationReflectionHelper.findField(LootEntryItem.class, (String)"field_186368_a"));
            lootEntryItem$itemSetter = MethodHandles.lookup().unreflectSetter(ObfuscationReflectionHelper.findField(LootEntryItem.class, (String)"field_186368_a"));
        }
        catch (IllegalAccessException e) {
            ModuleCore.LOGGER.error("", (Throwable)e);
        }
    }
}

