/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.modules.core.block;

import com.codetaylor.mc.pyrotech.library.spi.block.BlockPartialBase;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCore;
import com.codetaylor.mc.pyrotech.modules.core.ModuleCoreConfig;
import com.codetaylor.mc.pyrotech.modules.core.network.SCPacketParticleBoneMeal;
import com.codetaylor.mc.pyrotech.modules.core.tile.TileFarmlandMulched;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFarmlandMulched
extends BlockPartialBase {
    public static final String NAME = "farmland_mulched";
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.9375, 1.0);
    private static final AxisAlignedBB AABB_NEGATIVE = new AxisAlignedBB(0.0, 0.9375, 0.0, 1.0, 1.0, 1.0);

    public BlockFarmlandMulched() {
        super(Material.field_151578_c);
        this.func_149711_c(0.7f);
        this.func_149675_a(true);
        this.func_149713_g(255);
        this.func_149672_a(SoundType.field_185849_b);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        if (!world.field_72995_K && ModuleCoreConfig.MULCHED_FARMLAND.ALLOW_TRAMPLE && entity.canTrample(world, (Block)this, pos, fallDistance)) {
            this.turnToDirt(world, pos);
        }
        super.func_180658_a(world, pos, entity, fallDistance);
    }

    @ParametersAreNonnullByDefault
    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        EnumPlantType plantType = plantable.getPlantType(world, pos.func_177972_a(direction));
        if (plantType == EnumPlantType.Crop) {
            return true;
        }
        return super.canSustainPlant(state, world, pos, direction, plantable);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileFarmlandMulched();
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if ((double)rand.nextFloat() > 0.5) {
            return;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof TileFarmlandMulched)) {
            return;
        }
        TileFarmlandMulched tile = (TileFarmlandMulched)tileEntity;
        BlockPos posUp = pos.func_177984_a();
        IBlockState blockStateUp = world.func_180495_p(posUp);
        if (blockStateUp.func_177230_c() instanceof IGrowable) {
            IGrowable growable = (IGrowable)blockStateUp.func_177230_c();
            if (!world.field_72995_K && growable.func_176473_a(world, posUp, blockStateUp, false) && growable.func_180670_a(world, world.field_73012_v, posUp, blockStateUp)) {
                growable.func_176474_b(world, world.field_73012_v, posUp, blockStateUp);
                if (!ModuleCoreConfig.MULCHED_FARMLAND.UNLIMITED_CHARGES) {
                    tile.decrementRemainingCharges();
                }
                ModuleCore.PACKET_SERVICE.sendToAllAround((IMessage)new SCPacketParticleBoneMeal(posUp, 4), world.field_73011_w.getDimension(), posUp);
            }
        }
        if (tile.getRemainingCharges() == 0) {
            world.func_180501_a(pos, Blocks.field_150458_ak.func_176223_P().func_177226_a((IProperty)BlockFarmland.field_176531_a, (Comparable)Integer.valueOf(7)), 3);
        }
    }

    private void turnToDirt(World world, BlockPos pos) {
        world.func_175656_a(pos, Blocks.field_150346_d.func_176223_P());
        AxisAlignedBB bounds = AABB_NEGATIVE.func_186670_a(pos);
        for (Entity entity : world.func_72839_b(null, bounds)) {
            double d0 = Math.min(bounds.field_72337_e - bounds.field_72338_b, bounds.field_72337_e - entity.func_174813_aQ().field_72338_b);
            entity.func_70634_a(entity.field_70165_t, entity.field_70163_u + d0 + 0.001, entity.field_70161_v);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, block, fromPos);
        if (world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76220_a()) {
            this.turnToDirt(world, pos);
        }
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        if (world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76220_a()) {
            this.turnToDirt(world, pos);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        switch (side) {
            case UP: {
                return true;
            }
            case NORTH: 
            case SOUTH: 
            case WEST: 
            case EAST: {
                IBlockState iblockstate = blockAccess.func_180495_p(pos.func_177972_a(side));
                Block block = iblockstate.func_177230_c();
                return !iblockstate.func_185914_p() && block != Blocks.field_150458_ak && block != Blocks.field_185774_da && block != ModuleCore.Blocks.FARMLAND_MULCHED;
            }
        }
        return super.func_176225_a(blockState, blockAccess, pos, side);
    }

    @Nonnull
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Blocks.field_150346_d.func_180660_a(Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT), rand, fortune);
    }

    @Override
    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }
}

