/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.library.util;

import com.codetaylor.mc.athenaeum.parser.recipe.item.MalformedRecipeItemException;
import com.codetaylor.mc.athenaeum.parser.recipe.item.ParseResult;
import com.codetaylor.mc.athenaeum.parser.recipe.item.RecipeItemParser;
import com.codetaylor.mc.pyrotech.library.util.BlockMetaMatcher;
import java.text.DecimalFormat;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class Util {
    public static final String MOD_ID = "pyrotech";
    public static final DecimalFormat DF_PERCENT = new DecimalFormat("#%");
    public static final Random RANDOM = new Random();

    public static String prefix(String name) {
        return String.format("%s.%s", MOD_ID, name.toLowerCase(Locale.US));
    }

    public static String translateFormatted(String key, Object ... pars) {
        return I18n.func_74838_a((String)I18n.func_74837_a((String)key, (Object[])pars).trim()).trim();
    }

    public static String translate(String key, Object ... pars) {
        return I18n.func_74838_a((String)I18n.func_74838_a((String)String.format(key, pars)).trim()).trim();
    }

    public static BlockMetaMatcher parseBlockStringWithWildcard(String blockString, RecipeItemParser parser) throws MalformedRecipeItemException {
        ParseResult parse = parser.parse(blockString);
        ResourceLocation resourceLocation = new ResourceLocation(parse.getDomain(), parse.getPath());
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation);
        if (block == null) {
            throw new IllegalArgumentException("Unable to locate block for [" + resourceLocation + "]");
        }
        int meta = parse.getMeta();
        return new BlockMetaMatcher(block, meta);
    }

    public static boolean canSetFire(World world, BlockPos pos) {
        if (Util.isLiquid(world, pos)) {
            return false;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        return block == Blocks.field_150350_a || block.func_176200_f((IBlockAccess)world, pos);
    }

    public static boolean isLiquid(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_185904_a().func_76224_d();
    }

    public static boolean isFluidBucket(ItemStack fuel, String name) {
        FluidStack fluidStack = FluidRegistry.getFluidStack((String)name, (int)1000);
        if (fluidStack == null) {
            return false;
        }
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)fuel);
        if (fluidHandler == null) {
            return false;
        }
        FluidStack drained = fluidHandler.drain(1000, false);
        return fluidStack.isFluidStackIdentical(drained);
    }

    public static float abs(float value) {
        return value >= 0.0f ? value : -value;
    }

    public static boolean epsilonEquals(float a, float b) {
        return Util.abs(b - a) < 1.0E-5f;
    }

    private Util() {
    }
}

