/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.library.spi.tile;

import com.codetaylor.mc.athenaeum.network.tile.ITileDataService;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataBoolean;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataFloat;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.codetaylor.mc.athenaeum.network.tile.spi.TileDataBase;
import com.codetaylor.mc.pyrotech.library.spi.tile.ITileWorker;
import com.codetaylor.mc.pyrotech.library.spi.tile.TileNetBase;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;

public abstract class TileNetWorkerBase
extends TileNetBase
implements ITileWorker,
ITickable {
    protected final TileDataBoolean active = new TileDataBoolean(false);
    protected final TileDataFloat[] progress;

    protected TileNetWorkerBase(ITileDataService tileDataService, int taskCount) {
        super(tileDataService);
        this.active.addChangeObserver((TileDataBase.IChangeObserver)new TileDataBase.IChangeObserver.OnDirtyMarkTileDirty((TileEntity)this));
        this.progress = new TileDataFloat[taskCount];
        for (int i = 0; i < taskCount; ++i) {
            this.progress[i] = new TileDataFloat(0.0f, 20);
            this.progress[i].addChangeObserver((TileDataBase.IChangeObserver)new TileDataBase.IChangeObserver.OnDirtyMarkTileDirty((TileEntity)this));
        }
        this.registerTileDataForNetwork(new ITileData[]{this.active});
        this.registerTileDataForNetwork((ITileData[])this.progress);
    }

    @Override
    public boolean workerIsActive() {
        return this.active.get();
    }

    @Override
    public void workerSetActive(boolean active) {
        this.active.set(active);
    }

    public float workerGetProgress(int taskIndex) {
        return this.progress[taskIndex].get();
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.workerIsActive()) {
            if (this.workerUpdateInactive()) {
                this.workerSetActive(true);
            } else {
                return;
            }
        }
        if (this.workerRequiresFuel() && !this.workerConsumeFuel()) {
            this.workerSetActive(false);
            return;
        }
        if (!this.workerDoWork()) {
            this.workerSetActive(false);
        }
        for (int i = 0; i < this.progress.length; ++i) {
            this.progress[i].set(this.workerCalculateProgress(i));
        }
    }

    protected boolean workerUpdateInactive() {
        return false;
    }

    protected float workerCalculateProgress(int taskIndex) {
        return 0.0f;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.active.set(compound.func_74767_n("active"));
        NBTTagList progress = compound.func_150295_c("progress", 5);
        for (int i = 0; i < progress.func_74745_c() && this.progress.length > i; ++i) {
            this.progress[i].set(progress.func_150308_e(i));
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("active", this.active.get());
        NBTTagList list = new NBTTagList();
        for (TileDataFloat tileDataFloat : this.progress) {
            list.func_74742_a((NBTBase)new NBTTagFloat(tileDataFloat.get()));
        }
        compound.func_74782_a("progress", (NBTBase)list);
        return compound;
    }
}

