/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.library.spi.tile;

import com.codetaylor.mc.athenaeum.network.tile.ITileDataService;
import com.codetaylor.mc.athenaeum.network.tile.data.TileDataInteger;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.codetaylor.mc.athenaeum.network.tile.spi.TileDataBase;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import com.codetaylor.mc.pyrotech.library.spi.tile.TileNetWorkerBase;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.EnumSkyBlock;

public abstract class TileCombustionWorkerBase
extends TileNetWorkerBase {
    protected TileDataInteger burnTimeRemaining = new TileDataInteger(this.combustionGetInitialBurnTimeRemaining(), 20);
    private int rainTimeRemaining;
    private boolean firstLightCheck = false;

    protected TileCombustionWorkerBase(ITileDataService tileDataService, int taskCount) {
        super(tileDataService, taskCount);
        this.burnTimeRemaining.addChangeObserver((TileDataBase.IChangeObserver)new TileDataBase.IChangeObserver.OnDirtyMarkTileDirty((TileEntity)this));
        this.registerTileDataForNetwork(new ITileData[]{this.burnTimeRemaining});
        this.rainTimeRemaining = this.combustionGetRainDeactivateTime();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.firstLightCheck) {
            this.firstLightCheck = true;
            this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.field_174879_c);
        }
    }

    public int combustionGetBurnTimeRemaining() {
        return this.burnTimeRemaining.get();
    }

    protected int combustionGetRainDeactivateTime() {
        return -1;
    }

    protected int combustionGetInitialBurnTimeRemaining() {
        return 0;
    }

    protected int combustionGetBurnTimeForFuel(ItemStack fuel) {
        return StackHelper.getItemBurnTime((ItemStack)fuel);
    }

    protected void combustionOnDeactivatedByRain() {
    }

    protected abstract ItemStack combustionGetFuelItem();

    @Override
    public boolean workerRequiresFuel() {
        return this.combustionGetBurnTimeRemaining() <= 0;
    }

    @Override
    public boolean workerConsumeFuel() {
        ItemStack fuel = this.combustionGetFuelItem();
        if (!fuel.func_190926_b()) {
            this.burnTimeRemaining.set(this.combustionGetBurnTimeForFuel(fuel));
            return true;
        }
        this.workerSetActive(false);
        return false;
    }

    @Override
    public boolean workerDoWork() {
        if (this.combustionGetRainDeactivateTime() > -1) {
            if (this.field_145850_b.func_175727_C(this.field_174879_c.func_177984_a())) {
                if (this.rainTimeRemaining > 0) {
                    --this.rainTimeRemaining;
                }
                if (this.rainTimeRemaining == 0) {
                    this.combustionOnDeactivatedByRain();
                    return false;
                }
            } else {
                this.rainTimeRemaining = this.combustionGetRainDeactivateTime();
            }
        }
        this.reduceBurnTimeRemaining();
        return true;
    }

    protected void reduceBurnTimeRemaining() {
        this.burnTimeRemaining.add(-1);
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("burnTimeRemaining", this.burnTimeRemaining.get());
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.burnTimeRemaining.set(compound.func_74762_e("burnTimeRemaining"));
    }
}

