/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.library.spi.tile;

import com.codetaylor.mc.athenaeum.network.tile.ITileDataService;
import com.codetaylor.mc.pyrotech.library.spi.tile.TileNetBase;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class TileBurnableBase
extends TileNetBase
implements ITickable {
    private static final int DEFAULT_MAX_INVALID_TICKS = 100;
    private static final int DEFAULT_STRUCTURE_VALIDATION_INTERVAL = 20;
    private boolean needStructureValidation;
    private int invalidTicks = 0;
    private int nextStructureValidationTicks;
    protected int burnTimeTicksPerStage;
    protected int remainingStages = this.getBurnStages();

    public TileBurnableBase(ITileDataService tileDataService) {
        super(tileDataService);
        this.reset();
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.isActive()) {
            return;
        }
        this.onUpdate();
        if (!this.needStructureValidation) {
            --this.nextStructureValidationTicks;
            if (this.nextStructureValidationTicks <= 0) {
                this.nextStructureValidationTicks = 20;
                this.setNeedStructureValidation();
            }
        }
        if (this.needStructureValidation && this.isStructureValid()) {
            this.invalidTicks = 0;
            this.needStructureValidation = false;
            this.nextStructureValidationTicks = 20;
        }
        if (!this.needStructureValidation) {
            this.onUpdateValid();
        } else if (this.invalidTicks < this.getMaxInvalidTicks()) {
            ++this.invalidTicks;
            this.onUpdateInvalid();
        } else {
            this.onInvalidDelayExpired();
        }
        if (this.remainingStages <= 0) {
            this.onAllBurnStagesComplete();
        } else if (this.burnTimeTicksPerStage > 0) {
            --this.burnTimeTicksPerStage;
        } else {
            --this.remainingStages;
            this.onBurnStageComplete();
            this.reset();
        }
    }

    protected void reset() {
        this.setNeedStructureValidation();
        this.burnTimeTicksPerStage = this.getTotalBurnTimeTicks() / this.getBurnStages();
    }

    protected boolean isStructureValid() {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            BlockPos offset = this.field_174879_c.func_177972_a(facing);
            if (this.isValidStructureBlock(this.field_145850_b, offset, this.field_145850_b.func_180495_p(offset), facing)) continue;
            return false;
        }
        return true;
    }

    protected boolean isValidStructureBlock(World world, BlockPos pos, IBlockState blockState, EnumFacing facing) {
        return blockState.isSideSolid((IBlockAccess)world, pos, facing.func_176734_d()) && !blockState.func_177230_c().isFlammable((IBlockAccess)world, pos, facing.func_176734_d());
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("needStructureValidation", this.needStructureValidation);
        compound.func_74768_a("burnTimeTicksPerStage", this.burnTimeTicksPerStage);
        compound.func_74768_a("invalidTicks", this.invalidTicks);
        compound.func_74768_a("remainingStages", this.remainingStages);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.needStructureValidation = compound.func_74767_n("needStructureValidation");
        this.burnTimeTicksPerStage = compound.func_74762_e("burnTimeTicksPerStage");
        this.invalidTicks = compound.func_74762_e("invalidTicks");
        this.remainingStages = compound.func_74762_e("remainingStages");
    }

    protected int getMaxInvalidTicks() {
        return 100;
    }

    public void setNeedStructureValidation() {
        this.needStructureValidation = true;
    }

    protected abstract boolean isActive();

    protected abstract void onUpdate();

    protected abstract void onUpdateValid();

    protected abstract void onUpdateInvalid();

    protected abstract void onInvalidDelayExpired();

    protected abstract void onBurnStageComplete();

    protected abstract int getTotalBurnTimeTicks();

    protected abstract void onAllBurnStagesComplete();

    protected abstract int getBurnStages();
}

