/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.library.blockrenderer;

import com.codetaylor.mc.pyrotech.library.blockrenderer.IBulkRenderItemSupplier;
import com.codetaylor.mc.pyrotech.library.blockrenderer.RenderItemData;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModBulkRenderItemSupplier
implements IBulkRenderItemSupplier {
    private static final Logger LOGGER = LogManager.getLogger(ModBulkRenderItemSupplier.class);
    private final String modId;
    private final Function<ItemStack, RenderItemData> renderItemDataFunction;

    public ModBulkRenderItemSupplier(String modId, Function<ItemStack, RenderItemData> renderItemDataFunction) {
        this.modId = modId;
        this.renderItemDataFunction = renderItemDataFunction;
    }

    @Override
    public List<RenderItemData> get() {
        ArrayList result = Lists.newArrayList();
        for (ResourceLocation resourceLocation : Item.field_150901_e.func_148742_b()) {
            if (resourceLocation == null || !this.modId.equals(resourceLocation.func_110624_b())) continue;
            NonNullList results = NonNullList.func_191196_a();
            Item item = (Item)Item.field_150901_e.func_82594_a((Object)resourceLocation);
            if (item == null) {
                LOGGER.warn("Registry is missing item for " + resourceLocation);
            } else {
                try {
                    CreativeTabs creativeTab = item.func_77640_w();
                    if (creativeTab != null) {
                        item.func_150895_a(creativeTab, results);
                    } else {
                        LOGGER.warn("Item has no creative tab, skipping item for " + resourceLocation);
                    }
                }
                catch (Throwable t) {
                    LOGGER.warn("Failed to get renderable items for " + resourceLocation, t);
                }
            }
            for (ItemStack itemStack : results) {
                result.add(this.renderItemDataFunction.apply(itemStack));
            }
        }
        return result;
    }
}

