/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech.interaction.spi;

import com.codetaylor.mc.athenaeum.util.FluidUtilFix;
import com.codetaylor.mc.pyrotech.interaction.spi.IInteraction;
import com.codetaylor.mc.pyrotech.interaction.spi.InteractionBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public abstract class InteractionBucketBase<T extends TileEntity>
extends InteractionBase<T> {
    private final IFluidHandler fluidHandler;

    public InteractionBucketBase(IFluidHandler fluidHandler, EnumFacing[] sides, AxisAlignedBB bounds) {
        super(sides, bounds);
        this.fluidHandler = fluidHandler;
    }

    @Override
    public boolean interact(IInteraction.EnumType type, T tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
        if (this.allowInteractionWithHand(hand) && this.allowInteractionWithType(type) && this.allowInteraction(tile, world, hitPos, state, player, hand, hitSide, hitX, hitY, hitZ)) {
            return this.doInteraction(tile, world, hitPos, state, player, hand, hitSide, hitX, hitY, hitZ);
        }
        return false;
    }

    protected boolean allowInteraction(T tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
        return FluidUtil.getFluidHandler((ItemStack)player.func_184614_ca()) != null;
    }

    protected boolean doInteraction(T tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
        return FluidUtilFix.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)this.fluidHandler);
    }
}

