/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.pyrotech;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BooleanSupplier;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.crafting.IConditionFactory;
import net.minecraftforge.common.crafting.JsonContext;

@Config(modid="pyrotech", name="pyrotech/modules")
public class ModPyrotechConfig {
    public static Map<String, Boolean> MODULES = new TreeMap<String, Boolean>();

    static {
        MODULES.put("module.tech.bloomery", true);
        MODULES.put("module.bucket", true);
        MODULES.put("module.ignition", true);
        MODULES.put("module.storage", true);
        MODULES.put("module.tech.basic", true);
        MODULES.put("module.tech.machine", true);
        MODULES.put("module.tech.refractory", true);
        MODULES.put("module.tool", true);
        MODULES.put("module.world_gen", true);
        MODULES.put("plugin.dropt", true);
        MODULES.put("plugin.patchouli", true);
    }

    public static class ConditionConfig
    implements IConditionFactory {
        public BooleanSupplier parse(JsonContext context, JsonObject json) {
            String module;
            if (json.has("include")) {
                JsonArray include = JsonUtils.func_151214_t((JsonObject)json, (String)"include");
                for (JsonElement element : include) {
                    module = element.getAsString();
                    if (!MODULES.containsKey(module)) {
                        throw new JsonSyntaxException("Unknown module id: [" + module + "]");
                    }
                    if (MODULES.get(module).booleanValue()) continue;
                    return () -> false;
                }
            }
            if (json.has("exclude")) {
                JsonArray exclude = JsonUtils.func_151214_t((JsonObject)json, (String)"exclude");
                for (JsonElement element : exclude) {
                    module = element.getAsString();
                    if (!MODULES.containsKey(module)) {
                        throw new JsonSyntaxException("Unknown module id: [" + module + "]");
                    }
                    if (!MODULES.get(module).booleanValue()) continue;
                    return () -> false;
                }
            }
            return () -> true;
        }
    }
}

