/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.world.gen.feature;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import thedarkcolour.futuremc.block.BlockFlower;

public class WorldGenFlower
implements IWorldGenerator {
    private BlockFlower flower;
    private IBlockState state;

    public WorldGenFlower(BlockFlower flower) {
        this.flower = flower;
        this.state = flower.func_176223_P();
    }

    private void generate(World world, Random random, BlockPos pos) {
        for (int i = 0; i < 64; ++i) {
            BlockPos blockpos = pos.func_177982_a(random.nextInt(8) - random.nextInt(8), random.nextInt(4) - random.nextInt(4), random.nextInt(8) - random.nextInt(8));
            if (!world.func_175623_d(blockpos) || world.field_73011_w.func_177495_o() && blockpos.func_177956_o() >= 255 || !this.flower.func_180671_f(world, blockpos, this.state)) continue;
            world.func_180501_a(blockpos, this.state, 2);
        }
    }

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        Biome biome = world.getBiomeForCoordsBody(new BlockPos(x, 0, z));
        ChunkPos chunkPos = world.func_72964_e(chunkX, chunkZ).func_76632_l();
        if (rand.nextInt(100) <= this.flower.getFlowerChance() && this.flower.isBiomeValid(biome) && world.func_175624_G() != WorldType.field_77138_c) {
            for (int i = 0; i < 5; ++i) {
                int xPos = rand.nextInt(16) + 8;
                int zPos = rand.nextInt(16) + 8;
                int yPos = rand.nextInt(world.func_175645_m(chunkPos.func_180331_a(0, 0, 0).func_177982_a(xPos, 0, zPos)).func_177956_o() + 32);
                BlockPos pos = chunkPos.func_180331_a(0, 0, 0).func_177982_a(xPos, yPos, zPos);
                this.generate(world, rand, pos);
            }
        }
    }
}

