/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.world.gen.feature;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import sun.reflect.Reflection;
import thedarkcolour.futuremc.block.BlockBeeHive;
import thedarkcolour.futuremc.entity.bee.EntityBee;
import thedarkcolour.futuremc.init.FutureConfig;
import thedarkcolour.futuremc.init.Init;
import thedarkcolour.futuremc.tile.TileBeeHive;

public final class BeeNestGenerator {
    protected static final IBlockState BEE_NEST = Init.BEE_NEST.func_176223_P().func_177226_a((IProperty)BlockBeeHive.FACING, (Comparable)EnumFacing.SOUTH);
    protected static final EnumFacing[] VALID_OFFSETS = new EnumFacing[]{EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST};
    public static final Map<Biome, Double> BIOMES_AND_CHANCES = Maps.newHashMap();

    public static double getBeeNestChance() {
        return FutureConfig.general.beeNestChance;
    }

    public static void generateBeeNestsForSmallTrees(World worldIn, Random rand, BlockPos position, int height, WorldGenAbstractTree trees) {
        if (!FutureConfig.general.bee || Reflection.getCallerClass((int)3) != BiomeDecorator.class) {
            return;
        }
        Biome biome = worldIn.func_180494_b(position);
        if (BIOMES_AND_CHANCES.containsKey(biome)) {
            if (!((double)rand.nextFloat() < FutureConfig.general.beeNestChance * BIOMES_AND_CHANCES.get(biome))) {
                return;
            }
        } else {
            return;
        }
        EnumFacing offset = VALID_OFFSETS[rand.nextInt(3)];
        BlockPos pos = position.func_177981_b(height - 4).func_177972_a(offset);
        if (trees.isReplaceable(worldIn, pos) && worldIn.func_180495_p(pos.func_177970_e(1)).func_177230_c().isAir(worldIn.func_180495_p(pos.func_177970_e(1)), (IBlockAccess)worldIn, pos.func_177970_e(1))) {
            worldIn.func_175656_a(pos, BEE_NEST);
            TileEntity te = worldIn.func_175625_s(pos);
            if (te instanceof TileBeeHive) {
                for (int j = 0; j < 3; ++j) {
                    EntityBee bee = new EntityBee(worldIn);
                    ((TileBeeHive)te).tryEnterHive((Entity)bee, false, rand.nextInt(599));
                }
            }
        }
    }

    public static void generateBeeNestsForBigTrees(World worldIn, Random rand, BlockPos position, int height, WorldGenAbstractTree tree) {
        if (!FutureConfig.general.bee || Reflection.getCallerClass((int)3) != BiomeDecorator.class) {
            return;
        }
        Biome biome = worldIn.func_180494_b(position);
        if (BIOMES_AND_CHANCES.containsKey(biome)) {
            if (!((double)rand.nextFloat() < FutureConfig.general.beeNestChance * BIOMES_AND_CHANCES.get(biome))) {
                return;
            }
        } else {
            return;
        }
        EnumFacing offset = VALID_OFFSETS[rand.nextInt(3)];
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(position.func_177972_a(offset));
        for (int i = 0; i < height; ++i) {
            if (!worldIn.func_180495_p(pos.func_177984_a()).func_177230_c().isAir(worldIn.func_180495_p(pos.func_177984_a()), (IBlockAccess)worldIn, (BlockPos)pos)) {
                if (worldIn.func_180495_p((BlockPos)pos).func_177230_c().isAir(worldIn.func_180495_p((BlockPos)pos), (IBlockAccess)worldIn, (BlockPos)pos) && worldIn.func_180495_p(pos.func_177970_e(1)).func_177230_c().isAir(worldIn.func_180495_p(pos.func_177970_e(1)), (IBlockAccess)worldIn, pos.func_177970_e(1))) {
                    worldIn.func_175656_a((BlockPos)pos, BEE_NEST);
                    TileEntity te = worldIn.func_175625_s((BlockPos)pos);
                    if (te instanceof TileBeeHive) {
                        for (int j = 0; j < 3; ++j) {
                            EntityBee bee = new EntityBee(worldIn);
                            ((TileBeeHive)te).tryEnterHive((Entity)bee, false, rand.nextInt(599));
                        }
                    }
                }
                return;
            }
            pos.func_189534_c(EnumFacing.UP, 1);
        }
    }

    public static void init() {
        String[] entries;
        for (String entry : entries = FutureConfig.general.validBiomesForBeeNest.split(", ")) {
            String[] parts = entry.split(":");
            ResourceLocation loc = new ResourceLocation(parts[0], parts[1]);
            Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(loc);
            Double chance = Double.parseDouble(parts[2]);
            BIOMES_AND_CHANCES.put(biome, chance);
        }
    }
}

