/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.world.biome;

import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeJungle;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenMegaJungle;
import net.minecraft.world.gen.feature.WorldGenShrub;
import net.minecraft.world.gen.feature.WorldGenTrees;
import thedarkcolour.futuremc.entity.panda.EntityPanda;
import thedarkcolour.futuremc.init.Init;

public class BiomeBambooJungle
extends BiomeJungle {
    public static final IBlockState JUNGLE_LOG = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE);
    public static final IBlockState JUNGLE_LEAF = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.FALSE);
    public static final IBlockState OAK_LEAF = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.OAK).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.FALSE);

    public BiomeBambooJungle(boolean isEdgeIn) {
        super(false, new Biome.BiomeProperties("Bamboo").func_185395_b(0.9f).func_185410_a(0.95f));
        if (!isEdgeIn) {
            this.field_76762_K.add(new Biome.SpawnListEntry(EntityPanda.class, 1, 1, 2));
        }
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        return this.getTree(rand);
    }

    private WorldGenAbstractTree getTree(Random rand) {
        if (rand.nextInt(3) == 0) {
            return Init.BAMBOO_FEATURE;
        }
        if (rand.nextInt(2) == 0) {
            return new WorldGenShrub(JUNGLE_LOG, OAK_LEAF);
        }
        if (rand.nextBoolean()) {
            return new WorldGenTrees(false);
        }
        return rand.nextInt(3) == 0 ? new WorldGenMegaJungle(false, 10, 20, JUNGLE_LOG, JUNGLE_LEAF) : new WorldGenTrees(false, 4 + rand.nextInt(7), JUNGLE_LOG, JUNGLE_LEAF, true);
    }
}

