/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.tile;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import thedarkcolour.core.tile.InteractionTile;
import thedarkcolour.futuremc.block.BlockComposter;
import thedarkcolour.futuremc.init.Init;
import thedarkcolour.futuremc.sound.Sounds;

public class TileComposter
extends InteractionTile {
    private final ItemStackHandler buffer = new ItemStackHandler(){

        public boolean isItemValid(int slot, ItemStack stack) {
            return BlockComposter.canCompost(stack, TileComposter.this.field_145850_b.func_180495_p(TileComposter.this.field_174879_c));
        }

        protected int getStackLimit(int slot, ItemStack stack) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            TileComposter.this.handleStack((ItemStack)this.stacks.get(slot));
        }

        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!this.isItemValid(0, stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (TileComposter.isBoneMeal((ItemStack)this.stacks.get(0)) && !simulate) {
                TileComposter.this.field_145850_b.func_175656_a(TileComposter.this.field_174879_c, Init.COMPOSTER.func_176223_P());
            }
            return super.extractItem(0, amount, simulate);
        }
    };

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("buffer")) {
            this.buffer.deserializeNBT(compound);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("buffer", (NBTBase)this.buffer.serializeNBT());
        return compound;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.buffer);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public boolean activated(IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return super.activated(state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    @Override
    public void broken(IBlockState state, EntityPlayer playerIn) {
        if (!this.field_145850_b.field_72995_K && (Integer)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockComposter.LEVEL) == 8) {
            EntityItem item = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.6, (double)this.field_174879_c.func_177952_p() + 0.5);
            item.func_92058_a(new ItemStack(Items.field_151100_aR, 1, 15));
            this.field_145850_b.func_72838_d((Entity)item);
        }
    }

    public static boolean isBoneMeal(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151100_aR && stack.func_77952_i() == 15;
    }

    public void addItem(ItemStack stack, boolean shrink) {
        this.buffer.insertItem(0, stack, false);
        if (shrink) {
            stack.func_190918_g(1);
        }
    }

    private void handleStack(ItemStack stack) {
        if (BlockComposter.canCompost(stack, this.field_145850_b.func_180495_p(this.field_174879_c)) && !stack.func_190926_b() && !TileComposter.isBoneMeal(stack)) {
            if (this.field_145850_b.field_73012_v.nextInt(100) <= BlockComposter.ItemsForComposter.getChance(stack)) {
                this.addLayer();
            } else {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, Sounds.COMPOSTER_FILL, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            this.consume();
        }
    }

    public void addLayer() {
        this.field_145850_b.func_175656_a(this.field_174879_c, Init.COMPOSTER.func_176223_P().func_177226_a((IProperty)BlockComposter.LEVEL, (Comparable)Integer.valueOf((Integer)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockComposter.LEVEL) + 1)));
        this.field_145850_b.func_184133_a(null, this.field_174879_c, Sounds.COMPOSTER_FILL_SUCCESS, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if ((Integer)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockComposter.LEVEL) >= 7) {
            this.field_145850_b.func_180497_b(this.field_174879_c, (Block)Init.COMPOSTER, 30, 1);
        }
    }

    public void consume() {
        this.buffer.setStackInSlot(0, ItemStack.field_190927_a);
    }

    public void extractBoneMeal() {
        EntityItem item = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.6, (double)this.field_174879_c.func_177952_p() + 0.5);
        item.func_92058_a(new ItemStack(Items.field_151100_aR, 1, 15));
        this.field_145850_b.func_72838_d((Entity)item);
        this.field_145850_b.func_175656_a(this.field_174879_c, Init.COMPOSTER.func_176223_P());
        this.buffer.setStackInSlot(0, ItemStack.field_190927_a);
        this.field_145850_b.func_184133_a(null, this.field_174879_c, Sounds.COMPOSTER_EMPTY, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public ItemStackHandler getBuffer() {
        return this.buffer;
    }
}

