/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.tile;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.items.ItemStackHandler;
import thedarkcolour.core.item.ItemDebugger;
import thedarkcolour.core.tile.InteractionTile;
import thedarkcolour.futuremc.block.BlockCampfire;
import thedarkcolour.futuremc.init.Init;

public class TileCampfire
extends InteractionTile
implements ITickable {
    private final int[] cookingTimes = new int[4];
    private final int[] cookingTotalTimes = new int[4];
    private final ItemStackHandler buffer = new ItemStackHandler(4){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return Recipes.getRecipe(stack) != null;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    };

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if ((this.func_145832_p() & 4) != 0) {
                this.cookItems();
            } else {
                for (int i = 0; i < 4; ++i) {
                    if (this.cookingTimes[i] <= 0) continue;
                    this.cookingTimes[i] = MathHelper.func_76125_a((int)(this.cookingTimes[i] - 2), (int)0, (int)this.cookingTotalTimes[i]);
                }
            }
        }
    }

    @Override
    public boolean activated(IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (stack.func_77973_b() instanceof ItemDebugger) {
            return false;
        }
        Block block = this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()).func_177230_c();
        if (!((Boolean)state.func_177229_b((IProperty)BlockCampfire.LIT)).booleanValue()) {
            if (!(stack.func_77973_b() != Items.field_151033_d && stack.func_77973_b() != Items.field_151059_bz || block instanceof BlockLiquid | block instanceof BlockFluidBase)) {
                Init.CAMPFIRE.setLit(this.field_145850_b, this.field_174879_c, true);
                stack.func_77972_a(1, (EntityLivingBase)playerIn);
            }
        } else if (stack.func_77973_b().getToolClasses(stack).contains("shovel")) {
            this.field_145850_b.func_175656_a(this.field_174879_c, Init.CAMPFIRE.func_176194_O().func_177621_b().func_177226_a((IProperty)BlockCampfire.LIT, (Comparable)Boolean.valueOf(false)));
        }
        if (((Boolean)state.func_177229_b((IProperty)BlockCampfire.LIT)).booleanValue() && !this.field_145850_b.field_72995_K) {
            this.addItem(stack);
        }
        return true;
    }

    private void cookItems() {
        for (int i = 0; i < 4; ++i) {
            ItemStack stack = this.buffer.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            int n = i;
            this.cookingTimes[n] = this.cookingTimes[n] + 1;
            if (this.cookingTimes[i] < this.cookingTotalTimes[i] || Recipes.getRecipe(stack) == null) continue;
            ItemStack output = Recipes.getRecipe((ItemStack)stack).output.func_77946_l();
            this.buffer.setStackInSlot(i, ItemStack.field_190927_a);
            this.drop(output);
            this.cookingTimes[i] = 0;
        }
        this.inventoryChanged();
    }

    public void drop(ItemStack stack) {
        if (!this.field_145850_b.field_72995_K) {
            double d0 = (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.5f) + 0.25;
            double d1 = (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.5f) + 0.25;
            double d2 = (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.5f) + 0.25;
            EntityItem entityitem = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + d0, (double)this.field_174879_c.func_177956_o() + d1, (double)this.field_174879_c.func_177952_p() + d2, stack);
            entityitem.func_174869_p();
            this.field_145850_b.func_72838_d((Entity)entityitem);
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        int[] arr;
        super.func_145839_a(compound);
        if (compound.func_74764_b("Buffer")) {
            this.buffer.deserializeNBT((NBTTagCompound)compound.func_74781_a("Buffer"));
        }
        if (compound.func_150297_b("CookingTimes", 11)) {
            arr = compound.func_74759_k("CookingTimes");
            System.arraycopy(arr, 0, this.cookingTimes, 0, Math.min(this.cookingTotalTimes.length, arr.length));
        }
        if (compound.func_150297_b("CookingTotalTimes", 11)) {
            arr = compound.func_74759_k("CookingTotalTimes");
            System.arraycopy(arr, 0, this.cookingTotalTimes, 0, Math.min(this.cookingTotalTimes.length, arr.length));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("Buffer", (NBTBase)this.buffer.serializeNBT());
        compound.func_74783_a("CookingTimes", this.cookingTimes);
        compound.func_74783_a("CookingTotalTimes", this.cookingTotalTimes);
        return compound;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 13, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void addItem(ItemStack stack) {
        if (!this.buffer.isItemValid(0, stack)) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            ItemStack stack1 = this.buffer.getStackInSlot(i);
            if (!stack1.func_190926_b()) continue;
            this.cookingTotalTimes[i] = Recipes.getRecipe((ItemStack)stack).duration;
            this.cookingTimes[i] = 0;
            this.buffer.setStackInSlot(i, stack.func_77979_a(1));
            this.inventoryChanged();
            return;
        }
    }

    public void dropAllItems() {
        for (int i = 0; i < 4; ++i) {
            InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)this.buffer.getStackInSlot(i));
        }
        this.inventoryChanged();
    }

    public ItemStackHandler getBuffer() {
        return this.buffer;
    }

    public int[] getCookingTimes() {
        return this.cookingTimes;
    }

    public int[] getCookingTotalTimes() {
        return this.cookingTotalTimes;
    }

    private void inventoryChanged() {
        this.func_70296_d();
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
    }

    public static class Recipe {
        public final ItemStack input;
        public final ItemStack output;
        public final int duration;

        private Recipe(ItemStack input, ItemStack output, int duration) {
            this.input = input;
            this.output = output;
            this.duration = duration;
        }
    }

    public static final class Recipes {
        private static final ArrayList<Recipe> RECIPES = Lists.newArrayListWithExpectedSize((int)8);

        public static void init() {
            Recipes.recipe(new ItemStack(Items.field_151115_aP), new ItemStack(Items.field_179566_aV), 600);
            Recipes.recipe(new ItemStack(Items.field_151076_bf), new ItemStack(Items.field_151077_bg), 600);
            Recipes.recipe(new ItemStack(Items.field_151147_al), new ItemStack(Items.field_151157_am), 600);
            Recipes.recipe(new ItemStack(Items.field_151115_aP, 1, 1), new ItemStack(Items.field_179566_aV, 1, 1), 600);
            Recipes.recipe(new ItemStack(Items.field_151082_bd), new ItemStack(Items.field_151083_be), 600);
            Recipes.recipe(new ItemStack(Items.field_179561_bm), new ItemStack(Items.field_179557_bn), 600);
            Recipes.recipe(new ItemStack(Items.field_179558_bo), new ItemStack(Items.field_179559_bp), 600);
            Recipes.recipe(new ItemStack(Items.field_151174_bG), new ItemStack(Items.field_151168_bH), 600);
        }

        public static void recipe(ItemStack input, ItemStack output, int duration) {
            RECIPES.add(new Recipe(input, output, duration));
        }

        public static void remove(ItemStack input) {
            RECIPES.removeIf(recipe -> recipe.input.func_77969_a(input));
        }

        public static Recipe getRecipe(ItemStack input) {
            for (Recipe recipe : RECIPES) {
                if (!recipe.input.func_77969_a(input)) continue;
                return recipe;
            }
            return null;
        }

        public static Collection<?> getAllRecipes() {
            return RECIPES;
        }

        public static void clear() {
            RECIPES.clear();
        }
    }
}

