/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.tile;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import sun.reflect.Reflection;
import thedarkcolour.core.tile.InteractionTile;
import thedarkcolour.futuremc.block.BlockBeeHive;
import thedarkcolour.futuremc.entity.bee.EntityBee;
import thedarkcolour.futuremc.init.Init;
import thedarkcolour.futuremc.sound.Sounds;

public class TileBeeHive
extends InteractionTile
implements ITickable {
    private final List<Bee> bees = Lists.newArrayList();
    private BlockPos flowerPos = BlockPos.field_177992_a;
    private int honeyLevel;

    public boolean isFullOfBees() {
        return this.bees.size() == 3;
    }

    public void angerBees(EntityPlayer playerIn, BeeState state) {
        List<Entity> list = this.tryReleaseBee(state);
        if (playerIn != null) {
            for (Entity entity : list) {
                if (!(entity instanceof EntityBee)) continue;
                EntityBee bee = (EntityBee)entity;
                if (!(playerIn.func_180425_c().func_177951_i((Vec3i)bee.func_180425_c()) <= 16.0)) continue;
                if (!this.isBeingSmoked(this.field_145850_b, this.func_174877_v())) {
                    bee.setBeeAttacker((Entity)playerIn);
                    continue;
                }
                bee.setCannotEnterHiveTicks(400);
            }
        }
    }

    private boolean isBeingSmoked(World worldIn, BlockPos pos) {
        for (int i = 1; i <= 5; ++i) {
            IBlockState state = worldIn.func_180495_p(pos.func_177979_c(i));
            if (state.func_177230_c() == Blocks.field_150350_a) continue;
            return state.func_177230_c() == Init.CAMPFIRE;
        }
        return false;
    }

    private List<Entity> tryReleaseBee(BeeState state) {
        ArrayList list = Lists.newArrayList();
        this.bees.removeIf(entry -> this.releaseBee(((Bee)entry).data, list, state));
        return list;
    }

    public void tryEnterHive(Entity entityIn, boolean isDelivering) {
        this.tryEnterHive(entityIn, isDelivering, 0);
    }

    public void tryEnterHive(Entity entityIn, boolean isDelivering, int i) {
        if (this.bees.size() < 3) {
            NBTTagCompound tag = new NBTTagCompound();
            entityIn.func_189511_e(tag);
            this.bees.add(new Bee(tag, i, isDelivering ? 2400 : 600));
            if (this.field_145850_b != null) {
                if (entityIn instanceof EntityBee) {
                    EntityBee bee = (EntityBee)entityIn;
                    if (!this.hasFlowerPos() || bee.hasFlower() && this.field_145850_b.field_73012_v.nextBoolean()) {
                        this.flowerPos = bee.getFlowerPos();
                    }
                }
                this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), Sounds.BEE_ENTER_HIVE, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            entityIn.func_70106_y();
        }
    }

    private boolean releaseBee(NBTTagCompound data, List<Entity> list, BeeState beeState) {
        if (this.field_145850_b.func_72935_r() && !this.field_145850_b.func_175727_C(this.field_174879_c)) {
            BlockPos blockPos;
            data.func_82580_o("Passengers");
            data.func_82580_o("Leash");
            data.func_82580_o("UUIDLeast");
            data.func_82580_o("UUIDMost");
            Optional<Object> optionalPos = Optional.empty();
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockBeeHive.FACING);
            BlockPos pos1 = this.field_174879_c.func_177967_a(facing, 2);
            if (this.field_145850_b.func_180495_p(pos1).func_185890_d((IBlockAccess)this.field_145850_b, pos1) == Block.field_185506_k) {
                optionalPos = Optional.of(pos1);
            }
            if (!optionalPos.isPresent()) {
                for (EnumFacing f : EnumFacing.field_176754_o) {
                    blockPos = this.field_174879_c.func_177982_a(f.func_82601_c() << 1, f.func_96559_d(), f.func_82599_e() << 1);
                    if (this.field_145850_b.func_180495_p(blockPos).func_185890_d((IBlockAccess)this.field_145850_b, blockPos) != Block.field_185506_k) continue;
                    optionalPos = Optional.of(blockPos);
                    break;
                }
            }
            if (!optionalPos.isPresent()) {
                for (EnumFacing f : new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN}) {
                    blockPos = this.field_174879_c.func_177982_a(f.func_82601_c() << 1, f.func_96559_d(), f.func_82599_e() << 1);
                    if (this.field_145850_b.func_180495_p(blockPos).func_185890_d((IBlockAccess)this.field_145850_b, blockPos) != Block.field_185506_k) continue;
                    optionalPos = Optional.of(blockPos);
                }
            }
            if (optionalPos.isPresent()) {
                blockPos = (BlockPos)optionalPos.get();
                EntityBee entity = new EntityBee(this.field_145850_b);
                entity.func_70020_e(data);
                entity.func_70080_a(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), entity.field_70177_z, entity.field_70125_A);
                if (entity != null) {
                    if (this.hasFlowerPos() && !entity.hasFlower() && this.field_145850_b.field_73012_v.nextFloat() < 0.9f) {
                        entity.setFlowerPos(this.flowerPos);
                    }
                    if (beeState == BeeState.WORKING) {
                        entity.onHoneyDelivered();
                        if (this.field_145850_b.func_175625_s(this.field_174879_c) instanceof TileBeeHive) {
                            int i = this.field_145850_b.field_73012_v.nextInt(100) == 0 ? 2 : 1;
                            this.setHoneyLevel(this.honeyLevel + i, true);
                        }
                    }
                    if (list != null) {
                        entity.resetPollinationTicks();
                        list.add((Entity)entity);
                    }
                }
                this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), Sounds.BEE_EXIT_HIVE, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.field_145850_b.func_72838_d((Entity)entity);
                return true;
            }
        }
        return false;
    }

    private boolean hasFlowerPos() {
        return this.flowerPos != BlockPos.field_177992_a;
    }

    public void tickBees() {
        Iterator<Bee> bees = this.bees.iterator();
        while (bees.hasNext()) {
            Bee bee = bees.next();
            if (bee.ticksInHive > bee.minOccupationTicks) {
                NBTTagCompound tag;
                BeeState state = (tag = bee.data).func_74767_n("HasNectar") ? BeeState.WORKING : BeeState.DELIVERED;
                if (!this.releaseBee(tag, null, state)) continue;
                bees.remove();
                continue;
            }
            ++bee.ticksInHive;
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.tickBees();
            if (this.bees.size() > 0 && this.field_145850_b.field_73012_v.nextDouble() < 0.005) {
                double x = (double)this.field_174879_c.func_177958_n() + 0.5;
                double y = this.field_174879_c.func_177956_o();
                double z = (double)this.field_174879_c.func_177952_p() + 0.5;
                this.field_145850_b.func_184148_a(null, x, y, z, Sounds.BEE_WORK, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public int getHoneyLevel() {
        return this.honeyLevel;
    }

    public void setHoneyLevel(int level, boolean updateState) {
        if (level > 5) {
            level = 5;
        }
        this.honeyLevel = level;
        if (updateState) {
            this.field_145850_b.func_175656_a(this.field_174879_c, this.func_145838_q().func_176223_P().func_177226_a((IProperty)BlockBeeHive.IS_FULL, (Comparable)Boolean.valueOf(level == 5)).func_177226_a((IProperty)BlockBeeHive.FACING, this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockBeeHive.FACING)));
        }
    }

    public boolean isFull() {
        return this.honeyLevel >= 5;
    }

    @Override
    public boolean activated(IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        boolean action = false;
        if (this.isFull()) {
            if (stack.func_77973_b() == Items.field_151097_aZ) {
                this.field_145850_b.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, Sounds.BEEHIVE_SHEAR, SoundCategory.BLOCKS, 1.0f, 1.0f);
                TileBeeHive.dropHoneyCombs(this.field_145850_b, this.field_174879_c);
                stack.func_77972_a(1, (EntityLivingBase)playerIn);
                action = true;
            } else if (stack.func_77973_b() == Items.field_151069_bo) {
                stack.func_190918_g(1);
                this.field_145850_b.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187615_H, SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (stack.func_190926_b()) {
                    playerIn.func_184611_a(hand, new ItemStack(Init.HONEY_BOTTLE));
                } else if (!playerIn.field_71071_by.func_70441_a(new ItemStack(Init.HONEY_BOTTLE))) {
                    playerIn.func_71019_a(new ItemStack(Init.HONEY_BOTTLE), false);
                }
                action = true;
            }
        }
        if (action) {
            TileBeeHive.emptyHoney(this.field_145850_b, state, this.field_174879_c, playerIn);
            return true;
        }
        return false;
    }

    @Override
    public void broken(IBlockState state, EntityPlayer playerIn) {
        if (!this.field_145850_b.field_72995_K && (playerIn.func_184812_l_() || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)playerIn.func_184614_ca()) == 1)) {
            EntityItem item = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), this.getItemWithBees());
            item.func_174869_p();
            this.field_145850_b.func_72838_d((Entity)item);
        }
    }

    public ItemStack getItemWithBees() {
        ItemStack stack = new ItemStack(this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c());
        NBTTagCompound tag = new NBTTagCompound();
        if (!this.bees.isEmpty()) {
            tag.func_74782_a("Bees", (NBTBase)this.getBees());
        }
        tag.func_74768_a("HoneyLevel", this.getHoneyLevel());
        stack.func_77983_a("BlockEntityTag", (NBTBase)tag);
        return stack;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.bees.clear();
        NBTTagList list = compound.func_150295_c("Bees", 10);
        this.setHoneyLevel(compound.func_74762_e("HoneyLevel"), Reflection.getCallerClass((int)2) != TileEntity.class);
        for (NBTBase base : list) {
            NBTTagCompound tag = (NBTTagCompound)base;
            Bee bee = new Bee((NBTTagCompound)tag.func_74781_a("EntityData"), tag.func_74762_e("TicksInHive"), tag.func_74762_e("MinOccupationTicks"));
            this.bees.add(bee);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("Bees", (NBTBase)this.getBees());
        compound.func_74782_a("FlowerPos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.flowerPos));
        compound.func_74768_a("HoneyLevel", this.honeyLevel);
        return compound;
    }

    private NBTTagList getBees() {
        NBTTagList list = new NBTTagList();
        for (Bee bee : this.bees) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74782_a("EntityData", (NBTBase)bee.data);
            tag.func_74768_a("TicksInHive", bee.ticksInHive);
            tag.func_74768_a("MinOccupationTicks", bee.minOccupationTicks);
            list.func_74742_a((NBTBase)tag);
        }
        return list;
    }

    public static void dropHoneyCombs(World worldIn, BlockPos pos) {
        for (int i = 0; i < 3; ++i) {
            Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(Init.HONEY_COMB));
        }
    }

    public static void emptyHoney(World worldIn, IBlockState state, BlockPos pos, EntityPlayer playerIn) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)BlockBeeHive.IS_FULL, (Comparable)Boolean.valueOf(false)), 3);
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileBeeHive) {
            TileBeeHive hive = (TileBeeHive)tile;
            hive.setHoneyLevel(0, true);
            hive.angerBees(playerIn, BeeState.DELIVERED);
        }
    }

    public int getNumberOfBees() {
        return this.bees.size();
    }

    public static enum BeeState {
        WORKING,
        DELIVERED;

    }

    static class Bee {
        private final NBTTagCompound data;
        private int ticksInHive;
        private final int minOccupationTicks;

        Bee(NBTTagCompound data, int ticksInHive, int minOccupationTicks) {
            data.func_74757_a("Leashed", false);
            this.data = data;
            this.ticksInHive = ticksInHive;
            this.minOccupationTicks = minOccupationTicks;
        }
    }
}

