/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.recipe;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import thedarkcolour.futuremc.init.Init;
import thedarkcolour.futuremc.recipe.StonecutterRecipe;

public final class StonecutterRecipes {
    private static final ArrayList<StonecutterRecipe> RECIPES = Lists.newArrayList();

    public static void addDefaults() {
        StonecutterRecipes.addRecipe(Blocks.field_150348_b, new Block[]{Blocks.field_150333_U, Blocks.field_150417_aV}).addOutput(new ItemStack((Block)Blocks.field_150333_U, 1, 5)).addOutput(new ItemStack(Blocks.field_150390_bg)).addOutput(Init.STONE_BRICK_WALL).addOutput(new ItemStack(Blocks.field_150417_aV, 1, 3));
        StonecutterRecipes.addRecipe((Block)Init.SMOOTH_STONE, new ItemStack((Block)Blocks.field_150333_U, 1, 0));
        StonecutterRecipes.addRecipe(Blocks.field_150417_aV, Blocks.field_150390_bg, Init.STONE_BRICK_WALL).addOutput(new ItemStack(Blocks.field_150417_aV, 1, 3));
        StonecutterRecipes.addRecipe(new ItemStack(Blocks.field_150417_aV, 1, 1), new ItemStack((Block)Init.MOSSY_STONE_WALL));
        StonecutterRecipes.addRecipe(new ItemStack(Blocks.field_150348_b, 1, 1), new ItemStack[0]).addOutput(Init.GRANITE_WALL).addOutput(new ItemStack(Blocks.field_150348_b, 1, 2));
        StonecutterRecipes.addRecipe(new ItemStack(Blocks.field_150348_b, 1, 3), new ItemStack[0]).addOutput(Init.DIORITE_WALL);
        StonecutterRecipes.addRecipe(new ItemStack(Blocks.field_150348_b, 1, 5), new ItemStack[0]).addOutput(Init.ANDESITE_WALL);
        StonecutterRecipes.addRecipe(Blocks.field_150347_e, new ItemStack((Block)Blocks.field_150333_U, 1, 3), new ItemStack(Blocks.field_150446_ar), new ItemStack(Blocks.field_150463_bK));
        StonecutterRecipes.addRecipe(new ItemStack(Blocks.field_150341_Y), new ItemStack[0]).addOutput(Blocks.field_150463_bK);
        StonecutterRecipes.addRecipe(new ItemStack(Blocks.field_150322_A), new ItemStack((Block)Blocks.field_150333_U, 1, 1), new ItemStack(Blocks.field_150372_bz), new ItemStack((Block)Init.SANDSTONE_WALL), new ItemStack(Blocks.field_150322_A, 1, 2), new ItemStack(Blocks.field_150322_A, 1, 1));
        StonecutterRecipes.addRecipe(new ItemStack(Blocks.field_180395_cM), new ItemStack((Block)Blocks.field_180389_cP), new ItemStack(Blocks.field_180396_cN), new ItemStack((Block)Init.RED_SANDSTONE_WALL), new ItemStack(Blocks.field_180395_cM, 1, 2), new ItemStack(Blocks.field_180395_cM, 1, 1));
        StonecutterRecipes.addRecipe(new ItemStack(Blocks.field_180397_cI), new ItemStack[0]).addOutput(Init.PRISMARINE_WALL);
        StonecutterRecipes.addRecipe(new ItemStack(Blocks.field_150371_ca), new ItemStack((Block)Blocks.field_150333_U, 1, 7), new ItemStack(Blocks.field_150370_cb), new ItemStack(Blocks.field_150371_ca, 1, 1), new ItemStack(Blocks.field_150371_ca, 1, 2));
        StonecutterRecipes.addRecipe(Blocks.field_185767_cT, new Block[]{Blocks.field_185771_cX, Blocks.field_185769_cV, Blocks.field_185768_cU});
        StonecutterRecipes.addRecipe(Blocks.field_150336_V, new ItemStack((Block)Blocks.field_150333_U, 1, 4)).addOutput(Blocks.field_150389_bf);
        StonecutterRecipes.addRecipe(Blocks.field_150385_bj, new ItemStack((Block)Blocks.field_150333_U, 1, 6), new ItemStack(Blocks.field_150387_bl), new ItemStack((Block)Init.NETHER_BRICK_WALL));
        StonecutterRecipes.addRecipe(Blocks.field_189879_dh, Init.RED_NETHER_BRICK_WALL);
        StonecutterRecipes.addRecipe(Blocks.field_150377_bs, Blocks.field_185772_cY, Init.END_STONE_WALL);
        StonecutterRecipes.addRecipe(Blocks.field_185772_cY, Init.END_STONE_WALL);
    }

    public static StonecutterRecipe addRecipe(ItemStack input, ItemStack ... outputs) {
        StonecutterRecipe recipe = new StonecutterRecipe(input, outputs);
        RECIPES.add(recipe);
        return recipe;
    }

    public static StonecutterRecipe addRecipe(Block input, ItemStack ... outputs) {
        return StonecutterRecipes.addRecipe(new ItemStack(input), outputs);
    }

    public static StonecutterRecipe addRecipe(Block input, Block ... outputs) {
        return StonecutterRecipes.addRecipe(new ItemStack(input), (ItemStack[])Arrays.stream(outputs).map(ItemStack::new).toArray(ItemStack[]::new));
    }

    public static void addOrCreateRecipe(ItemStack input, ItemStack ... outputs) {
        Optional<StonecutterRecipe> recipe = StonecutterRecipes.getRecipe(input);
        if (recipe.isPresent()) {
            for (ItemStack output : outputs) {
                recipe.get().addOutput(output);
            }
        } else {
            StonecutterRecipes.addRecipe(input, outputs);
        }
    }

    public static void removeOutputs(ItemStack input, ItemStack ... outputs) {
        StonecutterRecipes.getRecipe(input).ifPresent(recipe -> {
            for (ItemStack output : outputs) {
                recipe.removeOutput(output);
            }
        });
    }

    public static Optional<StonecutterRecipe> getRecipe(ItemStack input) {
        return RECIPES.stream().filter(recipe -> recipe.matches(input)).findFirst();
    }

    public static void removeRecipe(ItemStack input) {
        RECIPES.removeIf(recipe -> recipe.matches(input));
    }

    public static void clear() {
        RECIPES.clear();
    }

    public static ArrayList<StonecutterRecipe> allRecipes() {
        return RECIPES;
    }
}

