/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.item;

import com.google.common.collect.Multimap;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import thedarkcolour.core.item.ItemModeled;
import thedarkcolour.futuremc.FutureMC;
import thedarkcolour.futuremc.enchantment.EnchantHelper;
import thedarkcolour.futuremc.entity.trident.EntityTrident;
import thedarkcolour.futuremc.init.FutureConfig;
import thedarkcolour.futuremc.sound.Sounds;

public class ItemTrident
extends ItemModeled {
    public ItemTrident() {
        super("Trident");
        this.setCreativeTab((CreativeTabs)(FutureConfig.general.useVanillaTabs ? CreativeTabs.field_78037_j : FutureMC.TAB));
        this.func_77656_e(250);
        this.func_77625_d(1);
    }

    public boolean canDestroyBlockInCreative(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        return false;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    public boolean func_77616_k(ItemStack stack) {
        return FutureConfig.general.tridentIsEnchantable;
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            int j;
            EntityPlayer entityPlayer = (EntityPlayer)entityLiving;
            int i = this.getUseDuration(stack, timeLeft);
            if (i >= 10 && ((j = EnchantHelper.getRiptide(stack)) <= 0 || entityPlayer.func_70026_G())) {
                if (!worldIn.field_72995_K) {
                    stack.func_77972_a(1, (EntityLivingBase)entityPlayer);
                    if (j == 0) {
                        EntityTrident trident = new EntityTrident(worldIn, (EntityLivingBase)entityPlayer, stack);
                        trident.func_184547_a((Entity)entityLiving, entityPlayer.field_70125_A, entityPlayer.field_70177_z, 0.0f, 2.5f + (float)j * 0.5f, 1.0f);
                        if (entityPlayer.field_71075_bZ.field_75098_d) {
                            trident.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                        }
                        worldIn.func_72838_d((Entity)trident);
                        if (!entityPlayer.field_71075_bZ.field_75098_d) {
                            entityPlayer.field_71071_by.func_184437_d(stack);
                        }
                    }
                }
                SoundEvent soundevent = Sounds.TRIDENT_THROW;
                if (j > 0) {
                    float f = entityPlayer.field_70177_z;
                    float f1 = entityPlayer.field_70125_A;
                    float f2 = -MathHelper.func_76126_a((float)(f * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(f1 * ((float)Math.PI / 180)));
                    float f3 = -MathHelper.func_76126_a((float)(f1 * ((float)Math.PI / 180)));
                    float f4 = MathHelper.func_76134_b((float)(f * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(f1 * ((float)Math.PI / 180)));
                    float f5 = MathHelper.func_76129_c((float)(f2 * f2 + f3 * f3 + f4 * f4));
                    float f6 = 3.0f * ((1.0f + (float)j) / 4.0f);
                    entityPlayer.func_70024_g((double)(f2 *= f6 / f5), (double)(f3 *= f6 / f5), (double)(f4 *= f6 / f5));
                    soundevent = j >= 3 ? Sounds.TRIDENT_RIPTIDE_2 : (j == 2 ? Sounds.TRIDENT_RIPTIDE_1 : Sounds.TRIDENT_RIPTIDE_0);
                    if (entityPlayer.field_70122_E) {
                        entityPlayer.func_70091_d(MoverType.SELF, 0.0, 1.1999999284744263, 0.0);
                    }
                }
                worldIn.func_184148_a(null, entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v, soundevent, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack itemstack = playerIn.func_184586_b(hand);
        if (itemstack.func_77952_i() >= itemstack.func_77958_k()) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        if (EnchantHelper.getRiptide(itemstack) > 0 && !playerIn.func_70026_G()) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        playerIn.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        stack.func_77972_a(1, attacker);
        return true;
    }

    private int getUseDuration(ItemStack stack, int timeLeft) {
        return stack.func_77988_m() - timeLeft;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        if ((double)state.func_185887_b(worldIn, pos) != 0.0) {
            stack.func_77972_a(2, entityLiving);
        }
        return true;
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 8.0, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)-2.9f, 0));
        }
        return multimap;
    }

    public int func_77619_b() {
        return 1;
    }

    public int func_77639_j() {
        return 1;
    }
}

