/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import thedarkcolour.core.item.ItemModeled;
import thedarkcolour.futuremc.FutureMC;
import thedarkcolour.futuremc.enchantment.EnchantHelper;
import thedarkcolour.futuremc.entity.horizontal_firework.EntityHorizontalFireworksRocket;
import thedarkcolour.futuremc.init.FutureConfig;
import thedarkcolour.futuremc.init.Init;
import thedarkcolour.futuremc.sound.Sounds;

public class ItemCrossBow
extends ItemModeled {
    public ItemCrossBow() {
        super("Crossbow");
        this.func_77625_d(1);
        this.func_77656_e(326);
        this.setCreativeTab((CreativeTabs)(FutureConfig.general.useVanillaTabs ? CreativeTabs.field_78037_j : FutureMC.TAB));
        this.func_185043_a(new ResourceLocation("pull"), (stack, worldIn, entityIn) -> entityIn == null || entityIn.func_184607_cu().func_77973_b() != Init.CROSSBOW || ItemCrossBow.isLoaded(stack) ? 0.0f : (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 20.0f);
        this.func_185043_a(new ResourceLocation("pulling"), (stack, worldIn, entityIn) -> !ItemCrossBow.isLoaded(stack) && entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f);
        this.func_185043_a(new ResourceLocation("loaded"), (stack, worldIn, entityIn) -> ItemCrossBow.isLoaded(stack) ? 1.0f : 0.0f);
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public String func_77653_i(ItemStack stack) {
        return ItemCrossBow.isLoaded(stack) ? I18n.func_135052_a((String)"item.minecraftfuture.Crossbow_Loaded.name", (Object[])new Object[0]) : I18n.func_135052_a((String)"item.minecraftfuture.Crossbow.name", (Object[])new Object[0]);
    }

    public void setIsLoaded(ItemStack stack, boolean isLoading) {
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74757_a("isLoaded", isLoading);
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entity, int timeLeft) {
        int i = this.getUseDuration(stack, timeLeft);
        float f = ItemCrossBow.func_220031_a(i, stack);
        if (f >= 1.0f && !ItemCrossBow.isLoaded(stack) && ItemCrossBow.func_220021_a(entity, stack)) {
            this.setIsLoaded(stack, true);
            SoundCategory category = entity instanceof EntityPlayer ? SoundCategory.PLAYERS : SoundCategory.HOSTILE;
            worldIn.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, Sounds.CROSSBOW_LOAD, category, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.5f + 1.0f) + 0.2f);
        }
    }

    private static boolean func_220021_a(EntityLivingBase entity, ItemStack stack) {
        boolean flag = EnchantHelper.hasMultishot(stack);
        int j = flag ? 1 : 3;
        boolean flag1 = entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_();
        ItemStack ammo = ItemCrossBow.findAmmo(entity);
        ItemStack itemstack1 = ammo.func_77946_l();
        for (int k = 0; k < j; ++k) {
            if (k > 0) {
                ammo = itemstack1.func_77946_l();
            }
            if (ammo.func_190926_b() && flag1) {
                ammo = new ItemStack(Items.field_151032_g);
                itemstack1 = ammo.func_77946_l();
            }
            if (ItemCrossBow.loadCrossbow(entity, stack, ammo, k > 0, flag1)) continue;
            return false;
        }
        return true;
    }

    private static boolean loadCrossbow(EntityLivingBase entity, ItemStack crossbow, ItemStack ammo, boolean isCopy, boolean isCreative) {
        ItemStack itemstack;
        boolean flag;
        if (ammo.func_190926_b()) {
            return false;
        }
        boolean bl = flag = isCreative && ammo.func_77973_b() instanceof ItemArrow;
        if (!(flag || isCreative || isCopy)) {
            itemstack = ammo.func_77979_a(1);
            if (ammo.func_190926_b() && entity instanceof EntityPlayer) {
                ((EntityPlayer)entity).field_71071_by.func_184437_d(ammo);
            }
        } else {
            itemstack = ammo.func_77946_l();
        }
        ItemCrossBow.addStacksToCrossbow(crossbow, itemstack);
        return true;
    }

    private static void addStacksToCrossbow(ItemStack crossbow, ItemStack stack) {
        NBTTagCompound tag = ItemCrossBow.getOrCreateTag(crossbow);
        NBTTagList nbtList = tag.func_150297_b("ChargedProjectiles", 9) ? tag.func_150295_c("ChargedProjectiles", 10) : new NBTTagList();
        NBTTagCompound tag1 = new NBTTagCompound();
        stack.func_77982_d(tag1);
        nbtList.func_74742_a((NBTBase)tag1);
        tag.func_74782_a("ChargedProjectiles", (NBTBase)nbtList);
    }

    private static NBTTagCompound getOrCreateTag(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack crossbow = playerIn.func_184586_b(hand);
        if (ItemCrossBow.isLoaded(crossbow)) {
            ItemCrossBow.func_220014_a(worldIn, (EntityLivingBase)playerIn, hand, crossbow, ItemCrossBow.func_220013_l(crossbow), 1.0f);
            this.setIsLoaded(crossbow, false);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)crossbow);
        }
        if (!ItemCrossBow.findAmmo((EntityLivingBase)playerIn).func_190926_b()) {
            if (!ItemCrossBow.isLoaded(crossbow)) {
                playerIn.func_184598_c(hand);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)crossbow);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)crossbow);
    }

    public static void func_220014_a(World worldIn, EntityLivingBase entity, EnumHand hand, ItemStack crossbow, float p_220014_4_, float p_220014_5_) {
        List<ItemStack> list = ItemCrossBow.getLoadedAmmo(crossbow);
        float[] rng = ItemCrossBow.getDirectionsForArrows(entity.func_70681_au());
        for (int i = 0; i < list.size(); ++i) {
            boolean isCreative;
            ItemStack ammo = list.get(i);
            boolean bl = isCreative = entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_();
            if (ammo.func_190926_b()) continue;
            if (i == 0) {
                ItemCrossBow.func_220016_a(worldIn, entity, hand, crossbow, ammo, rng[i], isCreative, p_220014_4_, p_220014_5_, 0.0f);
                continue;
            }
            if (i == 1) {
                ItemCrossBow.func_220016_a(worldIn, entity, hand, crossbow, ammo, rng[i], isCreative, p_220014_4_, p_220014_5_, -10.0f);
                continue;
            }
            if (i != 2) continue;
            ItemCrossBow.func_220016_a(worldIn, entity, hand, crossbow, ammo, rng[i], isCreative, p_220014_4_, p_220014_5_, 10.0f);
        }
        ItemCrossBow.func_220027_k(crossbow);
    }

    private static void func_220027_k(ItemStack crossbow) {
        NBTTagCompound tag = crossbow.func_77978_p();
        if (tag != null) {
            NBTTagList tagList = tag.func_150295_c("ChargedProjectiles", 9);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                tagList.func_74744_a(i);
            }
            tag.func_74782_a("ChargedProjectiles", (NBTBase)tagList);
        }
    }

    private static void func_220016_a(World worldIn, EntityLivingBase entity, EnumHand hand, ItemStack crossbow, ItemStack ammo, float p_220016_5_, boolean isCreative, float p_220016_7_, float p_220016_8_, float offset) {
        if (!worldIn.field_72995_K) {
            boolean flag;
            boolean bl = flag = ammo.func_77973_b() == Items.field_151152_bP;
            if (flag) {
                EntityHorizontalFireworksRocket iprojectile = new EntityHorizontalFireworksRocket(worldIn, ammo, entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e() - (double)0.15f, entity.field_70161_v);
            } else {
                EntityArrow iprojectile = ItemCrossBow.createArrow(worldIn, entity, crossbow, ammo);
                if (isCreative || offset != 0.0f) {
                    iprojectile.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                }
            }
        }
    }

    private static EntityArrow createArrow(World worldIn, EntityLivingBase shooter, ItemStack crossbow, ItemStack ammo) {
        ItemArrow arrowitem = (ItemArrow)(ammo.func_77973_b() instanceof ItemArrow ? ammo.func_77973_b() : Items.field_151032_g);
        EntityArrow arrow = arrowitem.func_185052_a(worldIn, crossbow, shooter);
        if (shooter instanceof EntityPlayer) {
            arrow.func_70243_d(true);
        }
        arrow.func_70243_d(true);
        return arrow;
    }

    private static float[] getDirectionsForArrows(Random random) {
        boolean flag = random.nextBoolean();
        return new float[]{1.0f, ItemCrossBow.getDirection(flag), ItemCrossBow.getDirection(!flag)};
    }

    private static float getDirection(boolean isLeft) {
        float f = isLeft ? 0.63f : 0.43f;
        return 1.0f / (field_77697_d.nextFloat() * 0.5f + 1.8f) + f;
    }

    private static List<ItemStack> getLoadedAmmo(ItemStack crossbow) {
        NBTTagList listnbt;
        ArrayList list = Lists.newArrayList();
        NBTTagCompound compoundnbt = crossbow.func_77978_p();
        if (compoundnbt != null && compoundnbt.func_150297_b("ChargedProjectiles", 9) && (listnbt = compoundnbt.func_150295_c("ChargedProjectiles", 10)) != null) {
            for (int i = 0; i < listnbt.func_74745_c(); ++i) {
                NBTTagCompound compoundnbt1 = listnbt.func_150305_b(i);
                list.add(ItemCrossBow.read(compoundnbt1));
            }
        }
        return list;
    }

    public static ItemStack read(NBTTagCompound compound) {
        return new ItemStack(compound);
    }

    public static ItemStack findAmmo(EntityLivingBase entity) {
        if (!(entity instanceof EntityPlayer) && !(entity instanceof EntityMob)) {
            return ItemStack.field_190927_a;
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack itemstack = player.field_71071_by.func_70301_a(i);
                if (!ItemCrossBow.isAmmo(itemstack)) continue;
                return itemstack;
            }
        } else if (entity instanceof EntityMob) {
            return new ItemStack(Items.field_151032_g);
        }
        return ItemStack.field_190927_a;
    }

    public static boolean isAmmo(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemArrow;
    }

    private static float func_220031_a(int p_220031_0_, ItemStack stack) {
        float f = (float)p_220031_0_ / (float)EnchantHelper.getQuickCharge(stack);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    private int getUseDuration(ItemStack stack, int timeLeft) {
        return stack.func_77988_m() - timeLeft;
    }

    private static boolean isLoaded(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        return tag != null && tag.func_74767_n("isLoaded");
    }

    private static boolean func_220019_a(ItemStack p_220019_0_) {
        return ItemCrossBow.getLoadedAmmo(p_220019_0_).stream().anyMatch(p_220010_1_ -> p_220010_1_.func_77973_b() == Items.field_151152_bP);
    }

    private static float func_220013_l(ItemStack p_220013_0_) {
        return p_220013_0_.func_77973_b() == Init.CROSSBOW && ItemCrossBow.func_220019_a(p_220013_0_) ? 1.6f : 3.15f;
    }
}

