/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.init;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thedarkcolour.core.item.ItemDebugger;
import thedarkcolour.core.item.Modeled;
import thedarkcolour.futuremc.FutureMC;
import thedarkcolour.futuremc.compat.oredict.OreDict;
import thedarkcolour.futuremc.init.FutureConfig;
import thedarkcolour.futuremc.init.Init;
import thedarkcolour.futuremc.item.ItemGroup;
import thedarkcolour.futuremc.tile.TileBarrel;
import thedarkcolour.futuremc.tile.TileBeeHive;
import thedarkcolour.futuremc.tile.TileCampfire;
import thedarkcolour.futuremc.tile.TileComposter;
import thedarkcolour.futuremc.tile.TileFurnaceAdvanced;
import thedarkcolour.futuremc.world.gen.feature.BeeNestGenerator;
import thedarkcolour.futuremc.world.gen.feature.WorldGenBamboo;
import thedarkcolour.futuremc.world.gen.feature.WorldGenFlower;

public final class InitElements {
    public static ArrayList<Modeled> MODELED = new ArrayList();

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        FutureMC.TAB = FutureConfig.general.useVanillaTabs ? null : new ItemGroup();
        IForgeRegistry r = event.getRegistry();
        if (FutureConfig.general.lantern) {
            r.register((IForgeRegistryEntry)Init.LANTERN);
        }
        if (FutureConfig.general.stonecutter) {
            r.register((IForgeRegistryEntry)Init.STONECUTTER);
        }
        if (FutureConfig.general.barrel) {
            r.register((IForgeRegistryEntry)Init.BARREL);
        }
        if (FutureConfig.general.blastFurnace) {
            r.register((IForgeRegistryEntry)Init.BLAST_FURNACE);
        }
        if (FutureConfig.general.smoker) {
            r.register((IForgeRegistryEntry)Init.SMOKER);
        }
        if (FutureConfig.general.loom) {
            r.register((IForgeRegistryEntry)Init.LOOM);
        }
        if (FutureConfig.general.fletchingTable) {
            r.register((IForgeRegistryEntry)Init.FLETCHING_TABLE);
        }
        if (FutureConfig.general.smithingTable) {
            r.register((IForgeRegistryEntry)Init.SMITHING_TABLE);
        }
        if (FutureConfig.general.grindstone) {
            r.register((IForgeRegistryEntry)Init.GRINDSTONE);
        }
        if (FutureConfig.general.composter) {
            r.register((IForgeRegistryEntry)Init.COMPOSTER);
        }
        if (FutureMC.DEBUG) {
            r.register((IForgeRegistryEntry)Init.SCAFFOLDING);
        }
        if (FutureConfig.general.blueIce) {
            r.register((IForgeRegistryEntry)Init.BLUE_ICE);
        }
        if (FutureConfig.general.bee) {
            r.registerAll((IForgeRegistryEntry[])new Block[]{Init.BEE_NEST, Init.BEE_HIVE, Init.HONEY_BLOCK, Init.HONEYCOMB_BLOCK});
        }
        if (FutureConfig.modFlowers.cornflower) {
            r.register((IForgeRegistryEntry)Init.CORNFLOWER);
        }
        if (FutureConfig.modFlowers.lily) {
            r.register((IForgeRegistryEntry)Init.LILY_OF_VALLEY);
        }
        if (FutureConfig.modFlowers.witherRose) {
            r.register((IForgeRegistryEntry)Init.WITHER_ROSE);
        }
        if (FutureConfig.general.berryBush) {
            r.register((IForgeRegistryEntry)Init.SWEET_BERRY_BUSH);
        }
        if (FutureConfig.general.campfire) {
            r.register((IForgeRegistryEntry)Init.CAMPFIRE);
        }
        if (FutureConfig.general.strippedLogs) {
            r.registerAll((IForgeRegistryEntry[])new Block[]{Init.STRIPPED_OAK_LOG, Init.STRIPPED_SPRUCE_LOG, Init.STRIPPED_BIRCH_LOG, Init.STRIPPED_JUNGLE_LOG, Init.STRIPPED_ACACIA_LOG, Init.STRIPPED_DARK_OAK_LOG});
        }
        if (FutureConfig.general.newWallVariants) {
            r.registerAll((IForgeRegistryEntry[])new Block[]{Init.BRICK_WALL, Init.GRANITE_WALL, Init.ANDESITE_WALL, Init.DIORITE_WALL, Init.SANDSTONE_WALL, Init.RED_SANDSTONE_WALL, Init.STONE_BRICK_WALL, Init.MOSSY_STONE_WALL, Init.NETHER_BRICK_WALL, Init.RED_NETHER_BRICK_WALL, Init.END_STONE_WALL, Init.PRISMARINE_WALL});
        }
        if (FutureConfig.general.smoothStone) {
            r.register((IForgeRegistryEntry)Init.SMOOTH_STONE);
        }
        if (FutureConfig.general.smoothQuartz) {
            r.register((IForgeRegistryEntry)Init.SMOOTH_QUARTZ);
        }
        if (FutureConfig.general.bamboo) {
            r.register((IForgeRegistryEntry)Init.BAMBOO_STALK);
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry r = event.getRegistry();
        if (FutureConfig.general.lantern) {
            r.register((IForgeRegistryEntry)InitElements.makeItemBlock(Init.LANTERN));
        }
        if (FutureConfig.general.stonecutter) {
            r.register((IForgeRegistryEntry)InitElements.makeItemBlock(Init.STONECUTTER));
        }
        if (FutureConfig.general.barrel && !Init.isCharmItemLoaded("barrel")) {
            r.register((IForgeRegistryEntry)InitElements.makeItemBlock(Init.BARREL));
        }
        if (FutureConfig.general.blastFurnace) {
            r.register((IForgeRegistryEntry)InitElements.makeItemBlock(Init.BLAST_FURNACE));
        }
        if (FutureConfig.general.smoker) {
            r.register((IForgeRegistryEntry)InitElements.makeItemBlock(Init.SMOKER));
        }
        if (FutureConfig.general.loom) {
            r.register((IForgeRegistryEntry)InitElements.makeItemBlock(Init.LOOM));
        }
        if (FutureConfig.general.fletchingTable) {
            r.register((IForgeRegistryEntry)InitElements.makeItemBlock(Init.FLETCHING_TABLE));
        }
        if (FutureConfig.general.smithingTable) {
            r.register((IForgeRegistryEntry)InitElements.makeItemBlock(Init.SMITHING_TABLE));
        }
        if (FutureConfig.general.grindstone) {
            r.register((IForgeRegistryEntry)InitElements.makeItemBlock(Init.GRINDSTONE));
        }
        if (FutureConfig.general.composter) {
            r.register((IForgeRegistryEntry)InitElements.makeItemBlock(Init.COMPOSTER));
        }
        if (FutureMC.DEBUG) {
            r.register((IForgeRegistryEntry)InitElements.makeItemBlock(Init.SCAFFOLDING));
        }
        if (FutureConfig.general.blueIce) {
            r.register((IForgeRegistryEntry)InitElements.makeItemBlock(Init.BLUE_ICE));
        }
        if (FutureConfig.general.bee) {
            r.registerAll((IForgeRegistryEntry[])new Item[]{InitElements.makeItemBlock(Init.BEE_NEST), InitElements.makeItemBlock(Init.BEE_HIVE), InitElements.makeItemBlock(Init.HONEY_BLOCK), InitElements.makeItemBlock(Init.HONEYCOMB_BLOCK), Init.HONEY_BOTTLE, Init.HONEY_COMB});
        }
        if (FutureConfig.general.trident) {
            r.register((IForgeRegistryEntry)Init.TRIDENT);
        }
        if (FutureConfig.modFlowers.lily) {
            r.register((IForgeRegistryEntry)InitElements.makeItemBlock((Block)Init.LILY_OF_VALLEY));
        }
        if (FutureConfig.modFlowers.cornflower) {
            r.register((IForgeRegistryEntry)InitElements.makeItemBlock((Block)Init.CORNFLOWER));
        }
        if (FutureConfig.modFlowers.witherRose) {
            r.register((IForgeRegistryEntry)InitElements.makeItemBlock((Block)Init.WITHER_ROSE));
        }
        if (FutureConfig.modFlowers.suspiciousStew) {
            r.register((IForgeRegistryEntry)Init.SUSPICIOUS_STEW);
        }
        if (FutureConfig.general.loom && FutureMC.DEBUG) {
            r.register((IForgeRegistryEntry)Init.PATTERNS);
        }
        if (FutureConfig.modFlowers.dyes) {
            r.register((IForgeRegistryEntry)Init.DYES);
        }
        if (FutureConfig.general.bamboo) {
            r.register((IForgeRegistryEntry)Init.BAMBOO_ITEM);
        }
        if (FutureConfig.general.berryBush) {
            r.register((IForgeRegistryEntry)Init.SWEET_BERRY);
        }
        if (FutureConfig.general.campfire) {
            r.register((IForgeRegistryEntry)InitElements.makeItemBlock(Init.CAMPFIRE));
        }
        if (FutureConfig.general.strippedLogs) {
            r.registerAll((IForgeRegistryEntry[])InitElements.makeItemBlocks(new Block[]{Init.STRIPPED_OAK_LOG, Init.STRIPPED_SPRUCE_LOG, Init.STRIPPED_BIRCH_LOG, Init.STRIPPED_JUNGLE_LOG, Init.STRIPPED_ACACIA_LOG, Init.STRIPPED_DARK_OAK_LOG}));
        }
        if (FutureConfig.general.smoothStone) {
            r.register((IForgeRegistryEntry)InitElements.makeItemBlock(Init.SMOOTH_STONE));
        }
        if (FutureConfig.general.smoothQuartz) {
            r.register((IForgeRegistryEntry)InitElements.makeItemBlock(Init.SMOOTH_QUARTZ));
        }
        if (FutureConfig.general.newWallVariants) {
            r.registerAll((IForgeRegistryEntry[])InitElements.makeItemBlocks(Init.BRICK_WALL, Init.GRANITE_WALL, Init.ANDESITE_WALL, Init.DIORITE_WALL, Init.SANDSTONE_WALL, Init.RED_SANDSTONE_WALL, Init.STONE_BRICK_WALL, Init.MOSSY_STONE_WALL, Init.NETHER_BRICK_WALL, Init.RED_NETHER_BRICK_WALL, Init.END_STONE_WALL, Init.PRISMARINE_WALL));
        }
        if (FutureMC.DEBUG) {
            r.register((IForgeRegistryEntry)new ItemDebugger());
        }
        InitElements.registerTileEntities();
        OreDict.registerOres();
    }

    public static void registerTileEntities() {
        if (FutureConfig.general.barrel) {
            GameRegistry.registerTileEntity(TileBarrel.class, (ResourceLocation)new ResourceLocation("minecraftfuture", "containerBarrel"));
        }
        if (FutureConfig.general.blastFurnace) {
            GameRegistry.registerTileEntity(TileFurnaceAdvanced.TileBlastFurnace.class, (ResourceLocation)new ResourceLocation("minecraftfuture", "containerBlastFurnace"));
        }
        if (FutureConfig.general.smoker) {
            GameRegistry.registerTileEntity(TileFurnaceAdvanced.TileSmoker.class, (ResourceLocation)new ResourceLocation("minecraftfuture", "containerSmoker"));
        }
        if (FutureConfig.general.composter) {
            GameRegistry.registerTileEntity(TileComposter.class, (ResourceLocation)new ResourceLocation("minecraftfuture", "composter"));
        }
        if (FutureConfig.general.bee) {
            GameRegistry.registerTileEntity(TileBeeHive.class, (ResourceLocation)new ResourceLocation("minecraftfuture", "beehive"));
        }
        if (FutureConfig.general.campfire) {
            GameRegistry.registerTileEntity(TileCampfire.class, (ResourceLocation)new ResourceLocation("minecraftfuture", "campfire"));
        }
    }

    @SubscribeEvent
    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        if (FutureConfig.general.addLegacyBambooJungle) {
            InitElements.registerBiome(event, Init.BIOME_BAMBOO_JUNGLE, "bamboo_forest", BiomeManager.BiomeType.WARM, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.RARE, BiomeDictionary.Type.FOREST);
        }
    }

    public static void registerBiome(RegistryEvent.Register<Biome> event, Biome biome, String name, BiomeManager.BiomeType type, BiomeDictionary.Type ... types) {
        biome.setRegistryName(name);
        event.getRegistry().register((IForgeRegistryEntry)biome);
        BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])types);
        BiomeManager.addBiome((BiomeManager.BiomeType)type, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(biome, 50));
        BiomeManager.addSpawnBiome((Biome)biome);
    }

    public static Item makeItemBlock(Block block) {
        return (Item)new ItemModeledBlock(block).setRegistryName(block.getRegistryName());
    }

    public static Item[] makeItemBlocks(Block ... blocks) {
        ArrayList<Item> list = new ArrayList<Item>();
        for (Block block : blocks) {
            list.add(InitElements.makeItemBlock(block));
        }
        return list.toArray(new Item[0]);
    }

    public static void registerGenerators() {
        if (FutureConfig.modFlowers.lily && FutureConfig.modFlowers.lilyGen) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenFlower(Init.LILY_OF_VALLEY), (int)0);
        }
        if (FutureConfig.modFlowers.cornflower && FutureConfig.modFlowers.cornflowerGen) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenFlower(Init.CORNFLOWER), (int)0);
        }
        if (FutureConfig.general.berryBush && FutureConfig.general.berryBushGen) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenFlower(Init.SWEET_BERRY_BUSH), (int)0);
        }
        if (FutureConfig.general.bamboo && FutureConfig.general.bambooSpawnsInJungles) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenBamboo(), (int)0);
        }
        if (FutureConfig.general.bee) {
            BeeNestGenerator.init();
        }
    }

    public static class ItemModeledBlock
    extends ItemBlock
    implements Modeled {
        public ItemModeledBlock(Block block) {
            super(block);
            this.addModel();
        }
    }
}

