/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.init;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="minecraftfuture", name="future-mc/future-mc")
public final class FutureConfig {
    private static final String MODID = "future-mc";
    static final String CONFIG_NAME = "future-mc/future-mc";
    @Config.Name(value="General")
    @Config.Comment(value={"Most config options for the mod are found here."})
    public static General general = new General();
    @Config.Name(value="Flowers")
    @Config.Comment(value={"Config options related to the new flowers are found here."})
    public static Flowers modFlowers = new Flowers();

    @Mod.EventBusSubscriber(modid="minecraftfuture")
    protected static final class ChangeHandler {
        protected ChangeHandler() {
        }

        @SubscribeEvent
        public static void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("minecraftfuture")) {
                ConfigManager.sync((String)"minecraftfuture", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class Flowers {
        @Config.Name(value="Lily of the Valley")
        @Config.Comment(value={"Whether the Lily of the Valley flower is added to the game."})
        @Config.RequiresMcRestart
        public boolean lily = true;
        @Config.Name(value="Lily of the Valley generates")
        @Config.Comment(value={"Whether the Lily of the Valley flower naturally generates in the world."})
        @Config.RequiresMcRestart
        public boolean lilyGen = true;
        @Config.Name(value="Lily of the Valley Spawn Percent")
        @Config.Comment(value={"Lower means that less flower patches spawn."})
        @Config.RangeInt(min=0, max=100)
        public int lilyChance = 50;
        @Config.Name(value="Cornflower")
        @Config.Comment(value={"Whether the Cornflower flower is added to the game."})
        @Config.RequiresMcRestart
        public boolean cornflower = true;
        @Config.Name(value="Cornflower generates")
        @Config.Comment(value={"Whether the Cornflower flower naturally generates in the world."})
        @Config.RequiresMcRestart
        public boolean cornflowerGen = true;
        @Config.Name(value="Cornflower Spawn Percent")
        @Config.Comment(value={"Lower means that less flower patches spawn."})
        @Config.RangeInt(min=0, max=100)
        public int cornflowerChance = 50;
        @Config.Name(value="Wither Rose")
        @Config.Comment(value={"Whether the Wither Rose flower is added to the game."})
        @Config.RequiresMcRestart
        public boolean witherRose = true;
        @Config.Name(value="Wither Rose Damage")
        @Config.Comment(value={"Whether the Wither Rose flower will deal damage when walked on."})
        public boolean witherRoseDMG = true;
        @Config.Name(value="New Dyes")
        @Config.Comment(value={"Whether the new dyes from 1.14 are added to the game."})
        @Config.RequiresMcRestart
        public boolean dyes = true;
        @Config.Name(value="Suspicious Stew")
        @Config.Comment(value={"Whether the Suspicious Stew item is added to the game."})
        @Config.RequiresMcRestart
        public boolean suspiciousStew = true;
        @Config.Name(value="Suspicious Stew effects")
        @Config.Comment(value={"Whether the Suspicious Stew item gives an effect when consumed."})
        public boolean suspiciousStewEffect = true;
        @Config.Name(value="Suspicious Stew Random Effect")
        @Config.Comment(value={"Whether the Suspicious Stew grants a random effect rather than an effect based on what flower it was crafted with"})
        public boolean isSuspiciousStewRandom = true;
    }

    public static class General {
        @Config.Name(value="ItemTrident")
        @Config.Comment(value={"Whether the ItemTrident weapon is added to the game."})
        @Config.RequiresMcRestart
        public boolean trident = true;
        @Config.Name(value="Trident enchantable in enchanting table")
        @Config.Comment(value={"Whether the Trident can be enchanted in the enchanting table. If false, you must first enchant books and apply them to the Trident."})
        public boolean tridentIsEnchantable = true;
        @Config.Name(value="Lantern")
        @Config.Comment(value={"Whether the Lantern block is added to the game."})
        @Config.RequiresMcRestart
        public boolean lantern = true;
        @Config.Name(value="Stonecutter")
        @Config.Comment(value={"Whether the Stonecutter block is added to the game.", "This block is decorative only."})
        @Config.RequiresMcRestart
        public boolean stonecutter = true;
        @Config.Name(value="Stonecutter Recipe Button")
        @Config.Comment(value={"When JEI is installed, a recipes button is added to the Stonecutter gui. Set this to false if you don't want it to appear. If false, there is no other place in the Stonecutter gui to find all the recipes. Although this option doesn't require a restart, the clickable area will remain until you restart."})
        public boolean stonecutterRecipeButton = true;
        @Config.Name(value="Loom")
        @Config.Comment(value={"Whether the Loom block is added to the game.", "This block is decorative only."})
        @Config.RequiresMcRestart
        public boolean loom = true;
        @Config.Name(value="Barrel")
        @Config.Comment(value={"Whether the Barrel storage block is added to the game."})
        @Config.RequiresMcRestart
        public boolean barrel = true;
        @Config.Name(value="Berry Bush")
        @Config.Comment(value={"Whether the Berry Bush is added to the game.", "If disabled, sweetberries are also disabled."})
        @Config.RequiresMcRestart
        public boolean berryBush = true;
        @Config.Name(value="Berry Bush generates")
        @Config.Comment(value={"Whether the Berry Bush naturally generates in the world."})
        @Config.RequiresMcRestart
        public boolean berryBushGen = true;
        @Config.Name(value="Berry Bush Spawn Percent")
        @Config.Comment(value={"Lower means that less bushing patches spawn."})
        @Config.RangeInt(min=0, max=100)
        public int berryBushChance = 50;
        @Config.Name(value="Campfire")
        @Config.Comment(value={"Whether the Campfire block is added to the game."})
        @Config.RequiresMcRestart
        public boolean campfire = true;
        @Config.Name(value="Campfire damage")
        @Config.Comment(value={"Whether the Campfire hurts you when you walk on it."})
        public boolean campfireDMG = true;
        @Config.Name(value="New Wall Variants")
        @Config.Comment(value={"Whether the 1.14 Wall Variants are added."})
        @Config.RequiresMcRestart
        public boolean newWallVariants = true;
        @Config.Name(value="Stripped Logs")
        @Config.Comment(value={"Whether stripped logs are added to the game, ", "and whether using an axe on general log will strip the log"})
        @Config.RequiresMcRestart
        public boolean strippedLogs = true;
        @Config.Name(value="Smooth Stone")
        @Config.Comment(value={"Whether the smooth stone block is added to the game."})
        @Config.RequiresMcRestart
        public boolean smoothStone = true;
        @Config.Name(value="Smooth Quartz")
        @Config.Comment(value={"Whether the smooth quartz block is added to the game."})
        @Config.RequiresMcRestart
        public boolean smoothQuartz = true;
        @Config.Name(value="Smoker")
        @Config.Comment(value={"Whether the Smoker block is added to the game."})
        @Config.RequiresMcRestart
        public boolean smoker = true;
        @Config.Name(value="Blast Furnace")
        @Config.Comment(value={"Whether the Blast Furnace block is added to the game."})
        @Config.RequiresMcRestart
        public boolean blastFurnace = true;
        @Config.Name(value="Fletching Table")
        @Config.Comment(value={"Whether the Fletching Table block is added to the game.", "This block is decorative only."})
        @Config.RequiresMcRestart
        public boolean fletchingTable = true;
        @Config.Name(value="Smithing Table")
        @Config.Comment(value={"Whether the Smithing Table block is added to the game.", "This block is decorative only."})
        @Config.RequiresMcRestart
        public boolean smithingTable = true;
        @Config.Name(value="Grindstone")
        @Config.Comment(value={"Whether the Grindstone block is added to the game."})
        @Config.RequiresMcRestart
        public boolean grindstone = true;
        @Config.Name(value="Bamboo")
        @Config.Comment(value={"Whether the Bamboo plant is added to the game. If false, Pandas are also disabled."})
        @Config.RequiresMcRestart
        public boolean bamboo = true;
        @Config.Name(value="Bamboo spawns in Jungles")
        @Config.Comment(value={"Whether Bamboo can be found in normal Jungle biomes."})
        @Config.RequiresMcRestart
        public boolean bambooSpawnsInJungles = true;
        @Config.Name(value="Add legacy Bamboo Jungle")
        @Config.Comment(value={"Use this if you would like to keep the legacy Bamboo Jungles."})
        @Config.RequiresMcRestart
        public boolean addLegacyBambooJungle = false;
        @Config.Name(value="Use Vanilla Creative Tabs")
        @Config.Comment(value={"Whether this mod will use Vanilla tabs or its own creative tab."})
        @Config.RequiresMcRestart
        public boolean useVanillaTabs = false;
        @Config.Name(value="Composter")
        @Config.Comment(value={"Whether the Composter block is added to the game."})
        @Config.RequiresMcRestart
        public boolean composter = true;
        @Config.Name(value="Panda")
        @Config.Comment(value={"Whether the Panda animal is added to the game."})
        @Config.RequiresMcRestart
        public boolean panda = true;
        @Config.Name(value="Blue Ice")
        @Config.Comment(value={"Whether the Blue Ice block is added to the game."})
        @Config.RequiresMcRestart
        public boolean blueIce = true;
        @Config.Name(value="Bee")
        @Config.Comment(value={"Whether the 1.15 creature and its related content should be added to the game."})
        @Config.RequiresMcRestart
        public boolean bee = true;
        @Config.Name(value="Bee Nest Spawn Percent")
        @Config.Comment(value={"The base chance a bee nest will spawn on a tree."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double beeNestChance = 0.05;
        @Config.Name(value="Bee Nest Biome Whitelist")
        @Config.Comment(value={"The list of biomes that the Bee Nests will spawn in. List the registry name of the biome, followed by a colon and the chance multiplier for that biome. Separate entries with a comma followed by a space. Example: 'minecraft:taiga:2' allows bee nests to spawn in the Taiga biome and the nests spawn twice as often than in the plains biome. You will want to lower the chance multiplier in biomes where there are lots of trees."})
        @Config.RequiresMcRestart
        public String validBiomesForBeeNest = "minecraft:plains:1, minecraft:sunflower_plains:1, minecraft:mutated_forest:0.2";
    }
}

