/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.event;

import net.minecraft.block.Block;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityElderGuardian;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thedarkcolour.futuremc.block.BlockStrippedLog;
import thedarkcolour.futuremc.init.FutureConfig;
import thedarkcolour.futuremc.init.Init;
import thedarkcolour.futuremc.sound.Sounds;

@Mod.EventBusSubscriber
public final class Events {
    @SubscribeEvent
    public static void eatHoneyBottleEvent(PlaySoundAtEntityEvent event) {
        EntityLivingBase e;
        if (event.getEntity() instanceof EntityLivingBase && (e = (EntityLivingBase)event.getEntity()).func_184607_cu().func_77973_b() == Init.HONEY_BOTTLE) {
            event.setSound(Sounds.HONEY_BOTTLE_DRINK);
        }
    }

    @SubscribeEvent
    public static void stripLogEvent(PlayerInteractEvent.RightClickBlock event) {
        IBlockState state;
        Block block;
        ItemTool tool;
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = event.getItemStack();
        if (FutureConfig.general.strippedLogs && stack.func_77973_b() instanceof ItemTool && (tool = (ItemTool)stack.func_77973_b()).getToolClasses(stack).contains("axe") && ((block = (state = world.func_180495_p(pos)).func_177230_c()) == Blocks.field_150364_r || block == Blocks.field_150363_s)) {
            IProperty axis = null;
            IProperty variant = null;
            for (IProperty prop : state.func_177227_a()) {
                if (prop.func_177701_a().equals("axis")) {
                    axis = prop;
                }
                if (!prop.func_177701_a().equals("variant")) continue;
                variant = prop;
            }
            if (axis != null && variant != null && BlockStrippedLog.variants.contains(((BlockPlanks.EnumType)state.func_177229_b(variant)).toString())) {
                player.func_184609_a(event.getHand());
                world.func_184133_a(player, pos, SoundEvents.field_187881_gQ, SoundCategory.BLOCKS, 1.0f, 1.0f);
                world.func_175656_a(pos, Events.getState(state, block).func_177226_a(axis, state.func_177229_b(axis)));
                stack.func_77972_a(1, (EntityLivingBase)player);
            }
        }
    }

    @SubscribeEvent
    public static void onMobDeath(LivingDeathEvent event) {
        Entity entity;
        if (FutureConfig.general.trident && (entity = event.getEntity()) instanceof EntityElderGuardian) {
            entity.func_130014_f_().func_72838_d((Entity)new EntityItem(entity.func_130014_f_(), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack((Item)Init.TRIDENT, 1)));
        }
    }

    @SubscribeEvent
    public static void onEntityJump(LivingEvent.LivingJumpEvent event) {
        int z;
        int y;
        EntityLivingBase entity = event.getEntityLiving();
        int x = MathHelper.func_76128_c((double)entity.field_70165_t);
        BlockPos pos = new BlockPos(x, y = MathHelper.func_76128_c((double)(entity.field_70163_u - (double)0.2f)), z = MathHelper.func_76128_c((double)entity.field_70161_v));
        IBlockState state = entity.field_70170_p.func_180495_p(pos);
        if (state.func_177230_c() == Init.HONEY_BLOCK) {
            entity.field_70181_x *= 0.5;
        }
    }

    public static IBlockState getState(IBlockState state, Block block) {
        String variant = null;
        if (block == Blocks.field_150364_r) {
            variant = ((BlockPlanks.EnumType)state.func_177229_b((IProperty)BlockOldLog.field_176301_b)).func_176610_l();
        }
        if (block == Blocks.field_150363_s) {
            variant = ((BlockPlanks.EnumType)state.func_177229_b((IProperty)BlockNewLog.field_176300_b)).func_176610_l();
        }
        if (variant != null) {
            switch (variant) {
                case "acacia": {
                    return Init.STRIPPED_ACACIA_LOG.func_176223_P();
                }
                case "jungle": {
                    return Init.STRIPPED_JUNGLE_LOG.func_176223_P();
                }
                case "birch": {
                    return Init.STRIPPED_BIRCH_LOG.func_176223_P();
                }
                case "oak": {
                    return Init.STRIPPED_OAK_LOG.func_176223_P();
                }
                case "spruce": {
                    return Init.STRIPPED_SPRUCE_LOG.func_176223_P();
                }
                case "dark_oak": {
                    return Init.STRIPPED_DARK_OAK_LOG.func_176223_P();
                }
            }
        }
        throw new IllegalStateException("Invalid log");
    }
}

