/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.entity.trident;

import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.dispenser.IPosition;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import thedarkcolour.futuremc.FutureMC;
import thedarkcolour.futuremc.enchantment.EnchantHelper;
import thedarkcolour.futuremc.enchantment.Enchantments;
import thedarkcolour.futuremc.entity.trident.EntityModArrow;
import thedarkcolour.futuremc.sound.Sounds;

public class EntityTrident
extends EntityModArrow {
    private static final Predicate<Entity> ARROW_TARGETS = entity -> EntitySelectors.field_180132_d.test(entity) && EntitySelectors.field_94557_a.test(entity) && entity.func_70067_L();
    private ItemStack thrownStack;
    private boolean hasChanneled;
    private int ticksInGround = 0;
    private boolean isReturning;

    public EntityTrident(World world) {
        super(world);
    }

    public EntityTrident(World world, IPosition pos, ItemStack stack) {
        super(world, pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c());
        this.thrownStack = stack;
        this.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
    }

    public EntityTrident(World world, EntityLivingBase shooter, ItemStack stack) {
        super(world, shooter);
        this.thrownStack = stack;
    }

    @Override
    protected ItemStack func_184550_j() {
        return this.thrownStack.func_77946_l();
    }

    @Override
    protected Entity func_184551_a(Vec3d start, Vec3d end) {
        if (this.field_70170_p.field_72995_K) {
            return null;
        }
        Entity entity = null;
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0), ARROW_TARGETS::test);
        double d0 = 0.0;
        for (Entity entity1 : list) {
            double d1;
            AxisAlignedBB axisalignedbb;
            RayTraceResult raytraceresult;
            if (entity1 == this.field_70250_c || (raytraceresult = (axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)0.3f)).func_72327_a(start, end)) == null || !((d1 = start.func_72436_e(raytraceresult.field_72307_f)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74782_a("ItemTrident", (NBTBase)this.thrownStack.func_77955_b(new NBTTagCompound()));
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("ItemTrident")) {
            this.thrownStack = EntityTrident.read(compound.func_74775_l("ItemTrident"));
        }
    }

    @Override
    protected void func_184549_a(RayTraceResult result) {
        Entity entity = result.field_72308_g;
        if (entity != null) {
            DamageSource source = !(this.field_70250_c instanceof EntityPlayer) ? EntityTrident.causeTridentDamage((Entity)this, (Entity)this) : EntityTrident.causeTridentDamage((Entity)this, this.field_70250_c);
            if (entity.func_70097_a(source, this.getDamageForTrident(entity))) {
                if (entity instanceof EntityLivingBase) {
                    Map enchants;
                    EntityLivingBase entityLivingBase = (EntityLivingBase)entity;
                    if (this.field_70250_c instanceof EntityLivingBase) {
                        EnchantmentHelper.func_151384_a((EntityLivingBase)entityLivingBase, (Entity)this.field_70250_c);
                        EnchantmentHelper.func_151385_b((EntityLivingBase)entityLivingBase, (Entity)this.field_70250_c);
                    }
                    this.func_184548_a(entityLivingBase);
                    if (this.field_70250_c != null && entityLivingBase != this.field_70250_c && entityLivingBase instanceof EntityPlayer && this.field_70250_c instanceof EntityPlayer) {
                        ((EntityPlayerMP)this.field_70250_c).field_71135_a.func_147359_a((Packet)new SPacketChangeGameState(6, 0.0f));
                    }
                    this.func_184185_a(Sounds.TRIDENT_PIERCE, 1.0f, 1.0f);
                    this.field_70159_w *= (double)-0.01f;
                    this.field_70181_x *= (double)-0.1f;
                    this.field_70179_y *= (double)-0.01f;
                    this.field_70177_z += 180.0f;
                    this.field_70126_B += 180.0f;
                    if (!this.hasChanneled && this.thrownStack != null && !this.thrownStack.func_190926_b() && !(enchants = EnchantmentHelper.func_82781_a((ItemStack)this.thrownStack)).isEmpty() && enchants.get(Enchantments.CONDUCTIVIDAD) != null && this.field_70170_p.func_72911_I()) {
                        this.field_70250_c.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70250_c.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, false));
                        this.func_184185_a(Sounds.TRIDENT_CONDUCTIVIDAD, 5.0f, 1.0f);
                        this.hasChanneled = true;
                    }
                }
            } else if (!this.field_70170_p.field_72995_K && this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y < (double)0.001f) {
                if (this.field_70251_a == EntityArrow.PickupStatus.ALLOWED) {
                    this.func_70099_a(this.func_184550_j(), 0.1f);
                }
                this.func_70106_y();
            }
        } else {
            this.field_70159_w = (float)(result.field_72307_f.field_72450_a - this.field_70165_t);
            this.field_70181_x = (float)(result.field_72307_f.field_72448_b - this.field_70163_u);
            this.field_70179_y = (float)(result.field_72307_f.field_72449_c - this.field_70161_v);
            float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
            this.field_70165_t -= this.field_70159_w / (double)f2 * (double)0.05f;
            this.field_70163_u -= this.field_70181_x / (double)f2 * (double)0.05f;
            this.field_70161_v -= this.field_70179_y / (double)f2 * (double)0.05f;
            this.field_70254_i = true;
            this.field_70249_b = 7;
            this.func_184185_a(Sounds.TRIDENT_IMPACT, 1.0f, 1.0f);
            if (!this.hasChanneled && EnchantHelper.hasChanneling(this.thrownStack)) {
                EntityTrident living = this.field_70250_c == null ? this : this.field_70250_c;
                ((Entity)living).field_70170_p.func_72942_c((Entity)new EntityLightningBolt(((Entity)living).field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, false));
                this.func_184185_a(Sounds.TRIDENT_CONDUCTIVIDAD, 5.0f, 1.0f);
                this.hasChanneled = true;
            }
        }
    }

    @Override
    public void func_70071_h_() {
        int loyalty;
        if (this.field_70254_i) {
            ++this.ticksInGround;
        }
        if (this.field_70250_c instanceof EntityPlayer && 0 < (loyalty = EnchantHelper.getLoyalty(this.thrownStack)) && loyalty < 4 && !((EntityPlayer)this.field_70250_c).func_175149_v() && !this.field_70250_c.field_70128_L && this.ticksInGround > 100 - loyalty * 20) {
            this.field_70145_X = true;
            if (!this.isReturning) {
                this.func_184185_a(Sounds.TRIDENT_LOYALTY, 1.0f, 1.0f);
                this.isReturning = true;
            }
            if (this.ticksInGround >= 100 - loyalty * 20) {
                double d0 = 0.02 * (double)loyalty;
                Vec3d vec3d = new Vec3d(this.field_70250_c.field_70165_t - this.field_70165_t, this.field_70250_c.field_70163_u + (double)this.field_70250_c.func_70047_e() - this.field_70163_u, this.field_70250_c.field_70161_v - this.field_70161_v);
                this.field_70159_w += vec3d.field_72450_a * d0 - this.field_70159_w * 0.05;
                this.field_70181_x += vec3d.field_72448_b * d0 - this.field_70181_x * 0.05;
                this.field_70179_y += vec3d.field_72449_c * d0 - this.field_70179_y * 0.05;
                this.func_70091_d(MoverType.SELF, this.field_70159_w * 0.05, this.field_70181_x * 0.05, this.field_70179_y * 0.05);
            }
        }
        if (this.field_70170_p.func_72890_a((Entity)this, 1.5) == this.field_70250_c && this.isReturning) {
            if (this.field_70251_a == EntityArrow.PickupStatus.ALLOWED) {
                this.dropTridentStack();
            }
            this.func_70106_y();
        }
        super.func_70071_h_();
    }

    @Override
    public boolean func_70241_g() {
        return false;
    }

    public boolean func_70027_ad() {
        return false;
    }

    public void func_70015_d(int seconds) {
    }

    private static ItemStack read(NBTTagCompound compound) {
        try {
            return new ItemStack(compound);
        }
        catch (RuntimeException runtimeexception) {
            FutureMC.logger.debug("Tried to load invalid item: {}", (Object)compound, (Object)runtimeexception);
            return ItemStack.field_190927_a;
        }
    }

    private float getDamageForTrident(Entity target) {
        float level = EnchantHelper.getImpaling(this.thrownStack);
        float damage = 8.0f;
        if (level > 0.0f && target.func_70026_G()) {
            damage = (float)((double)damage + (double)level * 1.25);
        }
        return damage;
    }

    private void dropTridentStack() {
        if (this.thrownStack != null && !this.thrownStack.func_190926_b()) {
            EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)0.1f, this.field_70161_v, this.thrownStack);
            entityitem.func_174868_q();
            if (this.captureDrops) {
                this.capturedDrops.add(entityitem);
            } else {
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
        }
    }

    private static DamageSource causeTridentDamage(Entity trident, Entity indirectEntityIn) {
        return new EntityDamageSourceIndirect("trident", trident, indirectEntityIn).func_76349_b();
    }

    @Override
    protected float getWaterDrag() {
        return 0.99f;
    }
}

