/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.entity.drowned;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIMoveToBlock;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIZombieAttack;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import thedarkcolour.futuremc.entity.trident.EntityTrident;
import thedarkcolour.futuremc.init.Init;
import thedarkcolour.futuremc.sound.Sounds;

public class EntityDrowned
extends EntityZombie
implements IRangedAttackMob {
    private boolean field_204718_bx;
    private PathNavigateSwimmer waterNavigator;
    private PathNavigateGround groundNavigator;

    public EntityDrowned(World worldIn) {
        super(worldIn);
        this.field_70138_W = 1.0f;
        this.field_70765_h = new MoveHelper(this);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.waterNavigator = new PathNavigateSwimmer((EntityLiving)this, worldIn);
        this.groundNavigator = new PathNavigateGround((EntityLiving)this, worldIn);
    }

    protected void func_175456_n() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIGoToWater(this, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AITridentAttack(this, 1.0, 40, 10.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIAttack(this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIGoToBeach(this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new AISwimUp(this, 1.0, this.field_70170_p.func_181545_F()));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityDrowned.class}));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 10, true, false, (Predicate)new AttackTargetPredicate(this)));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, false));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityIronGolem.class, true));
    }

    public boolean shouldAttack(EntityLivingBase p_204714_1_) {
        if (p_204714_1_ != null) {
            return !this.field_70170_p.func_72935_r() || p_204714_1_.func_70090_H();
        }
        return false;
    }

    private boolean func_204715_dF() {
        if (this.field_204718_bx) {
            return true;
        }
        EntityLivingBase entitylivingbase = this.func_70638_az();
        return entitylivingbase != null && entitylivingbase.func_70090_H();
    }

    public void func_204713_s(boolean p_204713_1_) {
        this.field_204718_bx = p_204713_1_;
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        EntityTrident entitytrident = new EntityTrident(this.field_70170_p, (EntityLivingBase)this, new ItemStack((Item)Init.TRIDENT));
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - entitytrident.field_70163_u;
        double d2 = target.field_70161_v - this.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        entitytrident.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4);
        this.func_184185_a(Sounds.TRIDENT_THROW, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)entitytrident);
    }

    public void func_184724_a(boolean swingingArms) {
    }

    protected boolean isCloseToPathTarget() {
        Path path = this.func_70661_as().func_75505_d();
        if (path != null) {
            PathPoint pathpoint = path.func_189964_i();
            double d0 = this.func_70092_e(pathpoint.field_75839_a, pathpoint.field_75837_b, pathpoint.field_75838_c);
            return d0 < 4.0;
        }
        return false;
    }

    static class MoveHelper
    extends EntityMoveHelper {
        private final EntityDrowned drowned;

        MoveHelper(EntityDrowned entity) {
            super((EntityLiving)entity);
            this.drowned = entity;
        }

        public void func_75641_c() {
            EntityLivingBase entitylivingbase = this.drowned.func_70638_az();
            if (this.drowned.func_204715_dF() && this.drowned.func_70090_H()) {
                if (entitylivingbase != null && entitylivingbase.field_70163_u > this.drowned.field_70163_u || this.drowned.field_204718_bx) {
                    this.drowned.field_70181_x += 0.002;
                }
                if (this.field_188491_h != EntityMoveHelper.Action.MOVE_TO || this.drowned.func_70661_as().func_75500_f()) {
                    this.drowned.func_70659_e(0.0f);
                    return;
                }
                double d0 = this.field_75646_b - this.drowned.field_70165_t;
                double d1 = this.field_75647_c - this.drowned.field_70163_u;
                double d2 = this.field_75644_d - this.drowned.field_70161_v;
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.drowned.field_70761_aq = this.drowned.field_70177_z = this.func_75639_a(this.drowned.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.drowned.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                this.drowned.func_70659_e(this.drowned.func_70689_ay() + (f1 - this.drowned.func_70689_ay()) * 0.125f);
                this.drowned.field_70181_x += (double)this.drowned.func_70689_ay() * (d1 /= d3) * 0.1;
                this.drowned.field_70159_w += (double)this.drowned.func_70689_ay() * d0 * 0.005;
                this.drowned.field_70179_y += (double)this.drowned.func_70689_ay() * d2 * 0.005;
            } else {
                if (!this.drowned.field_70122_E) {
                    this.drowned.field_70181_x -= 0.008;
                }
                super.func_75641_c();
            }
        }
    }

    public static class AttackTargetPredicate
    implements Predicate<EntityPlayer> {
        private final EntityDrowned entity;

        public AttackTargetPredicate(EntityDrowned drowned) {
            this.entity = drowned;
        }

        public boolean apply(EntityPlayer playerIn) {
            return this.entity.shouldAttack((EntityLivingBase)playerIn);
        }
    }

    static class AIGoToBeach
    extends EntityAIMoveToBlock {
        private final EntityDrowned drowned;

        AIGoToBeach(EntityDrowned drowned, double p_i48911_2_) {
            super((EntityCreature)drowned, p_i48911_2_, 8);
            this.drowned = drowned;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.drowned.field_70170_p.func_72935_r() && this.drowned.func_70090_H() && this.drowned.field_70163_u >= (double)(this.drowned.field_70170_p.func_181545_F() - 3);
        }

        public boolean func_75253_b() {
            return super.func_75253_b();
        }

        public void func_75249_e() {
            this.drowned.func_204713_s(false);
            this.drowned.field_70699_by = (PathNavigate)this.drowned.groundNavigator;
            super.func_75249_e();
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        protected boolean func_179488_a(World worldIn, BlockPos pos) {
            BlockPos blockpos = pos.func_177984_a();
            return worldIn.func_175623_d(blockpos) && worldIn.func_175623_d(blockpos.func_177984_a()) && worldIn.func_180495_p(pos).func_185896_q();
        }
    }

    public static class AIAttack
    extends EntityAIZombieAttack {
        private final EntityDrowned drowned;

        public AIAttack(EntityDrowned drowned, double speed, boolean longMemory) {
            super((EntityZombie)drowned, speed, longMemory);
            this.drowned = drowned;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && this.drowned.shouldAttack(this.drowned.func_70638_az());
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && this.drowned.shouldAttack(this.drowned.func_70638_az());
        }
    }

    public static class AITridentAttack
    extends EntityAIAttackRanged {
        private final EntityDrowned attacker;

        public AITridentAttack(EntityDrowned attacker, double speed, int maxAttackTime, float maxAttackDistanceIn) {
            super((IRangedAttackMob)attacker, speed, maxAttackTime, maxAttackDistanceIn);
            this.attacker = attacker;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && this.attacker.func_184614_ca().func_77973_b() == Init.TRIDENT;
        }

        public void func_75249_e() {
            super.func_75249_e();
            this.attacker.func_184724_a(true);
        }

        public void func_75251_c() {
            super.func_75251_c();
            this.attacker.func_184724_a(false);
        }
    }

    public static class AISwimUp
    extends EntityAIBase {
        private final EntityDrowned drowned;
        private final double speed;
        private final int targetY;
        private boolean obstructed;

        public AISwimUp(EntityDrowned drowned, double p_i48908_2_, int p_i48908_4_) {
            this.drowned = drowned;
            this.speed = p_i48908_2_;
            this.targetY = p_i48908_4_;
        }

        public boolean func_75250_a() {
            return !this.drowned.field_70170_p.func_72935_r() && this.drowned.func_70090_H() && this.drowned.field_70163_u < (double)(this.targetY - 2);
        }

        public boolean func_75253_b() {
            return this.func_75250_a() && !this.obstructed;
        }

        public void func_75246_d() {
            if (this.drowned.field_70163_u < (double)(this.targetY - 1) && (this.drowned.func_70661_as().func_75500_f() || this.drowned.isCloseToPathTarget())) {
                Vec3d vec3d = RandomPositionGenerator.func_75464_a((EntityCreature)this.drowned, (int)4, (int)8, (Vec3d)new Vec3d(this.drowned.field_70165_t, (double)(this.targetY - 1), this.drowned.field_70161_v));
                if (vec3d == null) {
                    this.obstructed = true;
                    return;
                }
                this.drowned.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, this.speed);
            }
        }

        public void func_75249_e() {
            this.drowned.func_204713_s(true);
            this.obstructed = false;
        }

        public void func_75251_c() {
            this.drowned.func_204713_s(false);
        }
    }

    public static class AIGoToWater
    extends EntityAIBase {
        private final EntityDrowned entityIn;
        private double x;
        private double y;
        private double z;
        private final double speed;
        private final World world;

        public AIGoToWater(EntityDrowned entityIn, double speed) {
            this.entityIn = entityIn;
            this.speed = speed;
            this.world = entityIn.field_70170_p;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            if (!this.world.func_72935_r()) {
                return false;
            }
            if (this.entityIn.func_70090_H()) {
                return false;
            }
            Vec3d vec3d = this.getWaterPos();
            if (vec3d == null) {
                return false;
            }
            this.x = vec3d.field_72450_a;
            this.y = vec3d.field_72448_b;
            this.z = vec3d.field_72449_c;
            return true;
        }

        public boolean func_75253_b() {
            return !this.entityIn.func_70661_as().func_75500_f();
        }

        public void func_75249_e() {
            this.entityIn.func_70661_as().func_75492_a(this.x, this.y, this.z, this.speed);
        }

        private Vec3d getWaterPos() {
            Random random = this.entityIn.func_70681_au();
            BlockPos pos = new BlockPos(this.entityIn.field_70165_t, this.entityIn.func_70046_E().field_72338_b, this.entityIn.field_70161_v);
            for (int i = 0; i < 10; ++i) {
                BlockPos pos1 = pos.func_177982_a(random.nextInt(20) - 10, 2 - random.nextInt(8), random.nextInt(20) - 10);
                if (this.world.func_180495_p(pos1).func_177230_c() != Blocks.field_150355_j) continue;
                return new Vec3d((double)pos1.func_177958_n(), (double)pos1.func_177956_o(), (double)pos1.func_177952_p());
            }
            return null;
        }
    }
}

