/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.container;

import com.google.common.base.Objects;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import thedarkcolour.core.gui.Container;
import thedarkcolour.futuremc.client.gui.GuiStonecutter;
import thedarkcolour.futuremc.init.Init;
import thedarkcolour.futuremc.recipe.StonecutterRecipe;
import thedarkcolour.futuremc.recipe.StonecutterRecipes;
import thedarkcolour.futuremc.sound.Sounds;

public class ContainerStonecutter
extends Container {
    private final World world;
    private final BlockPos pos;
    private final InventoryPlayer playerInv;
    private StonecutterRecipe currentRecipe;
    private long lastOnTake = 0L;
    private int selectedIndex;
    private Runnable inventoryUpdateListener = () -> {};
    public ItemStackHandler handler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            if (slot == 0) {
                ContainerStonecutter.this.handleCrafting();
            }
            ContainerStonecutter.this.inventoryUpdateListener.run();
        }
    };

    public ContainerStonecutter(InventoryPlayer playerInv, World world, BlockPos posIn) {
        this.playerInv = playerInv;
        this.world = world;
        this.pos = posIn;
        this.addOwnSlots();
        this.addPlayerSlots();
    }

    private void addOwnSlots() {
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.handler, 0, 20, 33){

            public void func_75218_e() {
                if (this.func_75211_c().func_190926_b()) {
                    ContainerStonecutter.this.handler.setStackInSlot(1, ItemStack.field_190927_a);
                }
            }
        });
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.handler, 1, 143, 33){

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }

            public ItemStack func_190901_a(EntityPlayer playerIn, ItemStack stack) {
                ContainerStonecutter.this.handler.getStackInSlot(0).func_190918_g(1);
                if (!ContainerStonecutter.this.handler.getStackInSlot(0).func_190926_b()) {
                    ContainerStonecutter.this.updateRecipeResultSlot();
                } else {
                    ContainerStonecutter.this.currentRecipe = null;
                    ContainerStonecutter.this.selectedIndex = -1;
                }
                stack.func_77973_b().func_77622_d(stack, playerIn.field_70170_p, playerIn);
                long l = ContainerStonecutter.this.world.func_82737_E();
                if (ContainerStonecutter.this.lastOnTake != l) {
                    ContainerStonecutter.this.world.func_184133_a(null, ContainerStonecutter.this.pos, Sounds.STONECUTTER_CARVE, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    ContainerStonecutter.this.lastOnTake = l;
                }
                return super.func_190901_a(playerIn, stack);
            }
        });
    }

    private void addPlayerSlots() {
        int row;
        for (row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = col * 18 + 8;
                int y = row * 18 + 84;
                this.func_75146_a(new Slot((IInventory)this.playerInv, col + row * 9 + 9, x, y));
            }
        }
        for (row = 0; row < 9; ++row) {
            int x = 9 + row * 18 - 1;
            this.func_75146_a(new Slot((IInventory)this.playerInv, row, x, 142));
        }
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public StonecutterRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    public int getRecipeListSize() {
        return this.currentRecipe.getTotalOutputs();
    }

    public boolean hasRecipe() {
        return this.currentRecipe != null;
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        if (this.world.func_180495_p(this.pos).func_177230_c() != Init.STONECUTTER) {
            return false;
        }
        return playerIn.func_70092_e((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_75140_a(EntityPlayer playerIn, int id) {
        if (id >= 0 && id < this.currentRecipe.getTotalOutputs()) {
            this.selectedIndex = id;
            this.updateRecipeResultSlot();
            return true;
        }
        return false;
    }

    private void handleCrafting() {
        if (StonecutterRecipes.getRecipe(this.handler.getStackInSlot(0)).isPresent()) {
            StonecutterRecipe recipe = StonecutterRecipes.getRecipe(this.handler.getStackInSlot(0)).get();
            if (!Objects.equal((Object)this.currentRecipe, (Object)recipe)) {
                this.currentRecipe = recipe;
                this.selectedIndex = -1;
            }
        } else {
            this.currentRecipe = null;
        }
    }

    private void updateRecipeResultSlot() {
        if (this.currentRecipe != null) {
            this.handler.setStackInSlot(1, this.currentRecipe.getOutput(this.selectedIndex));
        } else {
            this.handler.setStackInSlot(1, ItemStack.field_190927_a);
        }
        this.func_75142_b();
    }

    public void setInventoryUpdateListener(Runnable listenerIn) {
        this.inventoryUpdateListener = listenerIn;
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return false;
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index == 1) {
                itemstack1.func_77973_b().func_77622_d(itemstack1, playerIn.field_70170_p, playerIn);
                if (!this.func_75135_a(itemstack1, 2, 38, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index == 0 ? !this.func_75135_a(itemstack1, 2, 38, false) : (StonecutterRecipes.getRecipe(itemstack1).isPresent() ? !this.func_75135_a(itemstack1, 0, 1, false) : (index >= 2 && index < 29 ? !this.func_75135_a(itemstack1, 29, 38, false) : index >= 29 && index < 38 && !this.func_75135_a(itemstack1, 2, 29, false)))) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            }
            slot.func_75218_e();
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemstack1);
            this.func_75142_b();
        }
        return itemstack;
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        ItemStack stack = this.handler.getStackInSlot(0);
        if (!playerIn.func_70089_S() || playerIn instanceof EntityPlayerMP && ((EntityPlayerMP)playerIn).func_193105_t()) {
            if (!stack.func_190926_b()) {
                playerIn.func_70099_a(stack, 0.5f);
            }
        } else if (!stack.func_190926_b()) {
            this.playerInv.func_191975_a(this.world, stack);
        }
    }

    public InventoryPlayer getPlayerInv() {
        return this.playerInv;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGuiContainer() {
        return new GuiStonecutter(new ContainerStonecutter(this.playerInv, this.world, this.pos));
    }

    public void setCurrentRecipe(StonecutterRecipe recipe) {
        this.currentRecipe = recipe;
    }
}

