/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.container;

import javax.annotation.Nonnull;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemBanner;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import thedarkcolour.core.gui.Container;
import thedarkcolour.futuremc.client.gui.GuiLoom;
import thedarkcolour.futuremc.compat.oredict.OreDict;
import thedarkcolour.futuremc.init.Init;
import thedarkcolour.futuremc.item.ItemBannerPattern;

public class ContainerLoom
extends Container {
    private InventoryPlayer playerInv;
    private World world;
    private BlockPos pos;
    private int selectedIndex;
    private Runnable inventoryUpdateListener = () -> {};
    private ItemStackHandler handler = new ItemStackHandler(4){

        protected void onContentsChanged(int slot) {
            if (slot != 3) {
                ContainerLoom.this.handleCrafting();
            }
            ContainerLoom.this.inventoryUpdateListener.run();
        }
    };

    public ContainerLoom(InventoryPlayer playerInv, World worldIn, BlockPos pos) {
        this.playerInv = playerInv;
        this.world = worldIn;
        this.pos = pos;
        this.addOwnSlots();
        this.addPlayerSlots();
    }

    private void addOwnSlots() {
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.handler, 0, 13, 26){

            public boolean func_75214_a(@Nonnull ItemStack stack) {
                return stack.func_77973_b() instanceof ItemBanner;
            }
        });
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.handler, 1, 33, 26){

            public boolean func_75214_a(@Nonnull ItemStack stack) {
                return OreDict.getOreName(stack).startsWith("dye");
            }
        });
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.handler, 2, 23, 45){

            public boolean func_75214_a(@Nonnull ItemStack stack) {
                return stack.func_77973_b() instanceof ItemBannerPattern;
            }
        });
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.handler, 3, 143, 57){

            public boolean func_75214_a(@Nonnull ItemStack stack) {
                return false;
            }

            public ItemStack func_190901_a(EntityPlayer thePlayer, ItemStack stack) {
                ContainerLoom.this.getColor().func_190918_g(1);
                ContainerLoom.this.getBanner().func_190918_g(1);
                return stack;
            }
        });
    }

    private void addPlayerSlots() {
        int row;
        for (row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = col * 18 + 8;
                int y = row * 18 + 84;
                this.func_75146_a(new Slot((IInventory)this.playerInv, col + row * 9 + 9, x, y));
            }
        }
        for (row = 0; row < 9; ++row) {
            int x = 9 + row * 18 - 1;
            int y = 142;
            this.func_75146_a(new Slot((IInventory)this.playerInv, row, x, y));
        }
    }

    public void setColor(ItemStack stack) {
        this.handler.setStackInSlot(1, stack);
    }

    public void setPattern(ItemStack stack) {
        this.handler.setStackInSlot(2, stack);
    }

    public void setOutput(ItemStack stack) {
        this.handler.setStackInSlot(3, stack);
    }

    public ItemStack getBanner() {
        return this.handler.getStackInSlot(0);
    }

    public ItemStack getColor() {
        return this.handler.getStackInSlot(1);
    }

    public ItemStack getPattern() {
        return this.handler.getStackInSlot(2);
    }

    public ItemStack getOutput() {
        return this.handler.getStackInSlot(3);
    }

    public Slot getLoomSlot(int index) {
        return this.func_75139_a(index);
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        if (this.world.func_180495_p(this.pos).func_177230_c() != Init.LOOM) {
            return false;
        }
        return playerIn.func_70092_e((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_75140_a(EntityPlayer playerIn, int id) {
        if (id > 0 && id <= BannerPattern.values().length) {
            this.selectedIndex = id;
            this.updateRecipeResultSlot();
            return true;
        }
        return false;
    }

    private void handleCrafting() {
        ItemStack banner = this.getBanner();
        ItemStack pattern = this.getPattern();
        if (this.getOutput().func_190926_b() || !banner.func_190926_b() && !this.getColor().func_190926_b() && this.selectedIndex > 0 && (this.selectedIndex < BannerPattern.values().length - 5 || !pattern.func_190926_b())) {
            if (!pattern.func_190926_b() && pattern.func_77973_b() instanceof ItemBannerPattern) {
                boolean flag;
                NBTTagCompound tag = banner.func_190925_c("BlockEntityTag");
                boolean bl = flag = tag.func_150297_b("Patterns", 9) && !banner.func_190926_b() && tag.func_150295_c("Patterns", 10).func_74745_c() >= 6;
                this.selectedIndex = flag ? 0 : ItemBannerPattern.getBannerPattern(pattern).ordinal();
            }
        } else {
            this.setOutput(ItemStack.field_190927_a);
            this.selectedIndex = 0;
        }
        this.updateRecipeResultSlot();
        this.func_75142_b();
    }

    private void updateRecipeResultSlot() {
        if (this.selectedIndex > 0) {
            ItemStack banner = this.getBanner();
            ItemStack color = this.getColor();
            ItemStack stack = ItemStack.field_190927_a;
            if (!banner.func_190926_b() && !color.func_190926_b()) {
                NBTTagList list;
                stack = banner.func_77946_l();
                stack.func_190920_e(1);
                NBTTagCompound nbt = stack.func_190925_c("BlockEntityTag");
                if (nbt.func_150297_b("Patterns", 9)) {
                    list = nbt.func_150295_c("Pattern", 10);
                } else {
                    list = new NBTTagList();
                    nbt.func_74782_a("Patterns", (NBTBase)list);
                }
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a("Pattern", BannerPattern.values()[this.selectedIndex].func_190993_b());
                tag.func_74768_a("Color", ContainerLoom.getColorForStack(color).func_176767_b());
                list.func_74742_a((NBTBase)tag);
            }
            if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)this.getOutput())) {
                this.setOutput(stack);
            }
        } else {
            this.setOutput(ItemStack.field_190927_a);
        }
    }

    public void setInventoryUpdateListener(Runnable listenerIn) {
        this.inventoryUpdateListener = listenerIn;
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index == 3) {
                if (!this.func_75135_a(itemstack1, 4, 40, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index != 1 && index != 0 && index != 2 ? (itemstack1.func_77973_b() instanceof ItemBanner ? !this.func_75135_a(itemstack1, 0, 1, false) : (OreDict.getOreName(itemstack1).startsWith("dye") ? !this.func_75135_a(itemstack1, 1, 2, false) : (itemstack1.func_77973_b() instanceof ItemBannerPattern ? !this.func_75135_a(itemstack1, 2, 3, false) : (index >= 4 && index < 31 ? !this.func_75135_a(itemstack1, 31, 40, false) : index >= 31 && index < 40 && !this.func_75135_a(itemstack1, 4, 31, false))))) : !this.func_75135_a(itemstack1, 4, 40, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemstack1);
        }
        return itemstack;
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        if (!playerIn.func_70089_S() || playerIn instanceof EntityPlayerMP && ((EntityPlayerMP)playerIn).func_193105_t()) {
            for (int i = 0; i < 3; ++i) {
                ItemStack stack = this.handler.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                playerIn.func_70099_a(stack, 0.5f);
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                if (this.handler.getStackInSlot(i).func_190926_b()) continue;
                this.playerInv.func_191975_a(this.world, this.handler.getStackInSlot(i));
            }
        }
    }

    public InventoryPlayer getPlayerInv() {
        return this.playerInv;
    }

    public static EnumDyeColor getColorForStack(ItemStack stack) {
        String s = OreDict.getOreName(stack);
        if (s.startsWith("dye")) {
            switch (s = s.replaceFirst("dye", "")) {
                case "Black": {
                    return EnumDyeColor.BLACK;
                }
                case "Red": {
                    return EnumDyeColor.RED;
                }
                case "Green": {
                    return EnumDyeColor.GREEN;
                }
                case "Purple": {
                    return EnumDyeColor.PURPLE;
                }
                case "Cyan": {
                    return EnumDyeColor.CYAN;
                }
                case "LightGray": {
                    return EnumDyeColor.SILVER;
                }
                case "Gray": {
                    return EnumDyeColor.GRAY;
                }
                case "Pink": {
                    return EnumDyeColor.PINK;
                }
                case "Lime": {
                    return EnumDyeColor.LIME;
                }
                case "Yellow": {
                    return EnumDyeColor.YELLOW;
                }
                case "LightBlue": {
                    return EnumDyeColor.LIGHT_BLUE;
                }
                case "Magenta": {
                    return EnumDyeColor.MAGENTA;
                }
                case "Orange": {
                    return EnumDyeColor.ORANGE;
                }
            }
            return EnumDyeColor.WHITE;
        }
        return EnumDyeColor.WHITE;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGuiContainer() {
        return new GuiLoom(new ContainerLoom(this.playerInv, this.world, this.pos));
    }
}

