/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.container;

import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import thedarkcolour.futuremc.init.Init;
import thedarkcolour.futuremc.sound.Sounds;
import thedarkcolour.futuremc.world.IWorldPosCallable;

public class ContainerGrindstoneNew
extends Container {
    private final ItemStackHandler handler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            if (slot < 2) {
                ContainerGrindstoneNew.this.handleCrafting();
            }
        }
    };
    private final IWorldPosCallable worldPosCallable;
    private final InventoryPlayer player;

    public ContainerGrindstoneNew(InventoryPlayer playerInv, IWorldPosCallable worldPosCallable) {
        this.worldPosCallable = worldPosCallable;
        this.player = playerInv;
        this.addOwnSlots();
        this.addPlayerSlots(playerInv);
    }

    private void addOwnSlots() {
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.handler, 0, 49, 19){

            public boolean func_75214_a(@Nonnull ItemStack stack) {
                return stack.func_77984_f() || stack.func_77973_b() == Items.field_151134_bR || stack.func_77948_v();
            }
        });
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.handler, 1, 49, 40){

            public boolean func_75214_a(@Nonnull ItemStack stack) {
                return stack.func_77984_f() || stack.func_77973_b() == Items.field_151134_bR || stack.func_77948_v();
            }
        });
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.handler, 2, 129, 34){

            public boolean func_75214_a(@Nonnull ItemStack stack) {
                return false;
            }

            public ItemStack func_190901_a(EntityPlayer thePlayer, ItemStack stack) {
                ContainerGrindstoneNew.this.worldPosCallable.consume((worldIn, pos) -> {
                    if (!worldIn.field_72995_K) {
                        int il;
                        for (int i = this.rewardEXP((World)worldIn); i > 0; i -= il) {
                            il = EntityXPOrb.func_70527_a((int)i);
                            worldIn.func_72838_d((Entity)new EntityXPOrb(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p(), il));
                        }
                        worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), Sounds.GRINDSTONE_USE, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                    }
                });
                ContainerGrindstoneNew.this.handler.setStackInSlot(0, ItemStack.field_190927_a);
                ContainerGrindstoneNew.this.handler.setStackInSlot(1, ItemStack.field_190927_a);
                return stack;
            }

            private int rewardEXP(World worldIn) {
                int xp = 0;
                xp += this.getEXPForItem(ContainerGrindstoneNew.this.handler.getStackInSlot(0));
                if ((xp += this.getEXPForItem(ContainerGrindstoneNew.this.handler.getStackInSlot(1))) > 0) {
                    int exp = (int)Math.ceil((double)xp / 2.0);
                    return exp + worldIn.field_73012_v.nextInt(exp);
                }
                return 0;
            }

            private int getEXPForItem(ItemStack p_216943_1_) {
                int l = 0;
                Map map = EnchantmentHelper.func_82781_a((ItemStack)p_216943_1_);
                for (Map.Entry entry : map.entrySet()) {
                    Enchantment enchantment = (Enchantment)entry.getKey();
                    Integer integer = (Integer)entry.getValue();
                    if (enchantment.func_190936_d()) continue;
                    l += enchantment.func_77321_a(integer.intValue());
                }
                return l;
            }
        });
    }

    public void handleCrafting() {
        boolean flag1;
        ItemStack stack = this.handler.getStackInSlot(0);
        ItemStack stack1 = this.handler.getStackInSlot(1);
        boolean flag = !stack.func_190926_b() || !stack1.func_190926_b();
        boolean bl = flag1 = !stack.func_190926_b() && !stack1.func_190926_b();
        if (!flag) {
            this.handler.setStackInSlot(2, ItemStack.field_190927_a);
        } else {
            int sum;
            ItemStack outItem;
            boolean flag2;
            boolean bl2 = flag2 = !stack.func_190926_b() && stack.func_77973_b() != Items.field_151134_bR && stack.func_77948_v() || !stack1.func_190926_b() && stack1.func_77973_b() != Items.field_151134_bR && !stack1.func_77948_v();
            if (stack.func_190916_E() > 1 || stack1.func_190916_E() > 1 || !flag1 && flag2) {
                this.handler.setStackInSlot(2, ItemStack.field_190927_a);
                this.func_75142_b();
                return;
            }
            int count = 1;
            if (flag1) {
                if (stack.func_77973_b() != stack1.func_77973_b()) {
                    this.handler.setStackInSlot(2, ItemStack.field_190927_a);
                    this.func_75142_b();
                    return;
                }
                outItem = this.combineEnchants(stack, stack1);
                sum = stack.func_77958_k() - stack.func_77952_i() + (stack.func_77958_k() - stack1.func_77952_i());
                if ((sum = (int)((double)sum + Math.floor((double)sum * 0.2))) > stack.func_77958_k()) {
                    sum = stack.func_77958_k();
                }
                if (!outItem.func_77984_f() || !outItem.func_77973_b().isRepairable()) {
                    if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)stack1)) {
                        this.handler.setStackInSlot(2, ItemStack.field_190927_a);
                        this.func_75142_b();
                        return;
                    }
                    count = 2;
                }
                sum = stack.func_77958_k() - sum;
            } else {
                boolean flag3 = !stack.func_190926_b();
                sum = flag3 ? stack.func_77952_i() : stack1.func_77952_i();
                outItem = flag3 ? stack : stack1;
            }
            this.handler.setStackInSlot(2, this.makeOutput(outItem, sum, count));
        }
    }

    private ItemStack combineEnchants(ItemStack stack, ItemStack stack1) {
        ItemStack stack2 = stack.func_77946_l();
        Map map = EnchantmentHelper.func_82781_a((ItemStack)stack1);
        for (Map.Entry entry : map.entrySet()) {
            Enchantment e = (Enchantment)entry.getKey();
            if (e.func_190936_d() && EnchantmentHelper.func_77506_a((Enchantment)e, (ItemStack)stack2) != 0) continue;
            stack2.func_77966_a(e, ((Integer)entry.getValue()).intValue());
        }
        return stack2;
    }

    private ItemStack makeOutput(ItemStack stack, int damage, int count) {
        ItemStack itemstack = stack.func_77946_l();
        itemstack.func_190919_e("ench");
        itemstack.func_190919_e("StoredEnchantments");
        if (damage > 0) {
            itemstack.func_77964_b(damage);
        }
        itemstack.func_190920_e(count);
        Map<Enchantment, Integer> map = EnchantmentHelper.func_82781_a((ItemStack)stack).entrySet().stream().filter(entry -> ((Enchantment)entry.getKey()).func_190936_d()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        EnchantmentHelper.func_82782_a(map, (ItemStack)itemstack);
        itemstack.func_82841_c(0);
        if (itemstack.func_77973_b() == Items.field_151134_bR && map.size() == 0) {
            itemstack = new ItemStack(Items.field_151122_aG);
            if (stack.func_82837_s()) {
                itemstack.func_151001_c(stack.func_82833_r());
            }
        }
        for (int i = 0; i < map.size(); ++i) {
            itemstack.func_82841_c(itemstack.func_82838_A() * 2 + 1);
        }
        return itemstack;
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        this.worldPosCallable.consume((worldIn, pos) -> {
            if (!playerIn.func_70089_S() || playerIn instanceof EntityPlayerMP && ((EntityPlayerMP)playerIn).func_193105_t()) {
                for (int i = 0; i < 2; ++i) {
                    playerIn.func_71019_a(this.removeFromHandler(i), false);
                }
            } else {
                for (int i = 0; i < 2; ++i) {
                    playerIn.field_71071_by.func_191975_a(worldIn, this.removeFromHandler(i));
                }
            }
        });
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return this.isUsableWithinDistance(this.worldPosCallable, playerIn, Init.GRINDSTONE);
    }

    private void addPlayerSlots(InventoryPlayer playerInv) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)playerInv, k, 8 + k * 18, 142));
        }
    }

    private ItemStack removeFromHandler(int slot) {
        ItemStack stack = this.handler.getStackInSlot(slot);
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.handler.setStackInSlot(slot, ItemStack.field_190927_a);
        return stack;
    }

    private boolean isUsableWithinDistance(IWorldPosCallable posCallable, EntityPlayer playerIn, Block block) {
        return posCallable.applyOrElse((world, pos) -> world.func_180495_p(pos).func_177230_c() == block && playerIn.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) <= 64.0, true);
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            ItemStack itemstack2 = this.handler.getStackInSlot(0);
            ItemStack itemstack3 = this.handler.getStackInSlot(1);
            if (index == 2) {
                if (!this.func_75135_a(itemstack1, 3, 39, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index != 0 && index != 1 ? (!itemstack2.func_190926_b() && !itemstack3.func_190926_b() ? (index >= 3 && index < 30 ? !this.func_75135_a(itemstack1, 30, 39, false) : index >= 30 && index < 39 && !this.func_75135_a(itemstack1, 3, 30, false)) : !this.func_75135_a(itemstack1, 0, 2, false)) : !this.func_75135_a(itemstack1, 3, 39, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemstack1);
        }
        return itemstack;
    }

    public InventoryPlayer getPlayerInv() {
        return this.player;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isRecipeInvalid() {
        return (!this.handler.getStackInSlot(0).func_190926_b() || !this.handler.getStackInSlot(1).func_190926_b()) && this.handler.getStackInSlot(2).func_190926_b();
    }
}

