/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.container;

import java.util.Map;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import thedarkcolour.core.gui.Container;
import thedarkcolour.futuremc.client.gui.GuiGrindstone;
import thedarkcolour.futuremc.enchantment.EnchantHelper;
import thedarkcolour.futuremc.init.Init;
import thedarkcolour.futuremc.sound.Sounds;

public class ContainerGrindstone
extends Container {
    protected InventoryPlayer playerInv;
    protected World world;
    protected BlockPos pos;
    public ItemStackHandler input = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            ContainerGrindstone.this.handleCrafting();
        }
    };
    public ItemStackHandler output = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return false;
        }
    };

    public ContainerGrindstone(InventoryPlayer playerInventory, World worldIn, BlockPos posIn) {
        this.playerInv = playerInventory;
        this.world = worldIn;
        this.pos = posIn;
        this.addOwnSlots();
        this.addPlayerSlots();
    }

    private void addOwnSlots() {
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.input, 0, 49, 19));
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.input, 1, 49, 40));
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.output, 0, 129, 34){

            public ItemStack func_190901_a(EntityPlayer thePlayer, ItemStack stack) {
                ContainerGrindstone.this.handleOutput();
                return stack;
            }
        });
    }

    private void addPlayerSlots() {
        int row;
        for (row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = col * 18 + 8;
                int y = row * 18 + 84;
                this.func_75146_a(new Slot((IInventory)this.playerInv, col + row * 9 + 9, x, y));
            }
        }
        for (row = 0; row < 9; ++row) {
            int x = 9 + row * 18 - 1;
            int y = 142;
            this.func_75146_a(new Slot((IInventory)this.playerInv, row, x, y));
        }
    }

    public void clearInput() {
        for (int i = 0; i < this.input.getSlots(); ++i) {
            this.input.getStackInSlot(i).func_190918_g(1);
        }
    }

    public void func_75134_a(EntityPlayer playerIn) {
        block4: {
            super.func_75134_a(playerIn);
            if (this.world.field_72995_K) break block4;
            if (!playerIn.func_70089_S() || playerIn instanceof EntityPlayerMP && ((EntityPlayerMP)playerIn).func_193105_t()) {
                for (int i = 0; i < this.input.getSlots(); ++i) {
                    ItemStack stack = this.input.getStackInSlot(i);
                    if (stack.func_190926_b()) continue;
                    playerIn.func_70099_a(stack, 0.5f);
                }
            } else {
                for (int i = 0; i < this.input.getSlots(); ++i) {
                    if (this.input.getStackInSlot(i).func_190926_b()) continue;
                    this.playerInv.func_191975_a(this.world, this.input.getStackInSlot(i));
                }
            }
        }
    }

    public void handleCrafting() {
        if (!(this.input.getStackInSlot(0).func_185136_b(this.input.getStackInSlot(1)) || this.input.getStackInSlot(0).func_190926_b() || this.input.getStackInSlot(1).func_190926_b())) {
            this.output.setStackInSlot(0, ItemStack.field_190927_a);
        } else if (this.input.getStackInSlot(0).func_185136_b(this.input.getStackInSlot(1)) && this.input.getStackInSlot(0).func_77956_u()) {
            ItemStack stack = this.input.getStackInSlot(0);
            int sum = stack.func_77958_k() - stack.func_77952_i() + (stack.func_77958_k() - this.input.getStackInSlot(1).func_77952_i());
            if ((sum = (int)((double)sum + Math.floor((double)sum * 0.2))) > stack.func_77958_k()) {
                sum = stack.func_77958_k();
            }
            ItemStack outItem = stack.func_77946_l();
            outItem.func_77964_b(stack.func_77958_k() - sum);
            outItem.func_77983_a("Enchantments", (NBTBase)new NBTTagList());
            Map map = EnchantmentHelper.func_82781_a((ItemStack)stack);
            for (Enchantment e : map.keySet()) {
                if (!e.func_190936_d()) continue;
                outItem.func_77966_a(e, 1);
            }
            map = EnchantmentHelper.func_82781_a((ItemStack)this.input.getStackInSlot(1));
            for (Enchantment e : map.keySet()) {
                try {
                    if (!e.func_190936_d()) continue;
                    outItem.func_77966_a(e, 1);
                }
                catch (NullPointerException nullPointerException) {}
            }
            this.output.setStackInSlot(0, outItem);
        } else if (this.input.getStackInSlot(0).func_77948_v() || this.input.getStackInSlot(1).func_77948_v()) {
            int slot = this.input.getStackInSlot(0).func_190926_b() ? 1 : 0;
            ItemStack stack = this.input.getStackInSlot(slot);
            ItemStack outItem = stack.func_77946_l();
            outItem.func_77983_a("ench", (NBTBase)new NBTTagList());
            if (stack.func_77969_a(this.input.getStackInSlot(this.input.getStackInSlot(0).func_190926_b() ? 0 : 1))) {
                int sum = stack.func_77958_k() - stack.func_77952_i() + (stack.func_77958_k() - this.input.getStackInSlot(1).func_77952_i());
                if ((sum = (int)((double)sum + Math.floor((double)sum * 0.2))) > stack.func_77958_k()) {
                    sum = stack.func_77958_k();
                }
                outItem.func_77964_b(stack.func_77958_k() - sum);
            }
            Map map = EnchantmentHelper.func_82781_a((ItemStack)stack);
            for (Enchantment e : map.keySet()) {
                if (!e.func_190936_d()) continue;
                outItem.func_77966_a(e, 1);
            }
            this.output.setStackInSlot(0, outItem);
        } else if (!(this.input.getStackInSlot(0).func_77973_b() != Items.field_151134_bR && this.input.getStackInSlot(1).func_77973_b() != Items.field_151134_bR || this.input.getStackInSlot(0).func_77969_a(this.input.getStackInSlot(1)))) {
            ItemStack outBook;
            boolean isCursed;
            int slot = this.input.getStackInSlot(0).func_190926_b() ? 1 : 0;
            ItemStack book = this.input.getStackInSlot(slot);
            boolean bl = isCursed = EnchantHelper.isCursed(this.input.getStackInSlot(0)) || EnchantHelper.isCursed(this.input.getStackInSlot(1));
            if (isCursed) {
                outBook = book.func_77946_l();
                outBook.func_77983_a("StoredEnchantments", (NBTBase)new NBTTagList());
                Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)book);
                for (Enchantment e : enchantments.keySet()) {
                    if (!e.func_190936_d()) continue;
                    ItemEnchantedBook.func_92115_a((ItemStack)outBook, (EnchantmentData)new EnchantmentData(e, 1));
                }
                enchantments = EnchantmentHelper.func_82781_a((ItemStack)this.input.getStackInSlot(slot == 1 ? 0 : 1));
                for (Enchantment e : enchantments.keySet()) {
                    if (!e.func_190936_d()) continue;
                    ItemEnchantedBook.func_92115_a((ItemStack)outBook, (EnchantmentData)new EnchantmentData(e, 1));
                }
            } else {
                outBook = new ItemStack(Items.field_151122_aG);
            }
            this.output.setStackInSlot(0, outBook);
        } else {
            this.output.setStackInSlot(0, ItemStack.field_190927_a);
        }
        this.func_75142_b();
    }

    public void handleOutput() {
        this.awardEXP(this.input.getStackInSlot(0), this.input.getStackInSlot(1));
        this.world.func_184134_a((double)this.pos.func_177958_n(), (double)this.pos.func_177956_o(), (double)this.pos.func_177952_p(), Sounds.GRINDSTONE_USE, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        this.clearInput();
    }

    public void awardEXP(ItemStack ... input) {
        int exp = 0;
        for (ItemStack stack : input) {
            if (stack.func_190926_b()) continue;
            Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
            for (Enchantment enchantment : enchantments.keySet()) {
                if (enchantment.func_190936_d()) continue;
                exp += ContainerGrindstone.getEnchantmentEXP(enchantment, (Integer)enchantments.get(enchantment));
            }
        }
        if (exp > 0) {
            EntityXPOrb orb = new EntityXPOrb(this.world, (double)this.pos.func_177958_n(), (double)this.pos.func_177956_o(), (double)this.pos.func_177952_p(), 0);
            orb.field_70532_c = 5;
            orb.field_70530_e = exp;
            if (!this.world.field_72995_K) {
                this.world.func_72838_d((Entity)orb);
            }
        }
    }

    public static int getEnchantmentEXP(Enchantment enchantment, int enchantLevel) {
        return enchantment.func_77321_a(enchantLevel);
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemStack1 = slot.func_75211_c();
            itemstack = itemStack1.func_77946_l();
            if (index < 3) {
                if (!this.func_75135_a(itemStack1, 3, this.field_75151_b.size(), true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemStack1, itemstack);
            } else if (!this.func_75135_a(itemStack1, 0, 3, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemStack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            slot.func_190901_a(playerIn, itemStack1);
        }
        return itemstack;
    }

    public InventoryPlayer getPlayerInv() {
        return this.playerInv;
    }

    public boolean isRecipeInvalid() {
        return (!this.input.getStackInSlot(0).func_190926_b() || !this.input.getStackInSlot(1).func_190926_b()) && this.output.getStackInSlot(0).func_190926_b();
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        if (this.world.func_180495_p(this.pos).func_177230_c() != Init.GRINDSTONE) {
            return false;
        }
        return playerIn.func_70092_e((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5) <= 64.0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGuiContainer() {
        return new GuiGrindstone(new ContainerGrindstone(this.playerInv, this.world, this.pos));
    }
}

