/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.compat.jei;

import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import thedarkcolour.futuremc.block.BlockFurnaceAdvanced;
import thedarkcolour.futuremc.client.gui.GuiFurnaceAdvanced;
import thedarkcolour.futuremc.client.gui.GuiStonecutter;
import thedarkcolour.futuremc.compat.jei.blastfurnace.BlastFurnaceRecipeCategory;
import thedarkcolour.futuremc.compat.jei.blastfurnace.BlastFurnaceRecipeWrapper;
import thedarkcolour.futuremc.compat.jei.campfire.CampfireRecipeCategory;
import thedarkcolour.futuremc.compat.jei.campfire.CampfireRecipeWrapper;
import thedarkcolour.futuremc.compat.jei.smoker.SmokerRecipeCategory;
import thedarkcolour.futuremc.compat.jei.smoker.SmokerRecipeWrapper;
import thedarkcolour.futuremc.compat.jei.stonecutter.StonecutterRecipeCategory;
import thedarkcolour.futuremc.compat.jei.stonecutter.StonecutterRecipeWrapper;
import thedarkcolour.futuremc.container.ContainerFurnaceAdvanced;
import thedarkcolour.futuremc.init.FutureConfig;
import thedarkcolour.futuremc.init.Init;
import thedarkcolour.futuremc.tile.TileCampfire;

@JEIPlugin
public class FutureMCJEIPlugin
implements IModPlugin {
    public static final ResourceLocation RECIPE_BACKGROUNDS = new ResourceLocation("minecraftfuture", "textures/gui/recipes.png");

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper helper = registry.getJeiHelpers().getGuiHelper();
        if (FutureConfig.general.smoker) {
            registry.addRecipeCategories(new IRecipeCategory[]{new SmokerRecipeCategory(helper)});
        }
        if (FutureConfig.general.blastFurnace) {
            registry.addRecipeCategories(new IRecipeCategory[]{new BlastFurnaceRecipeCategory(helper)});
        }
        if (FutureConfig.general.campfire) {
            registry.addRecipeCategories(new IRecipeCategory[]{new CampfireRecipeCategory(helper)});
        }
        if (FutureConfig.general.stonecutter) {
            registry.addRecipeCategories(new IRecipeCategory[]{new StonecutterRecipeCategory(helper)});
        }
    }

    public void register(IModRegistry registry) {
        ItemStack stack;
        IRecipeTransferRegistry recipeTransferRegistry = registry.getRecipeTransferRegistry();
        if (FutureConfig.general.smoker) {
            registry.handleRecipes(BlockFurnaceAdvanced.Recipe.class, SmokerRecipeWrapper::new, "container.jei.minecraftfuture.smoker.name");
            registry.addRecipes(BlockFurnaceAdvanced.Recipes.getSmokerRecipes(), "container.jei.minecraftfuture.smoker.name");
            registry.addRecipeClickArea(GuiFurnaceAdvanced.BlastFurnace.class, 78, 32, 28, 23, new String[]{"container.jei.minecraftfuture.blast_furnace.name", "minecraft.fuel"});
            recipeTransferRegistry.addRecipeTransferHandler(ContainerFurnaceAdvanced.class, "container.jei.minecraftfuture.smoker.name", 0, 1, 3, 36);
            stack = new ItemStack((Block)Init.SMOKER);
            registry.addRecipeCatalyst((Object)stack, new String[]{"container.jei.minecraftfuture.smoker.name"});
            registry.addRecipeCatalyst((Object)stack, new String[]{"minecraft.fuel"});
        }
        if (FutureConfig.general.blastFurnace) {
            registry.handleRecipes(BlockFurnaceAdvanced.Recipe.class, BlastFurnaceRecipeWrapper::new, "container.jei.minecraftfuture.blast_furnace.name");
            registry.addRecipes(BlockFurnaceAdvanced.Recipes.getBlastFurnaceRecipes(), "container.jei.minecraftfuture.blast_furnace.name");
            registry.addRecipeClickArea(GuiFurnaceAdvanced.Smoker.class, 78, 32, 28, 23, new String[]{"container.jei.minecraftfuture.smoker.name", "minecraft.fuel"});
            recipeTransferRegistry.addRecipeTransferHandler(ContainerFurnaceAdvanced.class, "container.jei.minecraftfuture.blast_furnace.name", 0, 1, 3, 36);
            stack = new ItemStack((Block)Init.BLAST_FURNACE);
            registry.addRecipeCatalyst((Object)stack, new String[]{"container.jei.minecraftfuture.blast_furnace.name"});
            registry.addRecipeCatalyst((Object)stack, new String[]{"minecraft.fuel"});
        }
        if (FutureConfig.general.campfire) {
            registry.handleRecipes(TileCampfire.Recipe.class, CampfireRecipeWrapper::new, "container.jei.minecraftfuture.campfire.name");
            registry.addRecipes(TileCampfire.Recipes.getAllRecipes(), "container.jei.minecraftfuture.campfire.name");
            registry.addRecipeCatalyst((Object)new ItemStack((Block)Init.CAMPFIRE), new String[]{"container.jei.minecraftfuture.campfire.name"});
        }
        if (FutureConfig.general.stonecutter) {
            registry.handleRecipes(StonecutterRecipeWrapper.class, recipe -> recipe, "container.jei.minecraftfuture.stonecutter.name");
            registry.addRecipes(StonecutterRecipeCategory.getAllRecipeWrappers(), "container.jei.minecraftfuture.stonecutter.name");
            if (FutureConfig.general.stonecutterRecipeButton) {
                registry.addRecipeClickArea(GuiStonecutter.class, 143, 8, 16, 16, new String[]{"container.jei.minecraftfuture.stonecutter.name"});
            }
            registry.addRecipeCatalyst((Object)new ItemStack((Block)Init.STONECUTTER), new String[]{"container.jei.minecraftfuture.stonecutter.name"});
        }
        if (FutureConfig.general.smoker || FutureConfig.general.blastFurnace) {
            recipeTransferRegistry.addRecipeTransferHandler(ContainerFurnaceAdvanced.class, "minecraft.fuel", 1, 1, 3, 36);
        }
    }
}

