/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.minecraft.CraftTweakerMC;
import net.minecraft.item.ItemStack;
import org.apache.logging.log4j.Level;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import thedarkcolour.futuremc.FutureMC;
import thedarkcolour.futuremc.block.BlockComposter;
import thedarkcolour.futuremc.tile.TileComposter;

@ZenRegister
@ZenClass(value="mods.minecraftfuture.Composter")
public final class Composter {
    @ZenMethod
    public static void addValidItem(IIngredient stack, int rarity) {
        if (BlockComposter.ItemsForComposter.getChance(CraftTweakerMC.getItemStack((IIngredient)stack)) == -1) {
            if (!TileComposter.isBoneMeal(CraftTweakerMC.getItemStack((IIngredient)stack))) {
                CraftTweakerAPI.apply((IAction)new Add(stack, rarity));
            } else {
                FutureMC.logger.log(Level.ERROR, "Cannot add bone meal to compostable items!");
            }
        } else {
            FutureMC.logger.log(Level.WARN, "Failed to add duplicate recipe for item " + stack.toCommandString());
        }
    }

    @ZenMethod
    public static void removeValidItem(IIngredient stack) {
        if (BlockComposter.ItemsForComposter.getChance(CraftTweakerMC.getItemStack((IIngredient)stack)) != -1) {
            CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerMC.getItemStack((IIngredient)stack)));
        } else {
            FutureMC.logger.log(Level.WARN, "Cannot remove non-existent item from valid composter items " + stack.toCommandString());
        }
    }

    @ZenMethod
    public static void replaceValidItemChance(IIngredient stack, int newRarity) {
        if (BlockComposter.ItemsForComposter.getChance(CraftTweakerMC.getItemStack((IIngredient)stack)) != -1) {
            CraftTweakerAPI.apply((IAction)new ReplaceItemChance(CraftTweakerMC.getItemStack((IIngredient)stack), newRarity));
        } else {
            FutureMC.logger.log(Level.WARN, "Cannot change chance for invalid item " + stack.toCommandString() + " If you wish to make the item valid, use mods.minecraftfuture.Composter.addValidItem");
        }
    }

    @ZenMethod
    public static void clearValidItems() {
        BlockComposter.ItemsForComposter.clear();
    }

    private static class ReplaceItemChance
    implements IAction {
        private final ItemStack stack;
        private final int newRarity;
        private final int oldRarity;

        private ReplaceItemChance(ItemStack stack, int newRarity) {
            this.newRarity = newRarity;
            this.stack = stack;
            this.oldRarity = BlockComposter.ItemsForComposter.getChance(stack);
        }

        public void apply() {
            BlockComposter.ItemsForComposter.remove(this.stack);
            BlockComposter.ItemsForComposter.add(this.stack, this.newRarity);
        }

        public String describe() {
            return "Changed Composter value for item " + this.stack.func_77973_b().getRegistryName() + " from " + this.oldRarity + " to " + this.newRarity;
        }
    }

    private static class Remove
    implements IAction {
        private final ItemStack stack;

        private Remove(ItemStack stack) {
            this.stack = stack;
        }

        public void apply() {
            BlockComposter.ItemsForComposter.remove(this.stack);
        }

        public String describe() {
            return "Removed item " + this.stack.func_77973_b().getRegistryName() + " from the list of valid Composter items.";
        }
    }

    private static class Add
    implements IAction {
        private final ItemStack stack;
        private final int rarity;

        private Add(IIngredient stack, int rarity) {
            this.stack = CraftTweakerMC.getItemStack((IIngredient)stack);
            this.rarity = rarity;
        }

        public void apply() {
            BlockComposter.ItemsForComposter.add(this.stack, this.rarity);
        }

        public String describe() {
            return "Adding recipe for item " + this.stack.func_82833_r();
        }
    }
}

