/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import net.minecraft.item.ItemStack;
import org.apache.logging.log4j.Level;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import thedarkcolour.futuremc.FutureMC;
import thedarkcolour.futuremc.block.BlockFurnaceAdvanced;

@ZenRegister
@ZenClass(value="mods.minecraftfuture.BlastFurnace")
public final class BlastFurnace {
    @ZenMethod
    public static void addRecipe(IItemStack input, IItemStack output) {
        if (!BlockFurnaceAdvanced.FurnaceType.BLAST_FURNACE.canCraft(CraftTweakerMC.getItemStack((IItemStack)input))) {
            CraftTweakerAPI.apply((IAction)new AddRecipe(input, output));
        } else {
            FutureMC.logger.log(Level.WARN, "Tried to add duplicate valid BlastFurnace input for " + input.getDefinition().getId());
        }
    }

    @ZenMethod
    public static void removeRecipe(IItemStack input) {
        CraftTweakerAPI.apply((IAction)new RemoveRecipe(input));
    }

    @ZenMethod
    public static void clearRecipes() {
        BlockFurnaceAdvanced.Recipes.clearBlastFurnace();
    }

    private static class RemoveRecipe
    implements IAction {
        private ItemStack input;

        private RemoveRecipe(IItemStack input) {
            this.input = CraftTweakerMC.getItemStack((IItemStack)input);
        }

        public void apply() {
            BlockFurnaceAdvanced.Recipes.removeBlastFurnaceRecipe(this.input);
        }

        public String describe() {
            return "Removed " + this.input.func_77973_b().getRegistryName() + " from smeltable items BlastFurnace";
        }
    }

    private static class AddRecipe
    implements IAction {
        private ItemStack input;
        private ItemStack output;

        private AddRecipe(IItemStack input, IItemStack output) {
            this.input = CraftTweakerMC.getItemStack((IItemStack)input);
            this.output = CraftTweakerMC.getItemStack((IItemStack)output);
        }

        public void apply() {
            BlockFurnaceAdvanced.Recipes.blastFurnaceRecipe(this.input, this.output);
        }

        public String describe() {
            return "Added " + this.input.func_77973_b().getRegistryName() + " to smeltable items BlastFurnace";
        }
    }
}

