/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.block.IBlock;
import crafttweaker.api.block.IBlockPattern;
import crafttweaker.api.minecraft.CraftTweakerMC;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import org.apache.logging.log4j.Level;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import thedarkcolour.core.util.PredicateArrayList;
import thedarkcolour.futuremc.FutureMC;
import thedarkcolour.futuremc.init.Init;

@ZenRegister
@ZenClass(value="mods.minecraftfuture.Bee")
public final class Bee {
    public static final PredicateArrayList<IBlock> FLOWERS = new PredicateArrayList<IBlock>(IBlockPattern::matches).addAll((IBlock[])new IBlock[]{CraftTweakerMC.getBlock((Block)Blocks.field_150327_N, (int)0), CraftTweakerMC.getBlock((Block)Blocks.field_150328_O, (int)0), CraftTweakerMC.getBlock((Block)Blocks.field_150328_O, (int)1), CraftTweakerMC.getBlock((Block)Blocks.field_150328_O, (int)2), CraftTweakerMC.getBlock((Block)Blocks.field_150328_O, (int)3), CraftTweakerMC.getBlock((Block)Blocks.field_150328_O, (int)4), CraftTweakerMC.getBlock((Block)Blocks.field_150328_O, (int)5), CraftTweakerMC.getBlock((Block)Blocks.field_150328_O, (int)6), CraftTweakerMC.getBlock((Block)Blocks.field_150328_O, (int)7), CraftTweakerMC.getBlock((Block)Blocks.field_150328_O, (int)8), CraftTweakerMC.getBlock((Block)Init.CORNFLOWER, (int)0), CraftTweakerMC.getBlock((Block)Init.LILY_OF_VALLEY, (int)0)});

    @ZenMethod
    public static void addFlower(IBlock block) {
        if (!FLOWERS.containsEquivalent(block)) {
            CraftTweakerAPI.apply(() -> FLOWERS.add(block));
        } else {
            FutureMC.logger.log(Level.ERROR, "Tried to add duplicate flower block to bee " + block.getDefinition().getId() + ":" + block.getMeta());
        }
    }

    @ZenMethod
    public static void removeFlower(IBlock block) {
        if (FLOWERS.containsEquivalent(block)) {
            CraftTweakerAPI.apply(() -> FLOWERS.add(block));
        } else {
            FutureMC.logger.log(Level.ERROR, "Tried to remove non pollinate-able flower block to bee " + block.getDefinition().getId() + ":" + block.getMeta());
        }
    }

    @ZenMethod
    public static void clearValidFlowers() {
        FLOWERS.clear();
    }

    private static interface RemoveFlower
    extends IAction {
        public void apply();

        default public String describe() {
            return "Removed a valid flower for bee pollination";
        }
    }

    private static interface AddFlower
    extends IAction {
        public void apply();

        default public String describe() {
            return "Added valid flower for bee pollination";
        }
    }
}

