/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.client.gui;

import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.Loader;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import thedarkcolour.core.gui.GuiContainer;
import thedarkcolour.futuremc.container.ContainerStonecutter;
import thedarkcolour.futuremc.init.FutureConfig;
import thedarkcolour.futuremc.recipe.StonecutterRecipe;

public class GuiStonecutter
extends GuiContainer<ContainerStonecutter> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("minecraftfuture", "textures/gui/stonecutter.png");
    private float sliderProgress;
    private boolean clickedOnScroll;
    private int recipeIndexOffset = 0;
    private boolean hasItemsInInputSlot;
    private static final boolean jeiLoaded = Loader.isModLoaded((String)"jei");

    public GuiStonecutter(ContainerStonecutter container) {
        super(container);
        this.container = container;
        container.setInventoryUpdateListener(this::onInventoryUpdate);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.Stonecutter", (Object[])new Object[0]), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(((ContainerStonecutter)this.container).getPlayerInv().func_145748_c_().func_150260_c(), 8, this.field_147000_g - 94, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        int scrollY = (int)(41.0f * this.sliderProgress);
        this.func_73729_b(i + 119, j + 15 + scrollY, 176 + (this.canScroll() ? 0 : 12), 0, 12, 15);
        if (jeiLoaded && FutureConfig.general.stonecutterRecipeButton) {
            this.drawRecipeButton(mouseX, mouseY, i, j);
        }
        if (((ContainerStonecutter)this.container).getCurrentRecipe() != null) {
            int x = this.field_147003_i + 52;
            int y = this.field_147009_r + 14;
            int k = this.recipeIndexOffset + 12;
            this.drawRecipesBackground(mouseX, mouseY, x, y, k);
            this.drawRecipesItems(x, y, k);
        }
    }

    private void drawRecipesBackground(int mouseX, int mouseY, int left, int top, int recipeIndexOffsetMax) {
        for (int i = this.recipeIndexOffset; i < recipeIndexOffsetMax && i < ((ContainerStonecutter)this.container).getCurrentRecipe().getTotalOutputs(); ++i) {
            int j = i - this.recipeIndexOffset;
            int k = left + j % 4 * 16;
            int l = j / 4;
            int i1 = top + l * 18 + 2;
            int j1 = this.field_147000_g;
            if (i == ((ContainerStonecutter)this.container).getSelectedIndex()) {
                j1 += 18;
            } else if (mouseX >= k && mouseY >= i1 && mouseX < k + 16 && mouseY < i1 + 18) {
                j1 += 36;
            }
            this.func_73729_b(k, i1 - 1, 0, j1, 16, 18);
        }
    }

    private void drawRecipesItems(int left, int top, int recipeIndexOffsetMax) {
        RenderHelper.func_74520_c();
        StonecutterRecipe recipe = ((ContainerStonecutter)this.container).getCurrentRecipe();
        for (int i = this.recipeIndexOffset; i < recipeIndexOffsetMax && i < ((ContainerStonecutter)this.container).getCurrentRecipe().getTotalOutputs(); ++i) {
            int j = i - this.recipeIndexOffset;
            int k = left + j % 4 * 16;
            int l = j / 4;
            int i1 = top + l * 18 + 2;
            this.field_146296_j.func_180450_b(recipe.getOutput(i), k, i1);
        }
        RenderHelper.func_74518_a();
    }

    private void drawRecipeButton(int mouseX, int mouseY, int i, int j) {
        int x = this.field_147003_i + 143;
        int y = this.field_147009_r + 8;
        int textureY = 166;
        if (mouseX >= x && mouseY >= y && mouseX < x + 16 && mouseY < y + 16) {
            textureY += 16;
        }
        this.func_73729_b(i + 143, j + 8, 16, textureY, 16, 16);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        this.clickedOnScroll = false;
        if (this.hasItemsInInputSlot) {
            int i = this.field_147003_i + 52;
            int j = this.field_147009_r + 14;
            int k = this.recipeIndexOffset + 12;
            for (int l = this.recipeIndexOffset; l < k; ++l) {
                int i1 = l - this.recipeIndexOffset;
                double x = (double)mouseX - (double)(i + i1 % 4 * 16);
                double y = (double)mouseY - (double)(j + i1 / 4 * 18);
                if (!(x >= 0.0) || !(y >= 0.0) || !(x < 16.0) || !(y < 18.0) || !((ContainerStonecutter)this.container).func_75140_a((EntityPlayer)this.field_146297_k.field_71439_g, l)) continue;
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                this.field_146297_k.field_71442_b.func_78756_a(((ContainerStonecutter)this.container).field_75152_c, l);
                return;
            }
            i = this.field_147003_i + 119;
            j = this.field_147009_r + 9;
            if ((double)mouseX >= (double)i && (double)mouseX < (double)(i + 12) && (double)mouseY >= (double)j && (double)mouseY < (double)(j + 54)) {
                this.clickedOnScroll = true;
            }
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        if (this.clickedOnScroll && this.canScroll()) {
            int i = this.field_147009_r + 14;
            int j = i + 54;
            this.sliderProgress = ((float)(mouseY - i) - 7.5f) / ((float)(j - i) - 15.0f);
            this.sliderProgress = MathHelper.func_76131_a((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)this.getHiddenRows()) + 0.5) << 2;
        }
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int i = Mouse.getEventDWheel();
        if (i != 0 && this.canScroll()) {
            i = (int)Math.signum(i);
            int h = this.getHiddenRows();
            this.sliderProgress = (float)((double)this.sliderProgress - (double)i / (double)h);
            this.sliderProgress = MathHelper.func_76131_a((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)h) + 0.5) * 4;
        }
    }

    private boolean canScroll() {
        return ((ContainerStonecutter)this.container).getCurrentRecipe() != null && this.hasItemsInInputSlot && ((ContainerStonecutter)this.container).getCurrentRecipe().getTotalOutputs() > 12;
    }

    private int getHiddenRows() {
        return (((ContainerStonecutter)this.container).getRecipeListSize() + 4 - 1) / 4 - 3;
    }

    private void onInventoryUpdate() {
        this.hasItemsInInputSlot = ((ContainerStonecutter)this.container).hasRecipe();
        if (!this.hasItemsInInputSlot) {
            this.sliderProgress = 0.0f;
            this.recipeIndexOffset = 0;
        }
    }
}

