/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.client.gui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BannerTextures;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import thedarkcolour.futuremc.container.ContainerLoom;

public class GuiLoom
extends GuiContainer {
    private static final ResourceLocation background = new ResourceLocation("minecraftfuture", "textures/gui/loom.png");
    private static final int NUM_BANNER_RECIPES = (BannerPattern.values().length - 5 - 1 + 4 - 1) / 4;
    private static final List<EnumDyeColor> color = Lists.newArrayList((Object[])new EnumDyeColor[]{EnumDyeColor.GRAY, EnumDyeColor.WHITE});
    private static final ResourceLocation[] designs = (ResourceLocation[])Arrays.stream(BannerPattern.values()).filter(pattern -> pattern != BannerPattern.BASE).map(pattern -> BannerTextures.field_178466_c.func_187478_a("b8" + pattern.func_190993_b() + "15", (List)Lists.newArrayList((Object[])new BannerPattern[]{BannerPattern.BASE, pattern}), color)).toArray(ResourceLocation[]::new);
    private final ContainerLoom container;
    private ResourceLocation bannerLocation;
    private boolean canScroll;
    private boolean field_214124_v;
    private boolean field_214125_w;
    private boolean clickedOnScroll;
    private ItemStack bannerStack = ItemStack.field_190927_a;
    private ItemStack colorStack = ItemStack.field_190927_a;
    private ItemStack patternStack = ItemStack.field_190927_a;
    private int recipeIndexOffset = 1;
    private float sliderProgress;

    public GuiLoom(ContainerLoom container) {
        super((Container)container);
        this.container = container;
        container.setInventoryUpdateListener(this::onInventoryUpdate);
    }

    public void func_73876_c() {
        super.func_73876_c();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String s = I18n.func_135052_a((String)"container.Loom", (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(s, 8, 4, 0x404040);
        this.field_146289_q.func_78276_b(this.container.getPlayerInv().func_145748_c_().func_150254_d(), 8, this.field_147000_g - 96 + 2, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(background);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        Slot output = this.container.getLoomSlot(3);
        this.drawSlotBackgrounds(i, j);
        int scrollY = (int)(41.0f * this.sliderProgress);
        this.func_73729_b(i + 119, j + 13 + scrollY, 232 + (this.canScroll ? 0 : 12), 0, 12, 15);
        if (this.bannerLocation != null && !this.field_214125_w) {
            this.field_146297_k.func_110434_K().func_110577_a(this.bannerLocation);
            this.field_73735_i = 20.0f;
            this.func_73729_b(i + 141, j + 8, 20, 40, 20, 40);
            this.field_73735_i = 0.0f;
        } else if (this.field_214125_w) {
            this.func_73729_b(i + output.field_75223_e - 2, j + output.field_75221_f - 2, this.field_146999_f, 17, 17, 16);
        }
        if (this.canScroll) {
            int l = i + 60;
            int i1 = j + 13;
            int j1 = this.recipeIndexOffset + 16;
            for (int k1 = this.recipeIndexOffset; k1 < j1 && k1 < designs.length - 5; ++k1) {
                int l1 = k1 - this.recipeIndexOffset;
                int i2 = l + l1 % 4 * 14;
                int j2 = i1 + l1 / 4 * 14;
                this.field_146297_k.func_110434_K().func_110577_a(background);
                int k2 = this.field_147000_g;
                if (k1 == this.container.getSelectedIndex()) {
                    k2 += 14;
                } else if (mouseX >= i2 && mouseY >= j2 && mouseX < i2 + 14 && mouseY < j2 + 14) {
                    k2 += 28;
                }
                this.func_73729_b(i2, j2, 0, k2, 14, 14);
                if (designs[k1] == null) continue;
                this.field_146297_k.func_110434_K().func_110577_a(designs[k1]);
                this.func_73729_b(i2 + 4, j2 + 2, 5, 10, 20, 40);
            }
        } else if (this.field_214124_v) {
            int l2 = i + 60;
            int i3 = j + 13;
            this.field_146297_k.func_110434_K().func_110577_a(background);
            this.func_73729_b(l2, i3, 0, this.field_147000_g, 14, 14);
            int j3 = this.container.getSelectedIndex();
            if (designs[j3] != null) {
                this.field_146297_k.func_110434_K().func_110577_a(designs[j3]);
                this.func_73729_b(l2 + 4, i3 + 2, 5, 10, 20, 40);
            }
        }
    }

    public void drawSlotBackgrounds(int i, int j) {
        Slot banner = this.container.getLoomSlot(0);
        Slot color = this.container.getLoomSlot(1);
        Slot pattern = this.container.getLoomSlot(2);
        if (!banner.func_75216_d()) {
            this.func_73729_b(i + banner.field_75223_e, j + banner.field_75221_f, this.field_146999_f, 0, 16, 16);
        }
        if (!color.func_75216_d()) {
            this.func_73729_b(i + color.field_75223_e, j + color.field_75221_f, this.field_146999_f + 16, 0, 16, 16);
        }
        if (!pattern.func_75216_d()) {
            this.func_73729_b(i + pattern.field_75223_e, j + pattern.field_75221_f, this.field_146999_f + 32, 0, 16, 16);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        this.clickedOnScroll = false;
        if (this.canScroll) {
            int i = this.field_147003_i + 60;
            int j = this.field_147009_r + 13;
            int k = this.recipeIndexOffset + 16;
            for (int l = this.recipeIndexOffset; l < k; ++l) {
                int i1 = l - this.recipeIndexOffset;
                double x = (double)mouseX - (double)(i + i1 % 4 * 14);
                double y = (double)mouseY - (double)(j + i1 / 4 * 14);
                if (!(x >= 0.0) || !(y >= 0.0) || !(x < 14.0) || !(y < 14.0) || !this.container.func_75140_a((EntityPlayer)this.field_146297_k.field_71439_g, l)) continue;
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                this.field_146297_k.field_71442_b.func_78756_a(this.container.field_75152_c, l);
                return;
            }
            i = this.field_147003_i + 119;
            j = this.field_147009_r + 9;
            if ((double)mouseX >= (double)i && (double)mouseX < (double)(i + 12) && (double)mouseY >= (double)j && (double)mouseY < (double)(j + 56)) {
                this.clickedOnScroll = true;
            }
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        if (this.clickedOnScroll && this.canScroll) {
            int i = this.field_147009_r + 13;
            int j = i + 56;
            this.sliderProgress = ((float)(mouseY - i) - 7.5f) / ((float)(j - i) - 15.0f);
            this.sliderProgress = MathHelper.func_76131_a((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)this.getHiddenRows()) + 0.5) << 2;
        }
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int i = Mouse.getEventDWheel();
        if (i != 0 && this.canScroll) {
            i = (int)Math.signum(i);
            int h = this.getHiddenRows();
            this.sliderProgress = (float)((double)this.sliderProgress - (double)i / (double)h);
            this.sliderProgress = MathHelper.func_76131_a((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = 1 + (int)((double)(this.sliderProgress * (float)h) + 0.5) * 4;
        }
    }

    private int getHiddenRows() {
        return NUM_BANNER_RECIPES - 4;
    }

    protected boolean func_193983_c(int param1, int param2, int param3, int param4) {
        return param1 < param3 || param2 < param4 || param1 >= param3 + this.field_146999_f || param2 >= param4 + this.field_147000_g;
    }

    private void onInventoryUpdate() {
        ItemStack itemstack = this.container.getOutput();
        if (itemstack.func_190926_b()) {
            this.bannerLocation = null;
        } else {
            TileEntityBanner te = new TileEntityBanner();
            te.func_175112_a(itemstack, false);
            this.bannerLocation = BannerTextures.field_178466_c.func_187478_a(te.func_175116_e(), te.func_175114_c(), te.func_175110_d());
        }
        ItemStack stack = this.container.getBanner();
        ItemStack stack1 = this.container.getColor();
        ItemStack stack2 = this.container.getPattern();
        NBTTagCompound tag = stack.func_190925_c("BlockEntityTag");
        boolean bl = this.field_214125_w = tag.func_150297_b("Patterns", 9) && !stack.func_190926_b() && this.canFitPatterns(tag.func_150295_c("Patterns", 10));
        if (this.field_214125_w) {
            this.bannerLocation = null;
        }
        if (!(ItemStack.func_77989_b((ItemStack)stack, (ItemStack)this.bannerStack) && ItemStack.func_77989_b((ItemStack)stack1, (ItemStack)this.colorStack) && ItemStack.func_77989_b((ItemStack)stack2, (ItemStack)this.patternStack))) {
            this.canScroll = !stack.func_190926_b() && !stack1.func_190926_b() && stack2.func_190926_b() && !this.field_214125_w;
            this.field_214124_v = !this.field_214125_w && !stack2.func_190926_b() && !stack.func_190926_b() && !stack1.func_190926_b();
        }
        this.bannerStack = stack.func_77946_l();
        this.colorStack = stack1.func_77946_l();
        this.patternStack = stack2.func_77946_l();
    }

    private boolean canFitPatterns(NBTTagList list) {
        int i = 0;
        for (NBTBase ignored : list) {
            ++i;
        }
        return i <= 6;
    }
}

