/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thedarkcolour.core.block.BlockBase;
import thedarkcolour.futuremc.init.Init;
import thedarkcolour.futuremc.sound.Sounds;

public class BlockScaffold
extends BlockBase {
    public static final PropertyInteger DISTANCE = PropertyInteger.func_177719_a((String)"distance", (int)0, (int)7);
    public static final PropertyBool BOTTOM = PropertyBool.func_177716_a((String)"bottom");
    private static final AxisAlignedBB TOP_AABB = BlockScaffold.makeAABB(0.0, 14.0, 0.0, 16.0, 16.0, 16.0);
    private AxisAlignedBB BOTTOM_AABB = BlockScaffold.makeAABB(0.0, 0.0, 0.0, 16.0, 2.0, 16.0);
    static AxisAlignedBB[] boundingBoxesA = new AxisAlignedBB[5];
    static AxisAlignedBB[] boundingBoxesB;

    public BlockScaffold() {
        super("scaffolding", Material.field_151594_q, Sounds.SCAFFOLDING);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        int i = BlockScaffold.getDistance(worldIn, pos);
        return this.func_176223_P().func_177226_a((IProperty)DISTANCE, (Comparable)Integer.valueOf(i)).func_177226_a((IProperty)BOTTOM, (Comparable)Boolean.valueOf(this.func_220116_a(worldIn, pos, i)));
    }

    private boolean func_220116_a(World worldIn, BlockPos pos, int i) {
        return i > 0 && worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() != this;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            worldIn.func_175684_a(pos, (Block)this, 1);
        }
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        block3: {
            block2: {
                if (!this.shouldBlock(entityIn)) break block2;
                for (AxisAlignedBB box : boundingBoxesA) {
                    BlockScaffold.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)box);
                }
                break block3;
            }
            if ((Integer)state.func_177229_b((IProperty)DISTANCE) == 0 || !((Boolean)state.func_177229_b((IProperty)BOTTOM)).booleanValue()) break block3;
            for (AxisAlignedBB box : boundingBoxesB) {
                BlockScaffold.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)box);
            }
        }
    }

    private boolean shouldBlock(Entity entityIn) {
        return entityIn != null && !entityIn.func_70093_af() && entityIn instanceof EntityPlayer;
    }

    public static int getDistance(World worldIn, BlockPos pos) {
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(pos).func_189536_c(EnumFacing.DOWN);
        IBlockState blockstate = worldIn.func_180495_p((BlockPos)blockPos);
        int i = 7;
        if (blockstate.func_177230_c() == Init.SCAFFOLDING) {
            i = (Integer)blockstate.func_177229_b((IProperty)DISTANCE);
        } else if (blockstate.func_177230_c().isSideSolid(blockstate, (IBlockAccess)worldIn, (BlockPos)blockPos, EnumFacing.UP)) {
            return 0;
        }
        for (EnumFacing direction : EnumFacing.Plane.HORIZONTAL) {
            IBlockState blockstate1 = worldIn.func_180495_p((BlockPos)blockPos.func_189533_g((Vec3i)pos).func_189536_c(direction));
            if (blockstate1.func_177230_c() != Init.SCAFFOLDING || (i = Math.min(i, (Integer)blockstate1.func_177229_b((IProperty)DISTANCE) + 1)) != 1) continue;
            break;
        }
        return i;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.field_72995_K) {
            worldIn.func_175684_a(pos, (Block)this, 1);
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        int i = BlockScaffold.getDistance(worldIn, pos);
        IBlockState blockstate = state.func_177226_a((IProperty)DISTANCE, (Comparable)Integer.valueOf(i)).func_177226_a((IProperty)BOTTOM, (Comparable)Boolean.valueOf(this.func_220116_a(worldIn, pos, i)));
        if ((Integer)blockstate.func_177229_b((IProperty)DISTANCE) == 7) {
            if ((Integer)state.func_177229_b((IProperty)DISTANCE) == 7) {
                worldIn.func_72838_d((Entity)new EntityFallingBlock(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, state));
            } else {
                worldIn.func_175655_b(pos, true);
            }
        } else if (state != blockstate) {
            worldIn.func_180501_a(pos, blockstate, 3);
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return BlockScaffold.getDistance(worldIn, pos) < 7;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return true;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DISTANCE, BOTTOM});
    }

    public IBlockState func_176203_a(int meta) {
        boolean bottom = meta > 7;
        int distance = bottom ? meta - 8 : meta;
        return this.func_176223_P().func_177226_a((IProperty)BOTTOM, (Comparable)Boolean.valueOf(bottom)).func_177226_a((IProperty)DISTANCE, (Comparable)Integer.valueOf(distance));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BOTTOM) != false ? (Integer)state.func_177229_b((IProperty)DISTANCE) + 8 : (Integer)state.func_177229_b((IProperty)DISTANCE);
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    static {
        BlockScaffold.boundingBoxesA[0] = BlockScaffold.makeAABB(0.0, 14.0, 0.0, 16.0, 16.0, 16.0);
        BlockScaffold.boundingBoxesA[1] = BlockScaffold.makeAABB(0.0, 0.0, 0.0, 2.0, 16.0, 2.0);
        BlockScaffold.boundingBoxesA[2] = BlockScaffold.makeAABB(14.0, 0.0, 0.0, 16.0, 16.0, 2.0);
        BlockScaffold.boundingBoxesA[3] = BlockScaffold.makeAABB(0.0, 0.0, 14.0, 2.0, 16.0, 16.0);
        BlockScaffold.boundingBoxesA[4] = BlockScaffold.makeAABB(14.0, 0.0, 14.0, 16.0, 16.0, 16.0);
        boundingBoxesB = new AxisAlignedBB[4];
        BlockScaffold.boundingBoxesB[0] = BlockScaffold.makeAABB(0.0, 0.0, 0.0, 2.0, 2.0, 16.0);
        BlockScaffold.boundingBoxesB[1] = BlockScaffold.makeAABB(14.0, 0.0, 0.0, 16.0, 2.0, 16.0);
        BlockScaffold.boundingBoxesB[2] = BlockScaffold.makeAABB(0.0, 0.0, 14.0, 16.0, 2.0, 16.0);
        BlockScaffold.boundingBoxesB[3] = BlockScaffold.makeAABB(0.0, 0.0, 0.0, 16.0, 2.0, 2.0);
    }
}

