/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thedarkcolour.core.block.BlockBase;
import thedarkcolour.futuremc.FutureMC;
import thedarkcolour.futuremc.init.FutureConfig;
import thedarkcolour.futuremc.sound.Sounds;

public class BlockHoneyBlock
extends BlockBase {
    private static final AxisAlignedBB AABB = BlockHoneyBlock.makeAABB(1.0, 0.0, 1.0, 15.0, 15.0, 15.0);

    public BlockHoneyBlock() {
        super("honey_block", Material.field_151571_B, MapColor.field_151676_q, Sounds.HONEY_BLOCK);
        this.setHardness(0.0f);
        this.setCreativeTab((CreativeTabs)(FutureConfig.general.useVanillaTabs ? CreativeTabs.field_78031_c : FutureMC.TAB));
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return AABB;
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        this.fallParticles(worldIn, pos, entityIn);
        entityIn.func_180430_e(fallDistance, 1.0f);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (this.slide(pos, entityIn)) {
            if (entityIn.field_70181_x < -0.05) {
                entityIn.field_70181_x = -0.05;
            }
            entityIn.field_70143_R = 0.0f;
            this.slideParticles(worldIn, pos, entityIn);
            if (worldIn.func_72820_D() % 10L == 0L) {
                entityIn.func_184185_a(Sounds.HONEY_BLOCK_SLIDE, 1.0f, 1.0f);
            }
        }
        super.func_180634_a(worldIn, pos, state, entityIn);
    }

    private boolean slide(BlockPos pos, Entity entity) {
        if (entity.field_70122_E) {
            return false;
        }
        if (entity.field_70163_u > (double)pos.func_177956_o() + 0.9375 - 1.0E-7) {
            return false;
        }
        if (entity.field_70181_x >= 0.0) {
            return false;
        }
        double x = Math.abs((double)pos.func_177958_n() + 0.5 - entity.field_70165_t);
        double y = Math.abs((double)pos.func_177952_p() + 0.5 - entity.field_70161_v);
        double double_3 = 0.4375 + (double)(entity.field_70130_N / 2.0f);
        return x + 1.0E-7 > double_3 || y + 1.0E-7 > double_3;
    }

    private void slideParticles(World worldIn, BlockPos pos, Entity entityIn) {
        float width = entityIn.field_70130_N;
        this.spawnParticles(entityIn, worldIn, pos, 1, ((double)worldIn.field_73012_v.nextFloat() - 0.5) * (double)width, worldIn.field_73012_v.nextFloat() / 2.0f, ((double)worldIn.field_73012_v.nextFloat() - 0.5) * (double)width, (double)worldIn.field_73012_v.nextFloat() - 0.5, worldIn.field_73012_v.nextFloat() - 1.0f, (double)worldIn.field_73012_v.nextFloat() - 0.5);
    }

    private void fallParticles(World worldIn, BlockPos pos, Entity entityIn) {
        float width = entityIn.field_70130_N;
        this.spawnParticles(entityIn, worldIn, pos, 10, ((double)worldIn.field_73012_v.nextFloat() - 0.5) * (double)width, 0.0, ((double)worldIn.field_73012_v.nextFloat() - 0.5) * (double)width, (double)worldIn.field_73012_v.nextFloat() - 0.5, 0.5, (double)worldIn.field_73012_v.nextFloat() - 0.5);
    }

    private void spawnParticles(Entity entity, World worldIn, BlockPos pos, int numOfParticles, double double_1, double double_2, double double_3, double double_4, double double_5, double double_6) {
        for (int i = 0; i < numOfParticles; ++i) {
            worldIn.func_175688_a(EnumParticleTypes.BLOCK_CRACK, entity.field_70165_t + double_1, entity.field_70163_u + double_2, entity.field_70161_v + double_3, double_4, double_5, double_6, new int[]{Block.func_176210_f((IBlockState)this.func_176223_P())});
        }
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return blockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c() == this || super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean isStickyBlock(IBlockState state) {
        return true;
    }
}

