/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thedarkcolour.core.block.BlockBase;
import thedarkcolour.core.gui.Gui;
import thedarkcolour.futuremc.FutureMC;
import thedarkcolour.futuremc.init.FutureConfig;

public class BlockGrindstone
extends BlockBase {
    private static final PropertyEnum<EnumAttachment> ATTACHMENT = PropertyEnum.func_177709_a((String)"face", EnumAttachment.class);
    private static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public BlockGrindstone() {
        super("Grindstone");
        this.setHardness(3.5f);
        this.setCreativeTab((CreativeTabs)(FutureConfig.general.useVanillaTabs ? CreativeTabs.field_78031_c : FutureMC.TAB));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        Gui.GRINDSTONE.open(playerIn, worldIn, pos);
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BlockGrindstone.createBoundingBox((EnumAttachment)((Object)state.func_177229_b(ATTACHMENT)), (EnumFacing)state.func_177229_b((IProperty)FACING));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ATTACHMENT, FACING});
    }

    public IBlockState func_176203_a(int meta) {
        switch (meta) {
            default: {
                return this.func_176194_O().func_177621_b().func_177226_a(ATTACHMENT, (Comparable)((Object)EnumAttachment.FLOOR)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH);
            }
            case 1: {
                return this.func_176194_O().func_177621_b().func_177226_a(ATTACHMENT, (Comparable)((Object)EnumAttachment.FLOOR)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.EAST);
            }
            case 2: {
                return this.func_176194_O().func_177621_b().func_177226_a(ATTACHMENT, (Comparable)((Object)EnumAttachment.FLOOR)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH);
            }
            case 3: {
                return this.func_176194_O().func_177621_b().func_177226_a(ATTACHMENT, (Comparable)((Object)EnumAttachment.FLOOR)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.WEST);
            }
            case 4: {
                return this.func_176194_O().func_177621_b().func_177226_a(ATTACHMENT, (Comparable)((Object)EnumAttachment.WALL)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH);
            }
            case 5: {
                return this.func_176194_O().func_177621_b().func_177226_a(ATTACHMENT, (Comparable)((Object)EnumAttachment.WALL)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.EAST);
            }
            case 6: {
                return this.func_176194_O().func_177621_b().func_177226_a(ATTACHMENT, (Comparable)((Object)EnumAttachment.WALL)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH);
            }
            case 7: {
                return this.func_176194_O().func_177621_b().func_177226_a(ATTACHMENT, (Comparable)((Object)EnumAttachment.WALL)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.WEST);
            }
            case 8: {
                return this.func_176194_O().func_177621_b().func_177226_a(ATTACHMENT, (Comparable)((Object)EnumAttachment.CEILING)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH);
            }
            case 9: {
                return this.func_176194_O().func_177621_b().func_177226_a(ATTACHMENT, (Comparable)((Object)EnumAttachment.CEILING)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.EAST);
            }
            case 10: {
                return this.func_176194_O().func_177621_b().func_177226_a(ATTACHMENT, (Comparable)((Object)EnumAttachment.CEILING)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH);
            }
            case 11: 
        }
        return this.func_176194_O().func_177621_b().func_177226_a(ATTACHMENT, (Comparable)((Object)EnumAttachment.CEILING)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.WEST);
    }

    public int func_176201_c(IBlockState state) {
        switch ((EnumAttachment)((Object)state.func_177229_b(ATTACHMENT))) {
            case WALL: {
                switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
                    default: {
                        return 4;
                    }
                    case EAST: {
                        return 5;
                    }
                    case SOUTH: {
                        return 6;
                    }
                    case WEST: 
                }
                return 7;
            }
            case CEILING: {
                switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
                    default: {
                        return 8;
                    }
                    case EAST: {
                        return 9;
                    }
                    case SOUTH: {
                        return 10;
                    }
                    case WEST: 
                }
                return 11;
            }
        }
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            default: {
                return 0;
            }
            case EAST: {
                return 1;
            }
            case SOUTH: {
                return 2;
            }
            case WEST: 
        }
        return 3;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumAttachment attachment = EnumAttachment.getFromFacing(facing);
        EnumFacing finalFacing = placer.func_174811_aO();
        if (attachment == EnumAttachment.WALL) {
            finalFacing = facing;
        }
        return this.func_176194_O().func_177621_b().func_177226_a(ATTACHMENT, (Comparable)((Object)attachment)).func_177226_a((IProperty)FACING, (Comparable)finalFacing);
    }

    public static AxisAlignedBB createBoundingBox(EnumAttachment attachment, EnumFacing facing) {
        AxisAlignedBB FLOOR_X = BlockGrindstone.makeAABB(2.0, 4.0, 4.0, 14.0, 16.0, 12.0);
        AxisAlignedBB FLOOR_Z = BlockGrindstone.makeAABB(4.0, 4.0, 2.0, 12.0, 16.0, 14.0);
        AxisAlignedBB CEILING_X = BlockGrindstone.makeAABB(2.0, 0.0, 4.0, 14.0, 12.0, 12.0);
        AxisAlignedBB CEILING_Z = BlockGrindstone.makeAABB(4.0, 0.0, 2.0, 12.0, 12.0, 14.0);
        AxisAlignedBB WALL_NORTH = BlockGrindstone.makeAABB(4.0, 2.0, 0.0, 12.0, 14.0, 12.0);
        AxisAlignedBB WALL_WEST = BlockGrindstone.makeAABB(0.0, 2.0, 4.0, 12.0, 14.0, 12.0);
        AxisAlignedBB WALL_SOUTH = BlockGrindstone.makeAABB(4.0, 2.0, 4.0, 12.0, 14.0, 16.0);
        AxisAlignedBB WALL_EAST = BlockGrindstone.makeAABB(4.0, 2.0, 4.0, 16.0, 14.0, 12.0);
        switch (attachment) {
            case FLOOR: {
                switch (facing) {
                    case SOUTH: 
                    case NORTH: {
                        return FLOOR_Z;
                    }
                    case EAST: 
                    case WEST: {
                        return FLOOR_X;
                    }
                }
            }
            case WALL: {
                switch (facing) {
                    case EAST: {
                        return WALL_EAST;
                    }
                    case WEST: {
                        return WALL_WEST;
                    }
                    case NORTH: {
                        return WALL_NORTH;
                    }
                    case SOUTH: {
                        return WALL_SOUTH;
                    }
                }
            }
            case CEILING: {
                switch (facing) {
                    case SOUTH: 
                    case NORTH: {
                        return CEILING_Z;
                    }
                    case EAST: 
                    case WEST: {
                        return CEILING_X;
                    }
                }
            }
        }
        return field_185506_k;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public static enum EnumAttachment implements IStringSerializable
    {
        WALL("wall"),
        FLOOR("floor"),
        CEILING("ceiling");

        public String name;

        private EnumAttachment(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static EnumAttachment getFromFacing(EnumFacing facing) {
            if (facing == EnumFacing.DOWN) {
                return CEILING;
            }
            if (facing == EnumFacing.UP) {
                return FLOOR;
            }
            return WALL;
        }
    }
}

