/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thedarkcolour.core.block.BlockBase;
import thedarkcolour.core.gui.Gui;
import thedarkcolour.futuremc.FutureMC;
import thedarkcolour.futuremc.init.FutureConfig;
import thedarkcolour.futuremc.init.Init;
import thedarkcolour.futuremc.tile.TileFurnaceAdvanced;

public class BlockFurnaceAdvanced
extends BlockBase
implements ITileEntityProvider {
    public static final PropertyBool LIT = PropertyBool.func_177716_a((String)"lit");
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private FurnaceType type;

    public BlockFurnaceAdvanced(FurnaceType type) {
        super(type.getName());
        this.setHardness(3.5f);
        this.setCreativeTab((CreativeTabs)(FutureConfig.general.useVanillaTabs ? CreativeTabs.field_78031_c : FutureMC.TAB));
        this.type = type;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        if (this.type == FurnaceType.SMOKER) {
            return new TileFurnaceAdvanced.TileSmoker();
        }
        if (this.type == FurnaceType.BLAST_FURNACE) {
            return new TileFurnaceAdvanced.TileBlastFurnace();
        }
        return null;
    }

    public int func_149750_m(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false ? 13 : 0;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (!(te instanceof TileFurnaceAdvanced)) {
            return false;
        }
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        if (block == Init.BLAST_FURNACE && !(te instanceof TileFurnaceAdvanced.TileBlastFurnace)) {
            return false;
        }
        if (block == Init.SMOKER && !(te instanceof TileFurnaceAdvanced.TileSmoker)) {
            return false;
        }
        Gui.FURNACE.open(playerIn, worldIn, pos);
        return true;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, LIT});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf((meta & 4) != 0)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 0xFFFFFFFB)));
    }

    public int func_176201_c(IBlockState state) {
        return ((Boolean)state.func_177229_b((IProperty)LIT) != false ? 4 : 0) | ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false));
    }

    public static void setState(boolean active, World world, BlockPos pos) {
        if (world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof TileFurnaceAdvanced) {
            world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(active)));
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileFurnaceAdvanced) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((TileFurnaceAdvanced)tile));
        }
        worldIn.func_175713_t(pos);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((IProperty)LIT)).booleanValue()) {
            EnumFacing enumfacing = (EnumFacing)stateIn.func_177229_b((IProperty)FACING);
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 6.0 / 16.0;
            double d2 = (double)pos.func_177952_p() + 0.5;
            double d3 = rand.nextDouble() * 0.6 - 0.3;
            if (rand.nextDouble() < 0.1) {
                worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            if (worldIn.func_180495_p(pos).func_177230_c() == Init.SMOKER) {
                switch (enumfacing) {
                    case WEST: {
                        worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 - 0.52, d1, d2 + d3, 0.0, 0.0, 0.0, new int[0]);
                        worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 - 0.52, d1, d2 + d3, 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                    case EAST: {
                        worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + 0.52, d1, d2 + d3, 0.0, 0.0, 0.0, new int[0]);
                        worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + 0.52, d1, d2 + d3, 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                    case NORTH: {
                        worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d3, d1, d2 - 0.52, 0.0, 0.0, 0.0, new int[0]);
                        worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + d3, d1, d2 - 0.52, 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                    case SOUTH: {
                        worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d3, d1, d2 + 0.52, 0.0, 0.0, 0.0, new int[0]);
                        worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + d3, d1, d2 + 0.52, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
            }
        }
    }

    public static class Recipe {
        public final ItemStack input;
        public final ItemStack output;

        public Recipe(ItemStack input, ItemStack output) {
            this.input = input;
            this.output = output;
        }
    }

    public static final class Recipes {
        private static final ArrayList<Recipe> SMOKER_RECIPES = Lists.newArrayListWithExpectedSize((int)8);
        private static final ArrayList<Recipe> BLAST_FURNACE_RECIPES = Lists.newArrayListWithExpectedSize((int)8);

        public static void init() {
            Recipes.smokerRecipe(new ItemStack(Items.field_151115_aP), new ItemStack(Items.field_179566_aV));
            Recipes.smokerRecipe(new ItemStack(Items.field_151076_bf), new ItemStack(Items.field_151077_bg));
            Recipes.smokerRecipe(new ItemStack(Items.field_151147_al), new ItemStack(Items.field_151157_am));
            Recipes.smokerRecipe(new ItemStack(Items.field_151115_aP, 1, 1), new ItemStack(Items.field_179566_aV, 1, 1));
            Recipes.smokerRecipe(new ItemStack(Items.field_151082_bd), new ItemStack(Items.field_151083_be));
            Recipes.smokerRecipe(new ItemStack(Items.field_179561_bm), new ItemStack(Items.field_179557_bn));
            Recipes.smokerRecipe(new ItemStack(Items.field_179558_bo), new ItemStack(Items.field_179559_bp));
            Recipes.smokerRecipe(new ItemStack(Items.field_151174_bG), new ItemStack(Items.field_151168_bH));
            Recipes.blastFurnaceRecipe(new ItemStack(Blocks.field_150365_q), new ItemStack(Items.field_151044_h));
            Recipes.blastFurnaceRecipe(new ItemStack(Blocks.field_150366_p), new ItemStack(Items.field_151042_j));
            Recipes.blastFurnaceRecipe(new ItemStack(Blocks.field_150482_ag), new ItemStack(Items.field_151045_i));
            Recipes.blastFurnaceRecipe(new ItemStack(Blocks.field_150412_bA), new ItemStack(Items.field_151166_bC));
            Recipes.blastFurnaceRecipe(new ItemStack(Blocks.field_150352_o), new ItemStack(Items.field_151043_k));
            Recipes.blastFurnaceRecipe(new ItemStack(Blocks.field_150369_x), new ItemStack(Items.field_151100_aR, 1, 4));
            Recipes.blastFurnaceRecipe(new ItemStack(Blocks.field_150450_ax), new ItemStack(Items.field_151137_ax));
            Recipes.blastFurnaceRecipe(new ItemStack(Blocks.field_150449_bY), new ItemStack(Items.field_151128_bU));
        }

        public static void blastFurnaceRecipe(ItemStack input, ItemStack output) {
            BLAST_FURNACE_RECIPES.add(new Recipe(input, output));
        }

        public static void smokerRecipe(ItemStack input, ItemStack output) {
            SMOKER_RECIPES.add(new Recipe(input, output));
        }

        public static ArrayList<Recipe> getSmokerRecipes() {
            return SMOKER_RECIPES;
        }

        public static ArrayList<Recipe> getBlastFurnaceRecipes() {
            return BLAST_FURNACE_RECIPES;
        }

        public static void removeSmokerRecipe(ItemStack input) {
            SMOKER_RECIPES.removeIf(recipe -> recipe.input.func_77969_a(input));
        }

        public static void removeBlastFurnaceRecipe(ItemStack input) {
            BLAST_FURNACE_RECIPES.removeIf(recipe -> recipe.input.func_77969_a(input));
        }

        public static void clearSmoker() {
            SMOKER_RECIPES.clear();
        }

        public static void clearBlastFurnace() {
            BLAST_FURNACE_RECIPES.clear();
        }
    }

    public static enum FurnaceType {
        SMOKER("Smoker"),
        BLAST_FURNACE("Blast_Furnace");

        private String name;

        private FurnaceType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean canCraft(ItemStack stack) {
            if (this == BLAST_FURNACE) {
                return Recipes.BLAST_FURNACE_RECIPES.stream().anyMatch(recipe -> recipe.input.func_77969_a(stack));
            }
            if (this == SMOKER) {
                return Recipes.SMOKER_RECIPES.stream().anyMatch(recipe -> recipe.input.func_77969_a(stack));
            }
            throw new IllegalStateException("Invalid Smoker/Blast Furnace state");
        }
    }
}

